<?php
/**
 * Project:     Guesswork: the PHP lightweight web framework
 * File:        Guesswork.php
 *
 * @link http://www.guesswork.jp/
 * @copyright 2004 Serverworks Co.,Ltd.
 * @author OGURA Junya <juno@bmedianode.com>
 * @package Guesswork
 * @version $Id$
 */

require_once 'PEAR.php';

define('LIB_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);
define('GUESSWORK_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Guesswork');

// Controller
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'Controller.class.php');

// Internals
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'Request.php');
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'UploadFile.class.php');

// Utilities
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'ExpressionUtil.class.php');
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'Logger.class.php');
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'Utils.class.php');
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'Validator.class.php');

// View
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'AbstractView.class.php');
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'HtmlTemplateView.class.php');
require_once(GUESSWORK_DIR . DIRECTORY_SEPARATOR . 'SmartyView.class.php');

define('GW_SESSION_FLASH_KEY', 'jp.guesswork.session.flash');
define('GW_SESSION_FLASHES_KEY', 'jp.guesswork.session.flashes');

define('GW_CONTINUE_PROCESS', 1);
define('GW_TERMINATE_PROCESS', 2);

// log level
define('GW_LOG_TRACE', 1);
define('GW_LOG_DEBUG', 2);
define('GW_LOG_INFO', 3);
define('GW_LOG_WARN', 4);
define('GW_LOG_ERROR', 5);
define('GW_LOG_FATAL', 6);
?>
