<?php
/**
 * HtmlTemplate view class.
 * @author OGURA Junya
 * @since Oct 18, 2004
 * @version $Revision$
 */
class HtmlTemplateView extends AbstractView
{
    /** Template directory path */
    var $templateDir = null;

    /** Result string */
    var $result = null;

    /**
     * Initialize view instance.
     * @access public
     * @param array $config Configuration values
     * @return boolean
     */
    function init($config)
    {
        if (array_key_exists('htmltemplate.templateDir', $config)) {
            $this->templateDir = $config['htmltemplate.templateDir'];
        }

        return true;
    }

    /**
     * @access public
     * @param string $template Path to template file
     * @param array $model Array of model values
     * @return boolean
     */
    function process($template, $model)
    {
        $this->result = htmltemplate::t_buffer($this->templateDir . $template, $model);

        return true;
    }

    /**
     * @access public
     * @return string
     */
    function getResult()
    {
        return $this->result;
    }

    function isTemplateExists($template)
    {
        return file_exists($this->templateDir . DIRECTORY_SEPARATOR . $template);
    }
}
?>
