/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.DisableFlag;
import com.google.appengine.repackaged.com.google.common.base.Flag;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagsException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public class Flags {
    private static final Logger logger = Logger.getLogger(Flags.class.getName());
    private static Set<Field> registeredFields = new HashSet<Field>();
    private static Collection<Flag> allFlags = new ArrayList<Flag>();
    private static Set<Pair<String, String>> registeredMethods = new HashSet<Pair<String, String>>();
    private static Set<Class<?>> alreadyRegistered = new HashSet();

    @Deprecated
    public Flags() {
        logger.fine("Note: com.google.common.base.Flags is deprecated.  Use com.google.common.flags instead.");
        try {
            registeredFields.clear();
            registeredMethods.clear();
            alreadyRegistered.clear();
            Class<com.google.appengine.repackaged.com.google.common.flags.Flags> newFlags = com.google.appengine.repackaged.com.google.common.flags.Flags.class;
            Method reset = newFlags.getDeclaredMethod("clearFlagMapsForTesting", new Class[0]);
            reset.setAccessible(true);
            reset.invoke(null, new Object[0]);
            allFlags.clear();
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Deprecated
    public Flags(Object[] registerClasses) {
        this();
        for (Object registerClass : registerClasses) {
            this.register(registerClass);
        }
    }

    public void usage() {
        com.google.appengine.repackaged.com.google.common.flags.Flags.usage((PrintStream)System.err);
    }

    public void register(Class<?> cl) {
        this.register(cl, null);
    }

    public void register(Object o) {
        if (o instanceof Class) {
            this.register((Class)o);
        } else {
            this.register(o.getClass(), o);
        }
    }

    public void registerIncludeDerived(Class<?> cl) {
        this.register(cl, null, true);
    }

    private void register(Class<?> cl, Object object) {
        this.register(cl, object, false);
    }

    private void register(Class<?> cl, Object object, boolean forceInherited) {
        if (object == null) {
            com.google.appengine.repackaged.com.google.common.flags.Flags.addPreferredClass((String)cl.getName());
        }
        Flags.registerUpdateFlags(cl, object);
        Field[] fields = object == null && !forceInherited ? cl.getDeclaredFields() : cl.getFields();
        for (Field f : fields) {
            String name;
            f.setAccessible(true);
            if (object == null != Modifier.isStatic(f.getModifiers()) || !(name = f.getName()).startsWith("FLAG_") || f.getAnnotation(DisableFlag.class) != null) continue;
            try {
                if (!registeredFields.add(f)) continue;
                this.registerField(f.getDeclaringClass(), object, name, this.docForField(object, f, name));
            }
            catch (NoSuchFieldException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    private static Object parseDirectValue(Class<?> cl, String value) throws InvalidFlagValueException {
        try {
            if (cl == Integer.TYPE) {
                return Integer.decode(value);
            }
            if (cl == Long.TYPE) {
                return Long.decode(value);
            }
            if (cl == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (cl == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (cl == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (cl == String.class) {
                return value;
            }
            try {
                return cl.getDeclaredMethod("valueOf", String.class).invoke(null, value);
            }
            catch (InvocationTargetException e) {
                throw new InvalidFlagValueException("'" + value + "' for type " + cl);
            }
            catch (Exception e) {
                throw new InvalidFlagValueException("'" + value + "' for type " + cl);
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidFlagValueException("'" + value + "' for type " + cl);
        }
    }

    private String docForField(Object object, Field field, String name) {
        try {
            Field h;
            if (Flag.class.isAssignableFrom(field.getType())) {
                Flag flag = (Flag)field.get(object);
                allFlags.add(flag);
                flag.setRegistered();
                return flag.getHelpString();
            }
            String helpFieldName = "HELP_" + name;
            if (name.startsWith("FLAG_")) {
                helpFieldName = "HELP_" + name.substring(5, name.length());
            }
            if ((h = field.getDeclaringClass().getField(helpFieldName)).getType() != String.class) {
                logger.log(Level.SEVERE, "Wrong type for " + h);
                return "";
            }
            if (Modifier.isStatic(h.getModifiers()) != (object == null)) {
                return "";
            }
            return (String)h.get(object);
        }
        catch (NoSuchFieldException ex) {
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, ex.toString(), ex);
        }
        return "";
    }

    private static com.google.appengine.repackaged.com.google.common.flags.Flag<?> flagForField(final Object object, final Field field) {
        final Class<?> fieldType = field.getType();
        if (Flag.class.isAssignableFrom(fieldType)) {
            try {
                Flag oldFlag = (Flag)field.get(object);
                return oldFlag.newFlag();
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return new com.google.appengine.repackaged.com.google.common.flags.Flag<Object>(null){

            protected Object parse(String text) throws InvalidFlagValueException {
                Object value = Flags.parseDirectValue(fieldType, text);
                try {
                    field.set(object, value);
                }
                catch (IllegalAccessException ex) {
                    throw new AssertionError((Object)ex);
                }
                return value;
            }
        };
    }

    private void registerField(Class<?> cl, Object object, String fieldName, String doc) throws NoSuchFieldException {
        Flags.registerUpdateFlags(cl, object);
        Field field = cl.getDeclaredField(fieldName);
        field.setAccessible(true);
        if (com.google.appengine.repackaged.com.google.common.flags.Flag.class.isAssignableFrom(field.getType())) {
            return;
        }
        String flagName = fieldName.startsWith("FLAG_") ? fieldName.substring(5) : fieldName;
        com.google.appengine.repackaged.com.google.common.flags.Flags.registerFlag((String)cl.getName(), (String)flagName, (String)(doc != null ? doc : this.docForField(object, field, fieldName)), null, (DocLevel)DocLevel.PUBLIC, (String)Flags.typeForField(object, field), Flags.flagForField(object, field));
    }

    private static String typeForField(Object object, Field field) {
        String result;
        if (Flag.class.isAssignableFrom(field.getType())) {
            try {
                Flag flag = (Flag)field.get(object);
                result = flag.getType().getName();
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError((Object)ex);
            }
        } else {
            result = field.getType().getName();
        }
        if (result.equals("boolean")) {
            result = "java.lang.Boolean";
        }
        return result;
    }

    public void registerMethod(final Object object, String methodName, String component, final String flagName, String help, boolean isBoolean) throws NoSuchMethodException, SecurityException {
        if (!registeredMethods.add(Pair.of(object.getClass().getName() + "." + methodName, flagName))) {
            return;
        }
        Flags.registerUpdateFlags(object.getClass(), object);
        final Method method = object.getClass().getMethod(methodName, String.class, String.class);
        com.google.appengine.repackaged.com.google.common.flags.Flags.registerFlag((String)object.getClass().getName(), (String)flagName, (String)help, null, (DocLevel)DocLevel.PUBLIC, (String)(isBoolean ? "java.lang.Boolean" : "java.lang.String"), (com.google.appengine.repackaged.com.google.common.flags.Flag)new com.google.appengine.repackaged.com.google.common.flags.Flag<Object>(null){

            public String parse(String value) {
                try {
                    method.invoke(object, flagName, value);
                    return value;
                }
                catch (IllegalAccessException ex) {
                    throw new AssertionError((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new AssertionError((Object)ex);
                }
                catch (InvocationTargetException ex) {
                    throw new AssertionError((Object)ex.getCause());
                }
            }
        });
    }

    public String[] parse(String[] arguments) {
        boolean oldChecking = Flag.setStateCheckingDisabled(true);
        try {
            String[] stringArray = com.google.appengine.repackaged.com.google.common.flags.Flags.parse((String[])arguments);
            return stringArray;
        }
        catch (InvalidFlagsException ex) {
            throw new UsageError(ex.getMessage(), ex);
        }
        finally {
            Flag.setStateCheckingDisabled(oldChecking);
        }
    }

    @Deprecated
    public String[] parse(String[] arguments, boolean helpAnywhere) {
        return this.parse(arguments);
    }

    private static void registerUpdateFlags(Class<?> cl, final Object object) {
        if (!alreadyRegistered.add(cl)) {
            return;
        }
        try {
            final Method m = cl.getMethod("updateFlags", new Class[0]);
            if (object == null != Modifier.isStatic(m.getModifiers())) {
                return;
            }
            Runnable completionHook = new Runnable(){

                public void run() {
                    try {
                        m.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException exc) {
                        throw new FlagUpdateError(exc.getCause());
                    }
                    catch (InvocationTargetException exc) {
                        throw new FlagUpdateError(exc.getCause());
                    }
                }
            };
            com.google.appengine.repackaged.com.google.common.flags.Flags.registerCompletionHook((Runnable)completionHook);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static {
        com.google.appengine.repackaged.com.google.common.flags.Flags.registerCompletionHook((Runnable)new Runnable(){

            public void run() {
                for (Flag f : allFlags) {
                    f.setParsed();
                }
            }
        });
    }

    public static class UsageError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UsageError(String msg) {
            super(msg);
        }

        public UsageError(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class FlagUpdateError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FlagUpdateError(Throwable cause) {
            super(cause);
        }
    }
}

