/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.ResultSetMetaData;
import com.google.cloud.sql.jdbc.Statement;
import com.google.cloud.sql.jdbc.internal.AbstractReadOnlyResultSet;
import com.google.cloud.sql.jdbc.internal.Charsets;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.DataTypeConverters;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.Observer;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSet
extends AbstractReadOnlyResultSet {
    private int current = -1;
    private List<ByteString> currentValues;
    private volatile boolean lastValueWasNull;
    private final Object CURRENT_LOCK = new Object();
    private boolean open;
    private final Statement stmt;
    private List<Client.TupleProto> data;
    private final List<Client.ColumnProto> columns;
    private final ColumnLabels columnLabels;
    private final String catalog;
    private final SqlRpcOptions rpcOptions;
    private SQLWarning warnings;
    private Observer<Statement> observer;

    public ResultSet(Statement stmt, List<Client.TupleProto> data, List<Client.ColumnProto> columns, SQLWarning warnings, String catalog, SqlRpcOptions rpcOptions) {
        this.stmt = stmt;
        this.data = Util.checkNotNull(data, "data can not be null");
        this.columns = Collections.unmodifiableList(Util.checkNotNull(columns, "columns can not be null"));
        this.catalog = catalog;
        this.rpcOptions = Util.checkNotNull(rpcOptions, "options can not be null");
        this.warnings = warnings;
        this.columnLabels = new ColumnLabels(columns);
        this.open = true;
        if (stmt != null) {
            this.observer = new Observer<Statement>(){

                @Override
                public void update(Statement subject) {
                    ResultSet.this.close();
                }
            };
            stmt.addObserver(this.observer);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.assertScrollableAndOpen();
        if (row > 0) {
            return this.setCurrentRow(row - 1);
        }
        if (row < 0) {
            return this.setCurrentRow(this.data.size() + row);
        }
        this.beforeFirst();
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        this.assertScrollableAndOpen();
        this.setCurrentRow(this.data.size());
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.assertScrollableAndOpen();
        this.setCurrentRow(-1);
    }

    @Override
    public void close() {
        if (this.stmt != null) {
            this.stmt.removeObserver(this.observer);
        }
        this.open = false;
        this.warnings = null;
        this.setCurrentRow(-1);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.assertScrollableAndOpen();
        return this.current == this.data.size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.assertScrollableAndOpen();
        return this.current == -1;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.assertScrollableAndOpen();
        return this.current == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.assertScrollableAndOpen();
        return this.current == this.data.size() - 1;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getIndexForLabel(columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        this.assertScrollableAndOpen();
        return this.setCurrentRow(0);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getFetchSize();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Client.ColumnProto column;
        this.throwIfNotOpen();
        try {
            column = this.columns.get(columnIndex - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw Exceptions.resultSetDoesNotHaveColumn(columnIndex);
        }
        int dataType = column.getType();
        ByteString raw = this.getRawValue(columnIndex);
        if (raw == null) {
            return null;
        }
        DataTypeConverter<?> converter = JdbcType.fromCode(dataType).getConverter();
        return converter.toObject(raw);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getObject(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.throwIfNotOpen();
        Util.checkArgument(type != null, "type", "(null)");
        if (type == String.class) {
            return type.cast(this.getString(columnIndex));
        }
        if (type == BigDecimal.class) {
            return type.cast(this.getBigDecimal(columnIndex));
        }
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(columnIndex));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(columnIndex));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(columnIndex));
        }
        if (type == Integer.class) {
            return type.cast(this.getInt(columnIndex));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(columnIndex));
        }
        if (type == Float.class) {
            return type.cast(Float.valueOf(this.getFloat(columnIndex)));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(columnIndex));
        }
        if (type == byte[].class) {
            return type.cast(this.getBytes(columnIndex));
        }
        if (Date.class.isAssignableFrom(type)) {
            return type.cast(this.getDate(columnIndex));
        }
        if (Time.class.isAssignableFrom(type)) {
            return type.cast(this.getTime(columnIndex));
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return type.cast(this.getTimestamp(columnIndex));
        }
        if (Blob.class.isAssignableFrom(type)) {
            return type.cast(this.getBlob(columnIndex));
        }
        if (NClob.class.isAssignableFrom(type)) {
            return type.cast(this.getNClob(columnIndex));
        }
        if (Clob.class.isAssignableFrom(type)) {
            return type.cast(this.getClob(columnIndex));
        }
        if (Array.class.isAssignableFrom(type)) {
            return type.cast(this.getArray(columnIndex));
        }
        if (Struct.class.isAssignableFrom(type)) {
            throw Exceptions.newNotYetImplementedException("Unsupported conversion to " + type);
        }
        if (Ref.class.isAssignableFrom(type)) {
            return type.cast(this.getRef(columnIndex));
        }
        if (RowId.class.isAssignableFrom(type)) {
            return type.cast(this.getRowId(columnIndex));
        }
        if (SQLXML.class.isAssignableFrom(type)) {
            return type.cast(this.getSQLXML(columnIndex));
        }
        throw Exceptions.newNotYetImplementedException("Unsupported conversion to " + type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.throwIfNotOpen();
        return this.getObject(this.getIndexForLabel(columnLabel), type);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getString(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        String data = this.getColumnValueAs(columnIndex, String.class);
        return new ByteArrayInputStream(new String(data).getBytes(Charsets.US_ASCII));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        String data = this.getColumnValueAs(this.getIndexForLabel(columnLabel), String.class);
        return new ByteArrayInputStream(new String(data).getBytes(Charsets.US_ASCII));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.throwIfNotOpen();
        return Util.createBigDecimalWithScale(this.getBigDecimal(columnIndex), scale);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.throwIfNotOpen();
        return Util.createBigDecimalWithScale(this.getBigDecimal(columnLabel), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = this.getColumnValueAs(columnIndex, byte[].class);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        byte[] bytes = this.getColumnValueAs(this.getIndexForLabel(columnLabel), byte[].class);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getBlob(this.getIndexForLabel(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        Boolean b = this.getColumnValueAs(columnIndex, Boolean.class);
        return b != null ? b : false;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getBoolean(this.getIndexForLabel(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        Byte b = this.getColumnValueAs(columnIndex, Byte.class);
        return b != null ? b : (byte)0;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getByte(this.getIndexForLabel(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getBigDecimal(this.getIndexForLabel(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getBytes(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        String s = this.getColumnValueAs(columnIndex, String.class);
        return s != null ? new StringReader(s) : null;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        String s = this.getString(this.getIndexForLabel(columnLabel));
        return s != null ? new StringReader(s) : null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getClob(this.getIndexForLabel(columnLabel));
    }

    @Override
    public String getCursorName() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getCursorName();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getDate(columnIndex), Calendar.getInstance(), cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return this.getDate(this.getIndexForLabel(columnLabel), cal);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getDate(this.getIndexForLabel(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Double.class);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getDouble(this.getIndexForLabel(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Float.class).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getFloat(this.getIndexForLabel(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        Integer i = this.getColumnValueAs(columnIndex, Integer.class);
        return i != null ? i : 0;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getInt(this.getIndexForLabel(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        Long l = this.getColumnValueAs(columnIndex, Long.class);
        return l != null ? l : 0L;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getLong(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        String s = this.getColumnValueAs(columnIndex, String.class);
        return s != null ? new StringReader(s) : null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        String s = this.getString(this.getIndexForLabel(columnLabel));
        return s != null ? new StringReader(s) : null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, NClob.class);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getNClob(this.getIndexForLabel(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, String.class);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getString(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        Short s = this.getColumnValueAs(columnIndex, Short.class);
        return s != null ? s : (short)0;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getShort(this.getIndexForLabel(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getTime(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getTime(columnIndex), Calendar.getInstance(), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return this.getTime(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.throwIfNotOpen();
        return this.getColumnValueAs(columnIndex, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.throwIfNotOpen();
        return this.getTimestamp(this.getIndexForLabel(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return Util.convertTime(this.getTimestamp(columnIndex), Calendar.getInstance(), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.throwIfNotOpen();
        return this.getTimestamp(this.getIndexForLabel(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Exceptions.newNotSupportedException("getUnicodeStream has been deprecated");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw Exceptions.newNotSupportedException("getUnicodeStream has been deprecated");
    }

    @Override
    public int getType() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getResultSetType();
    }

    @Override
    public boolean last() throws SQLException {
        this.assertScrollableAndOpen();
        return this.setCurrentRow(this.data.size() - 1);
    }

    @Override
    public boolean next() throws SQLException {
        this.throwIfNotOpen();
        return this.setCurrentRow(this.current + 1);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.throwIfNotOpen();
        return this.stmt;
    }

    @Override
    public boolean previous() throws SQLException {
        this.assertScrollableAndOpen();
        return this.setCurrentRow(this.current - 1);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwIfNotOpen();
        return new ResultSetMetaData(this.columns, this.catalog);
    }

    @Override
    public int getRow() throws SQLException {
        this.assertScrollableAndOpen();
        return Math.max(0, this.current + 1);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfNotOpen();
        this.warnings = null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfNotOpen();
        return this.warnings;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getResultSetHoldability();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.throwIfNotOpen();
        return this.rpcOptions.getResultSetConcurrency();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.assertScrollableAndOpen();
        return this.setCurrentRow(this.current + rows);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwIfNotOpen();
        Util.checkArgument(direction == 1000 || direction == 1001 || direction == 1002, "direction", direction);
        if (this.rpcOptions.getResultSetType() == 1003 && direction != 1000) {
            throw Exceptions.newInvalidParameterException("direction", direction, "Only FETCH_FORWARD is supported when the ResultSet is TYPE_FORWARD_ONLY.");
        }
        this.rpcOptions.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwIfNotOpen();
        Util.checkArgument(rows >= 0, "rows", rows);
        this.rpcOptions.setFetchSize(rows);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfNotOpen();
        return this.lastValueWasNull;
    }

    void setWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    private void throwIfNotOpen() throws SQLException {
        if (!this.open) {
            throw Exceptions.newResultSetClosedException();
        }
    }

    private void assertScrollableAndOpen() throws SQLException {
        this.throwIfNotOpen();
        if (this.rpcOptions.getResultSetType() == 1003) {
            throw Exceptions.newNotSupportedOnForwardOnlyException();
        }
    }

    private int getIndexForLabel(String columnLabel) throws SQLException {
        Integer index = this.columnLabels.indexOf(columnLabel);
        if (index == null) {
            throw Exceptions.resultSetDoesNotHaveColumn(columnLabel);
        }
        return index;
    }

    private <T> T getColumnValueAs(int columnIndex, Class<T> clazz) throws SQLException {
        this.throwIfNotOpen();
        return DataTypeConverters.getConverter(clazz).toObject(this.getRawValue(columnIndex));
    }

    private ByteString getRawValue(int columnIndex) throws SQLException {
        Object object = this.CURRENT_LOCK;
        synchronized (object) {
            if (this.currentValues == null) {
                throw Exceptions.resultSetDoesNotHaveColumn(columnIndex);
            }
            try {
                ByteString value = this.currentValues.get(columnIndex - 1);
                this.lastValueWasNull = value == null;
                return value;
            }
            catch (IndexOutOfBoundsException e) {
                throw Exceptions.resultSetDoesNotHaveColumn(columnIndex);
            }
        }
    }

    protected SqlRpcOptions getRpcOptions() {
        return this.rpcOptions;
    }

    protected boolean setData(List<Client.TupleProto> data) {
        this.data = data;
        return this.setCurrentRow(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCurrentRow(int num) {
        Object object = this.CURRENT_LOCK;
        synchronized (object) {
            this.currentValues = null;
            if (num >= 0 && num < this.data.size()) {
                Client.TupleProto tuple = this.data.get(num);
                this.currentValues = Util.newArrayList(tuple.getValuesList());
                if (tuple.getNullsCount() != 0) {
                    TreeSet<Integer> nulls = Util.newTreeSet(tuple.getNullsList());
                    for (Integer nullPosition : nulls) {
                        this.currentValues.add(nullPosition, null);
                    }
                }
            }
            this.current = num;
            return this.current < this.data.size() && this.current >= 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnLabels {
        private final ConcurrentMap<String, Integer> columnLabels = Util.newConcurrentHashMap();
        private final ConcurrentMap<String, Integer> columnNames = Util.newConcurrentHashMap();
        private final ConcurrentMap<String, Integer> columnNamesWithTables = Util.newConcurrentHashMap();

        ColumnLabels(List<Client.ColumnProto> columns) {
            int columnIndex = 1;
            for (Client.ColumnProto column : columns) {
                String name;
                String label = column.getLabel();
                if (!Util.isEmpty(label)) {
                    this.columnLabels.putIfAbsent(label.toUpperCase(), columnIndex);
                }
                if (!Util.isEmpty(name = column.getName())) {
                    this.columnNames.putIfAbsent(name.toUpperCase(), columnIndex);
                    String table = column.getTableName();
                    if (!Util.isEmpty(table)) {
                        this.columnNamesWithTables.putIfAbsent(String.format("%s.%s", table.toUpperCase(), name.toUpperCase()), columnIndex);
                    }
                }
                ++columnIndex;
            }
        }

        Integer indexOf(String label) {
            if (label == null) {
                return null;
            }
            Integer index = (Integer)this.columnLabels.get(label = label.toUpperCase());
            if (index != null) {
                return index;
            }
            index = (Integer)this.columnNames.get(label);
            if (index != null) {
                return index;
            }
            return (Integer)this.columnNamesWithTables.get(label);
        }

        public String toString() {
            return "{" + this.columnLabels + "}\n" + "{" + this.columnNames + "}\n" + "{" + this.columnNamesWithTables + "}\n";
        }
    }
}

