/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.protocol;

import com.google.appengine.repackaged.org.apache.commons.httpclient.ConnectTimeoutException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import com.google.appengine.repackaged.org.apache.commons.httpclient.util.TimeoutController;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public final class ControllerThreadSocketFactory {
    private ControllerThreadSocketFactory() {
    }

    public static Socket createSocket(final ProtocolSocketFactory protocolSocketFactory, final String string, final int n, final InetAddress inetAddress, final int n2, int n3) throws IOException, UnknownHostException, ConnectTimeoutException {
        SocketTask socketTask = new SocketTask(){

            public void doit() throws IOException {
                this.setSocket(protocolSocketFactory.createSocket(string, n, inetAddress, n2));
            }
        };
        try {
            TimeoutController.execute(socketTask, (long)n3);
        }
        catch (TimeoutController.TimeoutException timeoutException) {
            throw new ConnectTimeoutException("The host did not accept the connection within timeout of " + n3 + " ms");
        }
        Socket socket = socketTask.getSocket();
        if (socketTask.exception != null) {
            throw socketTask.exception;
        }
        return socket;
    }

    public static Socket createSocket(SocketTask socketTask, int n) throws IOException, UnknownHostException, ConnectTimeoutException {
        try {
            TimeoutController.execute(socketTask, (long)n);
        }
        catch (TimeoutController.TimeoutException timeoutException) {
            throw new ConnectTimeoutException("The host did not accept the connection within timeout of " + n + " ms");
        }
        Socket socket = socketTask.getSocket();
        if (socketTask.exception != null) {
            throw socketTask.exception;
        }
        return socket;
    }

    public static abstract class SocketTask
    implements Runnable {
        private Socket socket;
        private IOException exception;

        protected void setSocket(Socket socket) {
            this.socket = socket;
        }

        protected Socket getSocket() {
            return this.socket;
        }

        public abstract void doit() throws IOException;

        public void run() {
            try {
                this.doit();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }
    }
}

