/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen.directio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mediautil.gen.directio.ByteCounter;
import mediautil.gen.directio.IterativeWriter;

public class InStreamFromIterativeWriter
extends InputStream {
    private static byte UNINITIALISED = 0;
    private static byte OPEN = 1;
    private static byte CLOSED = (byte)2;
    protected byte[] q;
    protected int qBegin;
    protected int qEnd;
    protected int qSize;
    protected int bufSize;
    protected int incSize;
    protected int minWriteSize;
    protected int writeCushion;
    private InputStream in;
    private IterativeWriter writer;
    private static final int DEF_BUF_SIZE = 4096;
    private byte[] oneByteArr = new byte[1];
    private WriterOutputStream writerStream;
    private int maxBufSize;

    public InStreamFromIterativeWriter(int bufSize, int incSize, int minWriteSize, int writeCushion) {
        int minBufSize;
        if (bufSize < 1024) {
            bufSize = 1024;
        }
        if (incSize < 128) {
            incSize = 128;
        }
        if (minWriteSize < 256) {
            minWriteSize = 256;
        }
        if (writeCushion < 256) {
            writeCushion = 256;
        }
        if (bufSize < (minBufSize = minWriteSize + writeCushion + 512)) {
            bufSize = minBufSize;
        }
        this.bufSize = bufSize;
        this.incSize = incSize;
        this.writeCushion = writeCushion;
        this.q = new byte[bufSize];
        this.qBegin = 0;
        this.qEnd = 0;
        this.qSize = 0;
        this.maxBufSize = bufSize;
    }

    public InStreamFromIterativeWriter(int bufSize) {
        this(bufSize < 2048 ? 2048 : bufSize, 512, 750, 750);
    }

    public InStreamFromIterativeWriter() {
        this(4096, 1024, 750, 750);
    }

    private void reallocBuf(int newLen) {
        byte[] newQ = new byte[newLen];
        int copyLen = this.q.length - this.qBegin;
        if (copyLen > this.qSize) {
            copyLen = this.qSize;
        }
        System.arraycopy(this.q, this.qBegin, newQ, 0, copyLen);
        int pos = copyLen;
        copyLen = this.qSize - copyLen;
        if (copyLen > 0) {
            System.arraycopy(this.q, 0, newQ, pos, copyLen);
        }
        this.q = newQ;
        this.qBegin = 0;
        this.qEnd = this.qSize;
        if (newLen > this.maxBufSize) {
            this.maxBufSize = newLen;
        }
    }

    public OutputStream getWriterOutputStream() {
        if (this.writerStream == null) {
            this.writerStream = new WriterOutputStream();
        }
        if (this.writer != null && this.writerStream.openFlag == UNINITIALISED) {
            this.writerStream.openFlag = OPEN;
        }
        return this.writerStream;
    }

    public void setIterativeWriter(IterativeWriter iterativeWriter) {
        if (iterativeWriter == null) {
            throw new NullPointerException("Writer is null");
        }
        if (this.writerStream != null && this.writerStream.openFlag == UNINITIALISED) {
            this.writerStream.openFlag = OPEN;
        }
        this.writer = iterativeWriter;
    }

    private int readOrSkip(byte[] b, int off, int len) throws IOException {
        int remain;
        int qReadSize = this.qSize;
        if (qReadSize > len) {
            qReadSize = len;
        }
        if (qReadSize > 0) {
            remain = this.q.length - this.qBegin;
            if (remain > qReadSize) {
                remain = qReadSize;
            }
            if (b != null) {
                System.arraycopy(this.q, this.qBegin, b, off, remain);
                off += remain;
            }
            this.qBegin += remain;
            if (this.qBegin == this.q.length) {
                this.qBegin = 0;
            }
            if ((remain = qReadSize - remain) > 0) {
                if (b != null) {
                    System.arraycopy(this.q, this.qBegin, b, off, remain);
                    off += remain;
                }
                this.qBegin += remain;
            }
            this.qSize -= qReadSize;
            if (this.qSize == 0) {
                this.qBegin = 0;
                this.qEnd = 0;
            }
        }
        if ((remain = len - qReadSize) > 0) {
            int curSize;
            this.writerStream.requestBuf = b;
            this.writerStream.requestPos = off;
            this.writerStream.requestRemaining = remain;
            while (this.writerStream.openFlag == OPEN && (curSize = this.bufSize + this.writerStream.requestRemaining - this.qSize - this.writeCushion) > this.minWriteSize) {
                if (this.writer.nextWrite(curSize) == 0) continue;
                this.writerStream.close();
            }
            if (this.q.length > this.bufSize && this.q.length - this.qSize >= this.incSize) {
                int resizeLen = this.bufSize;
                if (this.qSize > this.bufSize) {
                    resizeLen = this.qSize + (this.incSize - 1 - (this.qSize - 1 - this.bufSize) % this.incSize);
                }
                this.reallocBuf(resizeLen);
            }
            remain -= this.writerStream.requestRemaining;
        }
        return qReadSize + remain;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + len);
        }
        byte b1 = b[off];
        byte b2 = b[off + len - 1];
        if (len == 0) {
            return 0;
        }
        int retVal = this.readOrSkip(b, off, len);
        if (retVal == 0) {
            retVal = -1;
        }
        return retVal;
    }

    public int read() throws IOException {
        int retVal = -1;
        if (this.read(this.oneByteArr, 0, 1) == 1) {
            retVal = this.oneByteArr[0] & 0xFF;
        }
        return retVal;
    }

    public long skip(long n) throws IOException {
        long retVal = 0L;
        if (n < 0L) {
            n = 0L;
        }
        retVal = this.readOrSkip(null, 0, (int)n);
        return retVal;
    }

    public int available() throws IOException {
        int retVal = this.qSize;
        if (retVal < 0) {
            retVal = this.q.length + retVal;
        }
        if (retVal <= 0) {
            retVal = this.writerStream.openFlag == OPEN ? 1 : 0;
        }
        return retVal;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    static /* synthetic */ byte access$000() {
        return UNINITIALISED;
    }

    private class WriterOutputStream
    extends OutputStream
    implements ByteCounter {
        private byte[] oneByteArr = new byte[1];
        public byte[] requestBuf;
        public int requestPos;
        public int requestRemaining;
        public byte openFlag = InStreamFromIterativeWriter.access$000();
        private int[] counterArr;
        private boolean upMode;
        private long totalBytes = 0L;

        private WriterOutputStream() {
        }

        public void setCounter(int[] counterArr, boolean upMode) {
            int i = counterArr[0];
            this.counterArr = counterArr;
            this.upMode = upMode;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setRequestBuf(byte[] b, int off, int len) {
            this.requestBuf = b;
            this.requestPos = off;
            this.requestRemaining = len;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.openFlag != OPEN) {
                throw new IOException("Stream is not closed or IterativeWriter not set yet");
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + len);
            }
            byte b1 = b[off];
            byte b2 = b[off + len - 1];
            int lenRequired = len;
            if (this.requestRemaining > 0) {
                int copyLen = len;
                if (this.requestRemaining < len) {
                    copyLen = this.requestRemaining;
                }
                if (this.requestBuf != null) {
                    System.arraycopy(b, off, this.requestBuf, this.requestPos, copyLen);
                }
                this.requestPos += copyLen;
                this.requestRemaining -= copyLen;
                off += copyLen;
                len -= copyLen;
            }
            if (len > 0) {
                int remain;
                int newQSize = InStreamFromIterativeWriter.this.qSize + len;
                if (newQSize > InStreamFromIterativeWriter.this.q.length) {
                    InStreamFromIterativeWriter.this.reallocBuf(newQSize + InStreamFromIterativeWriter.this.incSize - 1 - (newQSize - 1 - InStreamFromIterativeWriter.this.bufSize) % InStreamFromIterativeWriter.this.incSize);
                }
                if ((remain = InStreamFromIterativeWriter.this.q.length - InStreamFromIterativeWriter.this.qEnd) > len) {
                    remain = len;
                }
                System.arraycopy(b, off, InStreamFromIterativeWriter.this.q, InStreamFromIterativeWriter.this.qEnd, remain);
                off += remain;
                InStreamFromIterativeWriter.this.qEnd += remain;
                if (InStreamFromIterativeWriter.this.qEnd >= InStreamFromIterativeWriter.this.q.length) {
                    InStreamFromIterativeWriter.this.qEnd = 0;
                }
                if ((remain = len - remain) > 0) {
                    System.arraycopy(b, off, InStreamFromIterativeWriter.this.q, InStreamFromIterativeWriter.this.qEnd, remain);
                    InStreamFromIterativeWriter.this.qEnd += remain;
                }
                InStreamFromIterativeWriter.this.qSize = newQSize;
            }
            if (lenRequired > 0) {
                this.totalBytes += (long)lenRequired;
                if (this.counterArr != null) {
                    this.counterArr[0] = this.upMode ? this.counterArr[0] + lenRequired : this.counterArr[0] - lenRequired;
                }
            }
        }

        public void write(int b) throws IOException {
            this.oneByteArr[0] = (byte)(b & 0xFF);
            this.write(this.oneByteArr, 0, 1);
        }

        public void close() throws IOException {
            this.openFlag = CLOSED;
        }
    }
}

