/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private static final Converter<?, ?> IDENTITY_CONVERTER = new IdentityConverter();

    public abstract B convert(@Nullable A var1);

    public abstract A reverse(@Nullable B var1);

    @Override
    @Nullable
    public final B apply(@Nullable A input) {
        return this.convert(input);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return super.equals(object);
    }

    public Converter<B, A> inverse() {
        return new InverseConverter(this);
    }

    public <C> Converter<A, C> compose(Converter<B, C> secondConverter) {
        return ConverterComposition.of(this, Preconditions.checkNotNull(secondConverter, "secondConverter"));
    }

    public Iterable<B> convertAll(final Iterable<? extends A> fromIterable) {
        Preconditions.checkNotNull(fromIterable, "fromIterable");
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return Converter.this.convertAll(fromIterable.iterator());
            }
        };
    }

    public Iterator<B> convertAll(final Iterator<? extends A> fromIterator) {
        Preconditions.checkNotNull(fromIterator, "fromIterator");
        return new Iterator<B>(){

            @Override
            public boolean hasNext() {
                return fromIterator.hasNext();
            }

            @Override
            public B next() {
                return Converter.this.convert(fromIterator.next());
            }

            @Override
            public void remove() {
                fromIterator.remove();
            }
        };
    }

    public Converter<A, B> nullPreserving() {
        return new NullPreservingConverter(this);
    }

    public static <T> Converter<T, T> identity() {
        return IDENTITY_CONVERTER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityConverter
    extends Converter<Object, Object> {
        private IdentityConverter() {
        }

        @Override
        public Object convert(@Nullable Object object) {
            return object;
        }

        @Override
        public Object reverse(@Nullable Object object) {
            return object;
        }

        @Override
        public Converter<Object, Object> inverse() {
            return this;
        }

        @Override
        public <C> Converter<Object, C> compose(Converter<Object, C> otherConverter) {
            return Preconditions.checkNotNull(otherConverter, "otherConverter");
        }

        @Override
        public Iterable<Object> convertAll(Iterable<?> fromIterable) {
            return Preconditions.checkNotNull(fromIterable, "fromIterable");
        }

        @Override
        public Iterator<Object> convertAll(Iterator<?> fromIterator) {
            return Preconditions.checkNotNull(fromIterator, "fromIterator");
        }

        @Override
        public Converter<Object, Object> nullPreserving() {
            return this;
        }

        public String toString() {
            return "IdentityConverter";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullPreservingConverter<A, B>
    extends Converter<A, B> {
        private final Converter<A, B> converter;

        NullPreservingConverter(Converter<A, B> converter) {
            this.converter = converter;
        }

        @Override
        public B convert(A object) {
            return object == null ? null : (B)this.converter.convert(object);
        }

        @Override
        public A reverse(B object) {
            return object == null ? null : (A)this.converter.reverse(object);
        }

        @Override
        public Converter<A, B> nullPreserving() {
            return this;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NullPreservingConverter) {
                NullPreservingConverter that = (NullPreservingConverter)obj;
                return this.converter.equals(that.converter);
            }
            return false;
        }

        public int hashCode() {
            return this.converter.hashCode() ^ 0x55555555;
        }

        public String toString() {
            return "NullPreservingConverter(" + this.converter + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConverterComposition<A, B, C>
    extends Converter<A, C> {
        final Converter<A, B> first;
        final Converter<B, C> second;

        ConverterComposition(Converter<A, B> first, Converter<B, C> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public C convert(@Nullable A object) {
            return this.second.convert(this.first.convert(object));
        }

        @Override
        public A reverse(@Nullable C object) {
            return this.first.reverse(this.second.reverse(object));
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ConverterComposition && this.first.equals(((ConverterComposition)o).first) && this.second.equals(((ConverterComposition)o).second);
        }

        public int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }

        public String toString() {
            return this.first + ".compose(" + this.second + ")";
        }

        static <A, B, C> Converter<A, C> of(Converter<A, B> first, Converter<B, C> second) {
            return second == IDENTITY_CONVERTER ? first : new ConverterComposition<A, B, C>(first, second);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InverseConverter<A, B>
    extends Converter<B, A> {
        final Converter<A, B> original;

        InverseConverter(Converter<A, B> original) {
            this.original = original;
        }

        @Override
        public A convert(@Nullable B object) {
            return this.original.reverse(object);
        }

        @Override
        public B reverse(@Nullable A object) {
            return this.original.convert(object);
        }

        @Override
        public Converter<A, B> inverse() {
            return this.original;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof InverseConverter && this.original.equals(((InverseConverter)o).original);
        }

        public int hashCode() {
            return ~this.original.hashCode();
        }

        public String toString() {
            return "InverseConverter(" + this.original + ")";
        }
    }
}

