package farm.example;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import farm.example.google.LocalDatastoreTest;
import farm.example.ifrog.StationCacheTest;
import farm.example.ifrog.StationTest;

/**
 * すべての JUnit テストケースを一括で実行するためのクラス。
 * 
 * @author yupong7@gmail.com
 */
@RunWith(Suite.class)                                    
@SuiteClasses( { 
	/* farm.example                          */
	CatTest.class,
	MyCacheTest.class,
	/* farm.example.google */
	LocalDatastoreTest.class,
	/* farm.example.ifrog */
	StationCacheTest.class,
	StationTest.class
})
public class AllTests {
	@BeforeClass
	public static void setUpBeforeClass() throws FileNotFoundException, IOException {
		// no-op
	}
	
	public static void main(String[] args) throws FileNotFoundException, IOException {
		JUnitCore.main(AllTests.class.getName());
	}
}
