package farm.example;

import static org.junit.Assert.assertEquals;

import java.util.Collections;

import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheFactory;
import javax.cache.CacheManager;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.google.appengine.tools.development.testing.LocalDatastoreServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;

/**
 * 
 * @author yupong7@gmail.com
 */
public class MyCacheTest {
	
    private final LocalServiceTestHelper helper =
        new LocalServiceTestHelper(new LocalDatastoreServiceTestConfig());

    @Before
    public void setUp() {
        helper.setUp();
    }

    @After
    public void tearDown() {
        helper.tearDown();
    }

	@Test
	public void test() throws CacheException {
		Cache cache;

		/****************************/
		/* Cache インスタンスの取得 */
		/****************************/
		CacheFactory cacheFactory = CacheManager.getInstance().getCacheFactory();
		cache = cacheFactory.createCache(Collections.emptyMap());

		/****************************/
		/* 値の設定および取得 */
		/****************************/
		String key = "key";
		byte[] value = "value".getBytes();

		// Put the value into the cache.
		cache.put(key, value);

		// Get the value from the cache.
		byte[] ret = (byte[]) cache.get(key);
		
		assertEquals(new String(value),new String(ret));
	}
}
