/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.binder;

import com.google.inject.Binder;
import com.google.inject.spring.SpringIntegration;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.zuena.guiceex.binder.GuiceexBinder;
import org.zuena.guiceex.exception.BindException;

public class SpringBinder
implements GuiceexBinder {
    private String classPath = null;
    private String filePath = null;

    public void bind(Binder binder) {
        ClassPathXmlApplicationContext context = null;
        if (this.classPath != null) {
            context = new ClassPathXmlApplicationContext(this.classPath);
        } else if (this.filePath != null) {
            context = new FileSystemXmlApplicationContext(this.filePath);
        } else {
            throw new BindException("applicationContext.xml path is must specified");
        }
        SpringIntegration.bindAll((Binder)binder, (ListableBeanFactory)context);
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

