/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.impl;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.GuiceexInjector;
import org.zuena.guiceex.InjectorFactory;
import org.zuena.guiceex.jpa.utils.JPASupportUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceexInjectorImpl
implements GuiceexInjector {
    private static final Log log = LogFactory.getLog(GuiceexInjectorImpl.class);
    private final Injector injector;
    private boolean managed = false;

    public GuiceexInjectorImpl(Injector injector) {
        this.injector = injector;
    }

    public void initialize() {
        JPASupportUtils.initialize();
    }

    @Override
    public void close() {
        if (this.managed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"close managed instance");
            }
            InjectorFactory.close();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"close managed instance");
            }
            this.closeImpl();
        }
    }

    public void closeImpl() {
        JPASupportUtils.close();
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
        if (log.isInfoEnabled()) {
            log.info((Object)"managed instance");
        }
    }

    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return this.injector.findBindingsByType(type);
    }

    public <T> Binding<T> getBinding(Key<T> key) {
        return this.injector.getBinding(key);
    }

    public Map<Key<?>, Binding<?>> getBindings() {
        return this.injector.getBindings();
    }

    public <T> T getInstance(Key<T> key) {
        return (T)this.injector.getInstance(key);
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public <T> Provider<T> getProvider(Key<T> key) {
        return this.injector.getProvider(key);
    }

    public <T> Provider<T> getProvider(Class<T> type) {
        return this.injector.getProvider(type);
    }

    public void injectMembers(Object o) {
        this.injector.injectMembers(o);
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }
}

