/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.jpa.transaction;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.jpa.exception.PersistenceContextFieldNotFound;
import org.zuena.guiceex.jpa.transaction.TransactionPropagator;
import org.zuena.guiceex.transaction.TransactionAttributeType;
import org.zuena.guiceex.transaction.annotation.Transactional;

public class TransactionInterceptor
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(TransactionInterceptor.class);
    private final TransactionPropagator propagatorPrototype;

    public TransactionInterceptor(TransactionAttributeType type) {
        this.propagatorPrototype = TransactionPropagator.getTransactionPropagator(type);
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Object obj;
        Field field;
        TransactionPropagator propagator = this.propagatorPrototype.clone();
        Transactional transactional = invocation.getMethod().getAnnotation(Transactional.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("propargation=" + (Object)((Object)transactional.value()) + "; rollbackFor=" + Arrays.toString(transactional.rollbackFor())));
        }
        if ((field = this.findPersistenceContextBindableField(obj = invocation.getThis())) == null) {
            throw new PersistenceContextFieldNotFound();
        }
        PersistenceContext pc = field.getAnnotation(PersistenceContext.class);
        propagator.setPersistenceContext(pc);
        propagator.setRollbackFor(transactional.rollbackFor());
        return propagator.propagate(new TransactionPropagator.Process(){

            public Object execute(EntityManager manager) throws Throwable {
                if (field != null) {
                    field.setAccessible(true);
                    field.set(obj, manager);
                }
                return invocation.proceed();
            }
        });
    }

    private Field findPersistenceContextBindableField(Object obj) {
        ArrayList classes = new ArrayList();
        Class<?> subclass = obj.getClass().getSuperclass();
        while (subclass != Object.class) {
            classes.add(subclass);
            subclass = subclass.getSuperclass();
        }
        int i = classes.size() - 1;
        while (i >= 0) {
            Field[] fields;
            Field[] fieldArray = fields = ((Class)classes.get(i)).getDeclaredFields();
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field field = fieldArray[n];
                if (log.isDebugEnabled()) {
                    log.debug((Object)field.getName());
                }
                if (field.isAnnotationPresent(PersistenceContext.class)) {
                    return field;
                }
                ++n;
            }
            --i;
        }
        return null;
    }
}

