/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;


import org.zuena.guiceex.util.ClassUtils;

import com.google.inject.binder.ScopedBindingBuilder;


/**
 * guiceex-config̃oCfBOvf<code>scopeType</code>̐ݒsNXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public abstract class ScopedBinder extends BasicBinderSupport {


	@SuppressWarnings("unchecked")
	protected void bindIn(ScopedBindingBuilder builder){
		if (getScopeType() != null){
			builder.in(ClassUtils.getClazz(getScopeType()));
		}else if (isPreload()){
			builder.asEagerSingleton();
		}
	}
}
