/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.config;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.binder.GuiceexBinder;



import com.google.inject.AbstractModule;


/**
 * {@link #AutoBindingModule(List)}̈<code>binders<code/>ɓnꂽguiceex-configɎw肳ꂽoCfBOݒA
 * ꊇ{@link Guice}֐ݒ肷NXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class AutoBindingModule extends AbstractModule{
	
	private static final Log log = LogFactory.getLog(AutoBindingModule.class);
	private List<GuiceexBinder> binders  = null;
	
	
	public AutoBindingModule(List<GuiceexBinder> binders) {
		this.binders = binders;
	}

	protected void configure() {
		for (GuiceexBinder b : binders) {
			if (log.isDebugEnabled()){
				log.debug("bind by " + b);
			}
			b.bind(binder());
		}
	}

}
