/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa.utils.statements;

import static org.zuena.guiceex.jpa.utils.SQLUtils.className2TableName;

import java.lang.reflect.Field;

import org.apache.commons.beanutils.PropertyUtils;
import org.zuena.guiceex.util.StringUtils;

/**
 * @author matsu@zuena.org.
 */
public class Table<T> extends Statement<T> {

	private final Class<T> entityClass;
	private final String alias;
	
	public Table(Class<T> entityClass) {
		this(entityClass,null);
	}

	public Table(Class<T> entityClass,String alias) {
		this.entityClass = entityClass;
		this.alias = StringUtils.isEmpty(alias) ? null : alias;
	}

	public String getTableNameWithAlias() {
		StringBuffer sb = new StringBuffer(getTableName());
		if (alias != null){
			sb.append(' ' + alias);
		}
		return sb.toString();
	}

	public Class<T> getEntityClass() {
		return entityClass;
	}

	public String getTableName(){
		return className2TableName(entityClass.getSimpleName());
	}
	
	public String getAlias() {
		return alias != null ? alias : getTableName();
	}

	public Field getField(String fieldName) {
		try {
			return entityClass.getDeclaredField(fieldName);
		} catch (Exception e) {
			return null;
		}
	}

}
