/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.provider;


import java.util.List;
import java.util.Map;

import org.zuena.guiceex.config.Entry;

import com.google.inject.Provider;

/**
 * guiceex-config&lt;map&gt;̎wA{@link Map}CX^X쐬Ē񋟂
 * {@link Provider}NXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
@SuppressWarnings("unchecked")
public class MapProvider<T extends Map> extends CollectionProviderSupport<T> implements Provider{
	
	public MapProvider( List<Entry> entries,Class type) {
		super(entries, type);
	}

	/**
	 * ftHg{@link com.google.inject.Injector}gp<code>key</code><code>value</code>
	 * 擾o^B
	 */
	@Override
	protected T initCollection(T collection) {
		for (Entry entry : entries) {
			collection.put(entry.getKeyInstance(injector)
					,entry.getValueyInstance(injector));
			
		}
		return collection;
	}
	
	/**
	 * ^p[^<code>T</code>ɉ{@link MapProvider}CX^X쐬郁\bhłB
	 */
	public static <T extends Map> Provider<T> fromList(List<Entry> entries,Class<T> type){
		return new MapProvider<T>(entries,type);
	}
}
