/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;


import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.aopalliance.intercept.MethodInterceptor;

import org.zuena.guiceex.matcher.RegexMatcher;
import org.zuena.guiceex.util.ClassUtils;


import com.google.inject.Binder;

/**
 * guiceex-config&lt;interceptor&gt;֎w肳ꂽoCfBOݒsoC_[NXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
@SuppressWarnings("unchecked")
public class InterceptorBinder implements GuiceexBinder {

	private String classPattern = null;
	private String methodPattern = null;
	private String type = null;
	
	public void bind(Binder binder)  {
		binder.bindInterceptor(
				new RegexMatcher(classPattern)
				, new RegexMatcher(methodPattern)
				, getInterceptors());
	}

	private MethodInterceptor[] getInterceptors(){
		StringTokenizer st = new StringTokenizer(type,",");
		List<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>();
		while(st.hasMoreTokens()){
			interceptors.add(
					(MethodInterceptor) ClassUtils.newInstance(
											ClassUtils.getClazz(st.nextToken())));
		}
		return interceptors.toArray(new MethodInterceptor[0]);
	}

	public String getClassPattern() {
		return classPattern;
	}

	public void setClassPattern(String classPattern) {
		this.classPattern = classPattern;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getMethodPattern() {
		return methodPattern;
	}

	public void setMethodPattern(String methodPattern) {
		this.methodPattern = methodPattern;
	}

}
