/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.config;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.zuena.guiceex.util.ClassUtils;

/**
 * {@link Map}{@link List}ւ̃oCfBO`\̃X[p[NXłB
 * guiceex-configǂݍ񂾃oCfBO`̋ʂ̎Lq܂B
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class Collection {
	private List<Entry> entries = new ArrayList<Entry>();
	private String type = null;
	public List<Entry> getEntries() {
		return entries;
	}
	public void addEntry(Entry entry){
		entries.add(entry);
	}
	
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	
	public boolean isMap(){
		return Map.class.isAssignableFrom(ClassUtils.getClazz(type));
	}
	public boolean isList(){
		return List.class.isAssignableFrom(ClassUtils.getClazz(type));
	}
	public boolean isArray(){
		return ClassUtils.getClazz(type).isArray();
	}
	
	public String toString(){
		return Collection.class.getName()
					+ ":type=[" + type + "]";
	}
}
