/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.GuiceexInjector;
import org.zuena.guiceex.InjectorFactory;
import org.zuena.guiceex.jpa.utils.JPASupportUtils;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;


/**
 * {@link GuiceexInjector}̎NXłB
 * JPAT|[g̏ƃN[Ys܂B
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class GuiceexInjectorImpl implements GuiceexInjector {

	private static final Log log = LogFactory.getLog(GuiceexInjectorImpl.class);
	private final Injector injector;
	private boolean managed = false;
	
	public GuiceexInjectorImpl(Injector injector) {
		this.injector = injector;
	}
	
	/**
	 * JPAT|[g̏s܂B
	 */
	public void initialize() {
		JPASupportUtils.initialize();
	}

	/**
	 * JPAT|[g̏Is܂B
	 * {@link InjectorFactory}ŃCX^XǗĂꍇ
	 * {@link InjectorFactory#close()}\bhɂI܂B
	 */
	public void close() {
		if (managed){
			if (log.isDebugEnabled()){
				log.debug("close managed instance");
			}
			InjectorFactory.close();
		}else{
			if (log.isDebugEnabled()){
				log.debug("close managed instance");
			}
			closeImpl();
		}
	}

	/**
	 * JPAT|[g̏Is܂B
	 */
	public void closeImpl(){
		JPASupportUtils.close();
	}

	public void setManaged(boolean managed) {
		this.managed = managed;
		if (log.isInfoEnabled()){
			log.info("managed instance");
		}
	}

	/**
	 * @see com.google.inject.Injector#findBindingsByType(com.google.inject.TypeLiteral)
	 */
	public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
		return injector.findBindingsByType(type);
	}

	/**
	 * @see com.google.inject.Injector#getBinding(com.google.inject.Key)
	 */
	public <T> Binding<T> getBinding(Key<T> key) {
		return injector.getBinding(key);
	}

	/**
	 * @see com.google.inject.Injector#getBindings()
	 */
	public Map<Key<?>, Binding<?>> getBindings() {
		return injector.getBindings();
	}

	/**
	 * @see com.google.inject.Injector#getInstance(com.google.inject.Key)
	 */
	public <T> T getInstance(Key<T> key) {
		return injector.getInstance(key);
	}

	/**
	 * @see com.google.inject.Injector#getInstance(java.lang.Class)
	 */
	public <T> T getInstance(Class<T> type) {
		return injector.getInstance(type);
	}

	/**
	 * @see com.google.inject.Injector#getProvider(com.google.inject.Key)
	 */
	public <T> Provider<T> getProvider(Key<T> key) {
		return injector.getProvider(key);
	}

	/**
	 * @see com.google.inject.Injector#getProvider(java.lang.Class)
	 */
	public <T> Provider<T> getProvider(Class<T> type) {
		return injector.getProvider(type);
	}

	/**
	 * @see com.google.inject.Injector#injectMembers(java.lang.Object)
	 */
	public void injectMembers(Object o) {
		injector.injectMembers(o);
	}

	/**
	 * @see org.zuena.guiceex.GuiceexInjector#getInjector()
	 */
	public Injector getInjector() {
		return injector;
	}


}

