/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.transaction.annotation;


import java.lang.annotation.Annotation;

import org.zuena.guiceex.transaction.TransactionAttributeType;

/**
 * {@code @}{@link Transactional}Ame[V̎NXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
class TransactionalImpl implements Transactional{

	final TransactionAttributeType propargation;
	final Class<? extends Throwable>[] rollbackFor;
	final String unitName;


	public TransactionalImpl(final TransactionAttributeType propargation
							, final Class<? extends Throwable>[] rollbackFor
							, final String unitName) {
		this.propargation = propargation;
		this.rollbackFor = rollbackFor;
		this.unitName = unitName;
	}

	public TransactionAttributeType value() {
		return propargation;
	}

	public Class<? extends Throwable>[] rollbackFor() {
		return rollbackFor;
	}

	public boolean equals(Object o) {
		if (!(o instanceof Transactional)) {
			return false;
		}

		Transactional other = (Transactional) o;
		return propargation == other.value();
	}

	public String toString() {
		return "@" + Transactional.class.getName()
					+ "(propargation=" + propargation
					+ "rollbackFor="+rollbackFor
					+ "unitName="+unitName+")";
	}

	public Class<? extends Annotation> annotationType() {
		return Transactional.class;
	}

	public String unitName() {
		return unitName;
	}

}
