/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.util;



import org.zuena.guiceex.exception.InstantiationException;

/**
 * NX{@link Class}̃\bh𑀍삷郆[eBeB[NXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public class ClassUtils {

	private ClassUtils() {
	}

	/**
	 * {@link Class}擾܂B
	 */
	public static Class getClazz(String className){
		try {
			return Class.forName(className);
		} catch (ClassNotFoundException e) {
			throw new org.zuena.guiceex.exception.ClassNotFoundException(e);
		}
	}

	/**
	 * <code>toType</code><code>Class&lt;? extends T&gt;</code>ɃLXg܂B
	 */
	@SuppressWarnings("unchecked")
	public static <T> Class<? extends T>cast(Class<T> type, Class<?> toType){
		return (Class<? extends T>) toType;
	}

	/**
	 * <code>clazz</code>̃CX^X쐬܂B
	 */
	public static <T> T newInstance(Class<T> clazz){
		try {
			return clazz.newInstance();
		} catch (Exception e) {
			throw new InstantiationException(clazz.getName() + " instantiation failed",e);
		}
	}
	
}
