/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.InjectorFactory;

import junit.framework.TestCase;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;

@SuppressWarnings("unchecked")
public class TestMain extends TestCase{

	Log log = LogFactory.getLog(TestMain.class);
	
	@Inject
	@Test1Annotation
	public Test1 t = null;
	
	@Inject
	public C fromSpring_C = null;
	
	@Inject
	@ConstantAnnotation
	public int num = -1;
	
	
	@Inject
	@MapAnnotation
	public Map map = null;

	@Inject
	@ListAnnotation
	public List list = null;
	
	@Inject
	@Named("list")
	public List namedList = null;
	
	@Inject
	@Named("prop")
	public Properties properties = null;
	
	
	public TestMain() {
	}

	
	
	/**
	 * @param args
	 */
	public void test1(){
		log.info(" ########## TestMain.test1() start ##########"); 
		log.info(" ########## TestMain.test1() start ##########"); 
		log.info(" ########## TestMain.test1() start ##########"); 
		log.info(" ########## TestMain.test1() start ##########"); 
		try{
			Injector injector = InjectorFactory.createInjector("org/zuena/guiceex/resources/guiceex-cfg.xml");
			TestMain o = injector.getInstance(TestMain.class);
			int count=1;
			System.out.println("test1:"+(count)++);
			assertNotNull(o);
			System.out.println("test1:"+(count)++);
			assertNotNull(o.fromSpring_C);
			System.out.println("test1:"+(count)++);
			assertTrue(o.fromSpring_C instanceof C);
			System.out.println("test1:"+(count)++);
			assertNotNull(o.t);
			System.out.println("test1:"+(count)++);
			assertNotNull(o.t.getT1());
			System.out.println("test1:"+(count)++);
			assertTrue(o.t.getT1() instanceof A);
			System.out.println("test1:"+(count)++);
			assertTrue(o.t.getT2() instanceof B);
			System.out.println("test1:"+(count)++);
			assertEquals(o.num,2345);
			System.out.println("test1:"+(count)++);
		}catch(Exception e){
			log.debug("ȂH", e);
			fail();
		}
	}		
	public void testMap(){
		log.info(" ########## TestMain.testMap() start ##########"); 
		log.info(" ########## TestMain.testMap() start ##########"); 
		log.info(" ########## TestMain.testMap() start ##########"); 
		log.info(" ########## TestMain.testMap() start ##########"); 
		try{
			Injector injector = InjectorFactory.createInjector("org/zuena/guiceex/resources/guiceex-cfg.xml");
			TestMain o = injector.getInstance(TestMain.class);
			Iterator<Map.Entry<Condition, Process>> it = o.map.entrySet().iterator();
			Map.Entry<Condition, Process> entry = it.next();
			int count=1;
			System.out.println("testMap:"+(count)++);
			assertTrue(entry.getKey() instanceof Test1Condition);
			System.out.println("testMap:"+(count)++);
			assertTrue(entry.getValue() instanceof Test1Process);
			System.out.println("testMap:"+(count)++);
			entry = it.next();
			System.out.println("testMap:"+(count)++);
			assertTrue(entry.getKey() instanceof Test2Condition);
			System.out.println("testMap:"+(count)++);
			assertTrue(entry.getValue() instanceof Test2Process);
			System.out.println("testMap:"+(count)++);
			entry = it.next();
			System.out.println("testMap:"+(count)++);
			assertTrue(entry.getKey() instanceof Test3Condition);
			System.out.println("testMap:"+(count)++);
			assertTrue(entry.getValue() instanceof Test3Process);
			System.out.println("testMap:"+(count)++);
		}catch(Exception e){
			log.debug("ȂH", e);
			fail();
		}

	}	

	public void testList(){

		try{
			Injector injector = InjectorFactory.createInjector("org/zuena/guiceex/resources/guiceex-cfg.xml");
			TestMain o = injector.getInstance(TestMain.class);
			int count=1;
			System.out.println("testList:"+(count)++);
			assertNotNull(o.list);
			System.out.println("testList:"+(count)++);
			assertEquals(3,o.list.size());
	
			List<Process> list = o.list;
			System.out.println("testList:"+(count)++);
			assertTrue(list.get(0) instanceof Test1Process);
			System.out.println("testList:"+(count)++);
			assertTrue(list.get(1) instanceof Test2Process);
			System.out.println("testList:"+(count)++);
			assertTrue(list.get(2) instanceof Test3Process);
	
	
			System.out.println("testList:"+(count)++);
			assertNotNull(o.namedList);
			System.out.println("testList:"+(count)++);
			assertEquals(3,o.namedList.size());
	
			list = o.namedList;
			System.out.println("testList:"+(count)++);
			assertEquals("org.zuena.guiceex.Test1Process",list.get(0));
			System.out.println("testList:"+(count)++);
			assertEquals("org.zuena.guiceex.Test2Process",list.get(1));
			System.out.println("testList:"+(count)++);
			assertEquals("org.zuena.guiceex.Test3Process",list.get(2));
			System.out.println("testList:"+(count)++);
			
			System.out.println("testList:"+(count)++);
			assertNotNull(o.properties);
			System.out.println("testList:"+(count)++);
			assertEquals("11111",o.properties.getProperty("aaaa"));
			System.out.println("testList:"+(count)++);
			System.out.println("testList:"+(count)++);
			assertEquals("22222",o.properties.getProperty("bbbb"));
			System.out.println("testList:"+(count)++);
			assertEquals("33333",o.properties.getProperty("cccc"));
			System.out.println("testList:"+(count)++);
		}catch(Exception e){
			log.debug("ȂH", e);
			fail();
		}
		
	}
}
