package org.zuena.guiceex.jpa;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.zuena.guiceex.transaction.NoTransactionException;
import org.zuena.guiceex.transaction.TransactionActiveException;
import org.zuena.guiceex.transaction.annotation.Transactional;

import com.google.inject.Inject;

import static org.zuena.guiceex.transaction.TransactionAttributeType.*;

/**
 * @author matsu@zuena.org.
 */
public class TransactionalProcess2 {



	@PersistenceContext(unitName="hsql")
	private EntityManager entityManager;

	@Inject TransactionalProcess p;

	public TransactionalProcess2() {
	}

	@Transactional(NOT_SUPPORTED)
	public void notSupproted2() {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVŐVKgUNVActivełȂ");
		}

		// NOT_SUPPORTED
		p.notSupported(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// SUPPORTS
		p.supprots(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRED
		p.required(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRES_NEW
		p.requiresNew(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		try{
			p.mandatory(entityManager);
		}catch(NoTransactionException e){
			// ok
		}
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		p.never(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
	}

	@Transactional(SUPPORTS)
	public void supprots2() {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVŐVKgUNVActivełȂ");
		}

		// NOT_SUPPORTED
		p.notSupported(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// SUPPORTS
		p.supprots(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRED
		p.required(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRES_NEW
		p.requiresNew(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		// MANDATORY
		try{
			p.mandatory(entityManager);
		}catch(NoTransactionException e){
			// ok
		}
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// NEVER
		p.never(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
	}

	@Transactional(REQUIRED)
	public void required2() {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVŐVKgUNVActivełȂ");
		}

		// NOT_SUPPORTED
		p.notSupported(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		// SUPPORTS
		p.supprots(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRED
		p.required(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRES_NEW
		p.requiresNew(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		// MANDATORY
		p.mandatory(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// NEVER
		try{
			p.never(entityManager);
		}catch(TransactionActiveException e){
			// ok
		}
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
	}

	@Transactional(REQUIRES_NEW)
	public void requiresNew2() {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVŐVKgUNVActivełȂ");
		}

		// NOT_SUPPORTED
		p.notSupported(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		// SUPPORTS
		p.supprots(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRED
		p.required(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRES_NEW
		p.requiresNew(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		// MANDATORY
		p.mandatory(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// NEVER
		try{
			p.never(entityManager);
		}catch(TransactionActiveException e){
			// ok
		}
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
	}

	@Transactional(NEVER)
	public void never2() {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVŐVKgUNVActivełȂ");
		}

		// NOT_SUPPORTED
		p.notSupported(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// SUPPORTS
		p.supprots(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRED
		p.required(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// REQUIRES_NEW
		p.requiresNew(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
		if (p.entityManager.isOpen()){
			throw new RuntimeException("ĂяoꂽEntityManagercloseĂȂ");
		}

		// MANDATORY
		try{
			p.mandatory(entityManager);
		}catch(NoTransactionException e){
			// ok
		}
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}

		// NEVER
		p.never(entityManager);
		if (!entityManager.isOpen()){
			throw new RuntimeException("EntityManagercloseĂ");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveĂ");
		}
	}
}
