package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Customer implements Serializable {
	@Id
	private BigDecimal id;

	private String city;

	private String lastname;

	private String street;

	private String firstname;

	@OneToMany(mappedBy="customerid")
	private Set<Invoice> invoiceCollection;

	private static final long serialVersionUID = 1L;

	public Customer() {
		super();
	}

	public BigDecimal getId() {
		return this.id;
	}

	public void setId(BigDecimal id) {
		this.id = id;
	}

	public String getCity() {
		return this.city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getLastname() {
		return this.lastname;
	}

	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	public String getStreet() {
		return this.street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public String getFirstname() {
		return this.firstname;
	}

	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	public Set<Invoice> getInvoiceCollection() {
		return this.invoiceCollection;
	}

	public void setInvoiceCollection(Set<Invoice> invoiceCollection) {
		this.invoiceCollection = invoiceCollection;
	}

}
