package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;

@Entity
public class Flightavailability implements Serializable {
	@EmbeddedId
	private Flightavailability.PK pk;

	@Column(name="BUSINESS_SEATS_TAKEN")
	private int businessSeatsTaken;

	@Column(name="FIRSTCLASS_SEATS_TAKEN")
	private int firstclassSeatsTaken;

	@Column(name="ECONOMY_SEATS_TAKEN")
	private int economySeatsTaken;

	@ManyToOne
	@JoinColumns({
		@JoinColumn(name="SEGMENT_NUMBER", referencedColumnName="SEGMENT_NUMBER"),
		@JoinColumn(name="FLIGHT_ID", referencedColumnName="FLIGHT_ID")
	})
	private Flights flights;

	private static final long serialVersionUID = 1L;

	public Flightavailability() {
		super();
	}

	public Flightavailability.PK getPk() {
		return this.pk;
	}

	public void setPk(Flightavailability.PK pk) {
		this.pk = pk;
	}

	public int getBusinessSeatsTaken() {
		return this.businessSeatsTaken;
	}

	public void setBusinessSeatsTaken(int businessSeatsTaken) {
		this.businessSeatsTaken = businessSeatsTaken;
	}

	public int getFirstclassSeatsTaken() {
		return this.firstclassSeatsTaken;
	}

	public void setFirstclassSeatsTaken(int firstclassSeatsTaken) {
		this.firstclassSeatsTaken = firstclassSeatsTaken;
	}

	public int getEconomySeatsTaken() {
		return this.economySeatsTaken;
	}

	public void setEconomySeatsTaken(int economySeatsTaken) {
		this.economySeatsTaken = economySeatsTaken;
	}

	public Flights getFlights() {
		return this.flights;
	}

	public void setFlights(Flights flights) {
		this.flights = flights;
	}


	@Embeddable
	public static class PK implements Serializable {
		@Column(name="FLIGHT_DATE")
		private Date flightDate;
		private int segment_number;
		private String flight_id;
		private static final long serialVersionUID = 1L;

		public PK() {
			super();
		}

		public Date getFlightDate() {
			return this.flightDate;
		}

		public void setFlightDate(Date flightDate) {
			this.flightDate = flightDate;
		}

		public int getSegment_number() {
			return this.segment_number;
		}

		public void setSegment_number(int segment_number) {
			this.segment_number = segment_number;
		}

		public String getFlight_id() {
			return this.flight_id;
		}

		public void setFlight_id(String flight_id) {
			this.flight_id = flight_id;
		}

		@Override
		public boolean equals(Object o) {
			if (o == this) {
				return true;
			}
			if ( ! (o instanceof PK)) {
				return false;
			}
			PK other = (PK) o;
			return this.flightDate.equals(other.flightDate)
				&& (this.segment_number == other.segment_number)
				&& this.flight_id.equals(other.flight_id);
		}

		@Override
		public int hashCode() {
			return this.flightDate.hashCode()
				^ this.segment_number
				^ this.flight_id.hashCode();
		}

	}

}
