# Interpreter

## How Interpreter Works

The Interpreter looks up and modifies content of Environment
in accordance with Expressions that has been generated by parsing source codes.

The execution of the Interpreter consists of two stages **evaluation** and **assignment**.
In an evaluation stage, it looks up variables in Environment and do evaluation
depending on the current expression.
In an assingment stage, the Interpreter will add new variables
or modify existing variables in Environment.

In the Interpreter, Evaluation stage always occurs on each Expression
while Assignment stage only does when `Assign` expression is executed.

          +---------------+
          |  Expressions  |
          +---------------+
                  | control
                  V
    +----------------------------+     look-up     +---------------+
    |              evaluation <--|-----------------|               |
    |  Interpreter      |        |   assignment    |  Environment  |
    |                   `--------|---------------->|               |
    +----------------------------+                 +---------------+


## Evaluation Stage


### Overview

This section explains how each Expression acts in the Interpreter's evaulation stage.


### Evaluation of Value

Evaluation result of a `Value` expression will be the value that it owns in itself.

Consider the following expressions:

* `3.141`

  Returns an instance of `number` type.

* `'hello'`

  Returns an instance of `string` type

* `b'\x00\x01\x02\x03'`

  Returns an instance of `binary` type.


### Evaluation of Identifier

An `Identifier` expression will look up a variable whose name matches the expression's symbol
in an Environment and return the result value.
If no variable is found, it occurs an error.

Consider the following expression:

* `foo`

  Looks up a symbol `foo` in the current Environment and returns the associated value if found.
  If the symbol does not exist, occurs an error.

### Evaluation of Suffixed

A `Suffixed` expression will look up an entry in Suffix Manager
that matches its suffix symbol and execute the entry with its body string.

Consider the following expressions:

* `123.45foo`

  1. Looks up a handler associated with a symbol `foo` in the Suffix Manager.
  2. If found, it evaluates the handler by passing it a string `'123.45'` and returns the result.
     If no handler is found, occurs an error.

* `'hello world'bar`

  1. Looks up a handler associated with a symbol `bar` in the Suffix Manager.
  2. If found, evaluates the handler by passing it a string `'hello world'` and returns the result.
     If no handler is found, occurs an error.


### Evaluation of UnaryOp

A `UnaryOp` expression evaluates the child expression it owns,
and then evaluate the value with its associated unary operator.

Consider the following expressions:

* `-123.45`

  1. Evaluates the child expression and gets a value `123.45` of `number` type.
  2. Looks up a unary operator function of `-` that can calculate `number` type.
  3. Evaluates the function by passing it a number `123.45` and returns the result.


### Evaluation of Quote

A `Quote` expression

    `X

### Evaluation of BinaryOp

A `BinaryOp` expression evaluates both of the two child expressions it owns,
and then evaluate the value with its associated Binary Operator.

    X + Y

Binary Operator `&&` and `||` are exceptional.

With operator `&&`, it first evaluates the child expression on the left.
If the value is determined as **false**, that value is the result.
Otherwise, it then evaluates the child expression on the right and returns the result.

With operator `||`, it first evaluates the child expression on the left.
If the value is determined as **true**, that value is the result.
Otherwise, it then evaluates the child expression on the right and returns the result.


### Evaluation of Assign

Execution of an `Assign` expression triggers Assignment Stage. See the next section.

    X = Y


### Evaluation of Member

A `Member` expression

    X.Y

Class, Module and Object


### Evaluation of Lister

A `Lister` expression

    [A, B, C]


### Evaluation of Iterer

An `Iterer` expression

    (A, B, C)


### Evaluation of Block

A `Block` expression

    {A, B, C}


### Evaluation of Root

A `Root` expression


### Evaluation of Indexer

An `Indexer` expression

    X[A, B, C]

    x[2]
    
    x[1, 2, 3]
    
    x['foo']

How an `Indexer` expression behaves in Interpreter's evaluation and assignment stage
depends on what instance the car element returns.

If car's instance is of `list` type:

* **Evaluation:** the expression seeks the list's content at specified positions by indices.
* **Assignment:** modifies or adds the list's content at specified positions by indices.

In these cases, indices values are expected to be of `number` type.

If car's instance is of `dict` type:

* **Evaluation:** the expression seeks the dictionary's content using indices as the keys.
* **Assignment:** modifies or adds the dictionary's values associated with specified keys by indices.

In these cases, indices values are expected to be of `number`, `string` or `symbol` type.


### Evaluation of Caller

A `Caller` expression evaluates expressions listed as its arguments.

    X(A, B, C)

    f(a, b, c, d)

    f(a, b):foo:bar

    f {}

If the argument is declared as Quoted, it doesn't evaluates its argument.

How a `Caller` expression behaves in Interpreter's evaluation stage
depends on what instance the car element returns.

If car's instance is of `function` type
the expression calls the function with specified arguments.

If the `Caller` expression is specified as a target in Interpreter's assignment stage,
it always creates `function` instance and assigns it in a specific Environment.


## Assignment Stage

### Overview

In an operation `X = Y`, the target expression `X` may be
one of `Identifer`, `Lister`, `Member`, `Indexer` and `Caller`.

If the target expression is `Identifier`, `Lister` or `Member`,
the source expression is evaluated at first before the result is assigned to the target.

If the target expression is `Caller`,
the source expression itself is assigned to the target without any evaluation.


### Assignment for Identifier



An assignment for an `Identifier` expression

    X = Y

If a type name is specified as the `Identifier`'s  attribute,
the source value will be casted to the type before assignment.

    a:number = '3'

This works in the same way as a data type casting in an argument list of function call.
See [Chapter.7. Function](Function.html) for more detail.


### Assignment for Lister

When the assignment destionation is a `Lister` expression,
assignment operation is applied to each expression described as its element.
Elements in the `Lister` must be `Identifier` expressions.

    [A, B, C] = X

If assignment source is a scalar, that value is assigned to each element.

    [a, b, c] = 3          // a = 3, b = 3, c = 3

If assignment source is a list, each value in the list is assigned to each element.

    [a, b, c] = [1, 2, 3]  // a = 1, b = 2, c = 3

It would be the same with an iterator.

    [a, b, c] = (1, 2, 3)  // a = 1, b = 2, c = 3

If the assignment source has more elements than the destination requires,
remaining elements are simply ignored.
If the source has insufficient number of elements, it would occur an error.

    [a, b, c] = [1, 2, 3, 4, 5]  // a = 1, b = 2, c = 3
    [a, b, c] = [1, 2]           // error!


### Assignment for Member

A `Member` expression

    X.Y = Z

Class, Module and Object

    obj.var1 = 3
    obj.f(x) = { }


### Assignment for Indexer

An `Indexer` expression

    X[A] = Y

    X[A, B, C] = Y

    x[n] = y

    x[n] = 3
    
    x[0, 2, 5] = 3

    x[0, 2, 5] = [1, 2, 3]


### Assignment for Caller

A `Caller` expression

    X(A, B, C) = Y

Assignments for other expressions than what are described above are invalid and occurs an error.


### Operator before Assignment

An Assignment operator can be combined with one of several other operators.

<table>
<tr><th>Assignment Form</th><th>Equivalent Code</th></tr>
<tr><td><code>x += y</code></td><td><code>x = x + y</code></td></tr>
<tr><td><code>x -= y</code></td><td><code>x = x - y</code></td></tr>
<tr><td><code>x *= y</code></td><td><code>x = x * y</code></td></tr>
<tr><td><code>x /= y</code></td><td><code>x = x / y</code></td></tr>
<tr><td><code>x %= y</code></td><td><code>x = x % y</code></td></tr>
<tr><td><code>x **= y</code></td><td><code>x = x ** y</code></td></tr>
<tr><td><code>x &= y</code></td><td><code>x = x & y</code></td></tr>
<tr><td><code>x |= y</code></td><td><code>x = x | y</code></td></tr>
<tr><td><code>x ^= y</code></td><td><code>x = x ^ y</code></td></tr>
<tr><td><code>x &lt;&lt;= y</code></td><td><code>x = x &lt;&lt; y</code></td></tr>
<tr><td><code>x >>= y</code></td><td><code>x = x >> y</code></td></tr>
</table>
