// Don't edit this file. This has been generated by Functions.cpp.gura.
#include "stdafx.h"

Gura_BeginModuleScope(glut)

class FunctionPack {
private:
	AutoPtr<Environment> _pEnv;
	AutoPtr<Function> _pFunc;
public:
	inline FunctionPack() {}
	inline void SetFunc(Environment &env, Function *pFunc) {
		_pEnv.reset(env.Clone());
		_pFunc.reset(pFunc);
	}
	inline void ClearFunc() {
		_pEnv.reset(nullptr);
		_pFunc.reset(nullptr);
	}
	inline Value Eval(Argument &arg) {
		if (_pFunc.IsNull()) return Value::Nil;
		Value result = _pFunc->Eval(*_pEnv, arg);
		if (_pEnv->GetSignal().IsSignalled()) {
			_pEnv->GetSignal().PrintSignal(*_pEnv->GetConsoleErr());
			exit(1);
		}
		return result;
	}
	inline Value Eval() {
		AutoPtr<Argument> pArg(new Argument(_pFunc.get()));
		return Eval(*pArg);
	}
	inline Value Eval(const Value &v1) {
		AutoPtr<Argument> pArg(new Argument(_pFunc.get()));
		if (!pArg->StoreValue(*_pEnv, v1)) return Value::Nil;
		return Eval(*pArg);
	}
	inline Value Eval(const Value &v1, const Value &v2) {
		AutoPtr<Argument> pArg(new Argument(_pFunc.get()));
		if (!pArg->StoreValue(*_pEnv, v1, v2)) return Value::Nil;
		return Eval(*pArg);
	}
	inline Value Eval(const Value &v1, const Value &v2, const Value &v3) {
		AutoPtr<Argument> pArg(new Argument(_pFunc.get()));
		if (!pArg->StoreValue(*_pEnv, v1, v2, v3)) return Value::Nil;
		return Eval(*pArg);
	}
	inline Value Eval(const Value &v1, const Value &v2, const Value &v3, const Value &v4) {
		AutoPtr<Argument> pArg(new Argument(_pFunc.get()));
		if (!pArg->StoreValue(*_pEnv, v1, v2, v3, v4)) return Value::Nil;
		return Eval(*pArg);
	}
};

struct Context {
	int idxMenu;
	FunctionPack funcPackOnWMClose;
	//FunctionPack funcPackOnMenu;
	FunctionPack funcPackOnMenuTbl[256];
	FunctionPack funcPackOnDisplay;
	FunctionPack funcPackOnReshape;
	FunctionPack funcPackOnKeyboard;
	FunctionPack funcPackOnMouse;
	FunctionPack funcPackOnMotion;
	FunctionPack funcPackOnPassiveMotion;
	FunctionPack funcPackOnEntry;
	FunctionPack funcPackOnVisibility;
	FunctionPack funcPackOnIdle;
	FunctionPack funcPackOnTimer;
	FunctionPack funcPackOnMenuState;
	FunctionPack funcPackOnSpecial;
	FunctionPack funcPackOnSpaceballMotion;
	FunctionPack funcPackOnSpaceballRotate;
	FunctionPack funcPackOnSpaceballButton;
	FunctionPack funcPackOnButtonBox;
	FunctionPack funcPackOnDials;
	FunctionPack funcPackOnTabletMotion;
	FunctionPack funcPackOnTabletButton;
	FunctionPack funcPackOnMenuStatus;
	FunctionPack funcPackOnOverlayDisplay;
	FunctionPack funcPackOnWindowStatus;
	FunctionPack funcPackOnKeyboardUp;
	FunctionPack funcPackOnSpecialUp;
	FunctionPack funcPackOnJoystick;
	inline Context() : idxMenu(0) {}
};

Context *g_pContext = nullptr;

template<int idx> void OnMenuTmpl(int value)
{
	g_pContext->funcPackOnMenuTbl[idx].Eval(Value(value));
}

typedef void (*OnMenuType)(int value);

OnMenuType g_OnMenus[] = {
	OnMenuTmpl<0>, OnMenuTmpl<1>, OnMenuTmpl<2>, OnMenuTmpl<3>,
	OnMenuTmpl<4>, OnMenuTmpl<5>, OnMenuTmpl<6>, OnMenuTmpl<7>,
	OnMenuTmpl<8>, OnMenuTmpl<9>, OnMenuTmpl<10>, OnMenuTmpl<11>,
	OnMenuTmpl<12>, OnMenuTmpl<13>, OnMenuTmpl<14>, OnMenuTmpl<15>,
	OnMenuTmpl<16>, OnMenuTmpl<17>, OnMenuTmpl<18>, OnMenuTmpl<19>,
	OnMenuTmpl<20>, OnMenuTmpl<21>, OnMenuTmpl<22>, OnMenuTmpl<23>,
	OnMenuTmpl<24>, OnMenuTmpl<25>, OnMenuTmpl<26>, OnMenuTmpl<27>,
	OnMenuTmpl<28>, OnMenuTmpl<29>, OnMenuTmpl<30>, OnMenuTmpl<31>,
	OnMenuTmpl<32>, OnMenuTmpl<33>, OnMenuTmpl<34>, OnMenuTmpl<35>,
	OnMenuTmpl<36>, OnMenuTmpl<37>, OnMenuTmpl<38>, OnMenuTmpl<39>,
	OnMenuTmpl<40>, OnMenuTmpl<41>, OnMenuTmpl<42>, OnMenuTmpl<43>,
	OnMenuTmpl<44>, OnMenuTmpl<45>, OnMenuTmpl<46>, OnMenuTmpl<47>,
	OnMenuTmpl<48>, OnMenuTmpl<49>, OnMenuTmpl<50>, OnMenuTmpl<51>,
	OnMenuTmpl<52>, OnMenuTmpl<53>, OnMenuTmpl<54>, OnMenuTmpl<55>,
	OnMenuTmpl<56>, OnMenuTmpl<57>, OnMenuTmpl<58>, OnMenuTmpl<59>,
	OnMenuTmpl<60>, OnMenuTmpl<61>, OnMenuTmpl<62>, OnMenuTmpl<63>,
	OnMenuTmpl<64>, OnMenuTmpl<65>, OnMenuTmpl<66>, OnMenuTmpl<67>,
	OnMenuTmpl<68>, OnMenuTmpl<69>, OnMenuTmpl<70>, OnMenuTmpl<71>,
	OnMenuTmpl<72>, OnMenuTmpl<73>, OnMenuTmpl<74>, OnMenuTmpl<75>,
	OnMenuTmpl<76>, OnMenuTmpl<77>, OnMenuTmpl<78>, OnMenuTmpl<79>,
	OnMenuTmpl<80>, OnMenuTmpl<81>, OnMenuTmpl<82>, OnMenuTmpl<83>,
	OnMenuTmpl<84>, OnMenuTmpl<85>, OnMenuTmpl<86>, OnMenuTmpl<87>,
	OnMenuTmpl<88>, OnMenuTmpl<89>, OnMenuTmpl<90>, OnMenuTmpl<91>,
	OnMenuTmpl<92>, OnMenuTmpl<93>, OnMenuTmpl<94>, OnMenuTmpl<95>,
	OnMenuTmpl<96>, OnMenuTmpl<97>, OnMenuTmpl<98>, OnMenuTmpl<99>,
	OnMenuTmpl<100>, OnMenuTmpl<101>, OnMenuTmpl<102>, OnMenuTmpl<103>,
	OnMenuTmpl<104>, OnMenuTmpl<105>, OnMenuTmpl<106>, OnMenuTmpl<107>,
	OnMenuTmpl<108>, OnMenuTmpl<109>, OnMenuTmpl<110>, OnMenuTmpl<111>,
	OnMenuTmpl<112>, OnMenuTmpl<113>, OnMenuTmpl<114>, OnMenuTmpl<115>,
	OnMenuTmpl<116>, OnMenuTmpl<117>, OnMenuTmpl<118>, OnMenuTmpl<119>,
	OnMenuTmpl<120>, OnMenuTmpl<121>, OnMenuTmpl<122>, OnMenuTmpl<123>,
	OnMenuTmpl<124>, OnMenuTmpl<125>, OnMenuTmpl<126>, OnMenuTmpl<127>,
};

void OnWMClose()
{
	g_pContext->funcPackOnWMClose.Eval();
}

/*
void OnMenu(int value)
{
	g_pContext->funcPackOnMenu.Eval(Value(value));
}
*/

void OnDisplay(void)
{
	g_pContext->funcPackOnDisplay.Eval();
}

void OnReshape(int width, int height)
{
	g_pContext->funcPackOnReshape.Eval(Value(width), Value(height));
}

void OnKeyboard(unsigned char key, int x, int y)
{
	g_pContext->funcPackOnKeyboard.Eval(Value(key), Value(x), Value(y));
}

void OnMouse(int button, int state, int x, int y)
{
	g_pContext->funcPackOnMouse.Eval(Value(button), Value(state), Value(x), Value(y));
}

void OnMotion(int x, int y)
{
	g_pContext->funcPackOnMotion.Eval(Value(x), Value(y));
}

void OnPassiveMotion(int x, int y)
{
	g_pContext->funcPackOnPassiveMotion.Eval(Value(x), Value(y));
}

void OnEntry(int state)
{
	g_pContext->funcPackOnEntry.Eval(Value(state));
}

void OnVisibility(int state)
{
	g_pContext->funcPackOnVisibility.Eval(Value(state));
}

void OnIdle(void)
{
	g_pContext->funcPackOnIdle.Eval();
}

void OnTimer(int value)
{
	g_pContext->funcPackOnTimer.Eval(Value(value));
}

void OnMenuState(int state)
{
	g_pContext->funcPackOnMenuState.Eval(Value(state));
}

void OnSpecial(int key, int x, int y)
{
	g_pContext->funcPackOnSpecial.Eval(Value(key), Value(x), Value(y));
}

void OnSpaceballMotion(int x, int y, int z)
{
	g_pContext->funcPackOnSpaceballMotion.Eval(Value(x), Value(y), Value(z));
}

void OnSpaceballRotate(int x, int y, int z)
{
	g_pContext->funcPackOnSpaceballRotate.Eval(Value(x), Value(y), Value(z));
}

void OnSpaceballButton(int button, int state)
{
	g_pContext->funcPackOnSpaceballButton.Eval(Value(button), Value(state));
}

void OnButtonBox(int button, int state)
{
	g_pContext->funcPackOnButtonBox.Eval(Value(button), Value(state));
}

void OnDials(int dial, int value)
{
	g_pContext->funcPackOnDials.Eval(Value(dial), Value(value));
}

void OnTabletMotion(int x, int y)
{
	g_pContext->funcPackOnTabletMotion.Eval(Value(x), Value(y));
}

void OnTabletButton(int button, int state, int x, int y)
{
	g_pContext->funcPackOnTabletButton.Eval(Value(button), Value(state), Value(x), Value(y));
}

void OnMenuStatus(int status, int x, int y)
{
	g_pContext->funcPackOnMenuStatus.Eval(Value(status), Value(x), Value(y));
}

void OnOverlayDisplay(void)
{
	g_pContext->funcPackOnOverlayDisplay.Eval();
}

void OnWindowStatus(int state)
{
	g_pContext->funcPackOnWindowStatus.Eval(Value(state));
}

void OnKeyboardUp(unsigned char key, int x, int y)
{
	g_pContext->funcPackOnKeyboardUp.Eval(Value(key), Value(x), Value(y));
}

void OnSpecialUp(int key, int x, int y)
{
	g_pContext->funcPackOnSpecialUp.Eval(Value(key), Value(x), Value(y));
}

void OnJoystick(unsigned int buttonMask, int x, int y, int z)
{
	g_pContext->funcPackOnJoystick.Eval(Value(buttonMask), Value(x), Value(y), Value(z));
}

// glut.glutInit
Gura_DeclareFunctionAlias(__glutInit, "glutInit")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "argv", VTYPE_string, OCCUR_Once, FLAG_ListVar);
	AddHelp(
		Gura_Symbol(en),
		"`glutInit` is used to initialize the GLUT library.\n");
}

Gura_ImplementFunction(__glutInit)
{
	const ValueList &argv = arg.GetList(0);
	int argc = static_cast<int>(argv.size());
	char **_argv = nullptr;
	if (argc > 0) {
		_argv = new char *[argc];
		int i = 0;
		foreach_const (ValueList, pValue, argv) {
			_argv[i++] = strdup(pValue->GetString());
		}
	}
	glutInit(&argc, _argv);
	Value _rtnVal;
	Object_list *pObjList = _rtnVal.InitAsList(env);
	if (argc > 0) {
		pObjList->Reserve(argc);
		for (int i = 0; i < argc; i++) {
			pObjList->Add(Value(_argv[i]));
			::free(_argv[i]);
		}
		delete[] _argv;
	}
	return ReturnValue(env, arg, _rtnVal);
}

// glut.glutInitDisplayMode
Gura_DeclareFunctionAlias(__glutInitDisplayMode, "glutInitDisplayMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutInitDisplayMode` sets the *initial display mode*.\n");
}

Gura_ImplementFunction(__glutInitDisplayMode)
{
	unsigned int mode = arg.GetUInt(0);
	glutInitDisplayMode(mode);
	return Value::Nil;
}

// glut.glutInitDisplayString
Gura_DeclareFunctionAlias(__glutInitDisplayString, "glutInitDisplayString")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "string", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutInitDisplayString)
{
	const char *string = arg.GetString(0);
	glutInitDisplayString(string);
	return Value::Nil;
}

// glut.glutInitWindowPosition
Gura_DeclareFunctionAlias(__glutInitWindowPosition, "glutInitWindowPosition")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutInitWindowPosition` sets the initial window position.	\n");
}

Gura_ImplementFunction(__glutInitWindowPosition)
{
	int x = arg.GetInt(0);
	int y = arg.GetInt(1);
	glutInitWindowPosition(x, y);
	return Value::Nil;
}

// glut.glutInitWindowSize
Gura_DeclareFunctionAlias(__glutInitWindowSize, "glutInitWindowSize")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutInitWindowSize` sets the initial window size.	\n");
}

Gura_ImplementFunction(__glutInitWindowSize)
{
	int width = arg.GetInt(0);
	int height = arg.GetInt(1);
	glutInitWindowSize(width, height);
	return Value::Nil;
}

// glut.glutMainLoop
Gura_DeclareFunctionAlias(__glutMainLoop, "glutMainLoop")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutMainLoop` enters the GLUT event processing loop.\n");
}

Gura_ImplementFunction(__glutMainLoop)
{
	glutMainLoop();
	return Value::Nil;
}

// glut.glutCreateWindow
Gura_DeclareFunctionAlias(__glutCreateWindow, "glutCreateWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "title", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutCreateWindow` creates a top-level window.\n");
}

Gura_ImplementFunction(__glutCreateWindow)
{
	const char *title = arg.GetString(0);
	int _rtn = glutCreateWindow(title);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutCreateSubWindow
Gura_DeclareFunctionAlias(__glutCreateSubWindow, "glutCreateSubWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "win", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutCreateSubWindow` creates a subwindow.\n");
}

Gura_ImplementFunction(__glutCreateSubWindow)
{
	int win = arg.GetInt(0);
	int x = arg.GetInt(1);
	int y = arg.GetInt(2);
	int width = arg.GetInt(3);
	int height = arg.GetInt(4);
	int _rtn = glutCreateSubWindow(win, x, y, width, height);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutDestroyWindow
Gura_DeclareFunctionAlias(__glutDestroyWindow, "glutDestroyWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "win", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutDestroyWindow` destroys the specified window.\n");
}

Gura_ImplementFunction(__glutDestroyWindow)
{
	int win = arg.GetInt(0);
	glutDestroyWindow(win);
	return Value::Nil;
}

// glut.glutPostRedisplay
Gura_DeclareFunctionAlias(__glutPostRedisplay, "glutPostRedisplay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutPostRedisplay marks the *current window* as needing to be redisplayed.\n");
}

Gura_ImplementFunction(__glutPostRedisplay)
{
	glutPostRedisplay();
	return Value::Nil;
}

// glut.glutPostWindowRedisplay
Gura_DeclareFunctionAlias(__glutPostWindowRedisplay, "glutPostWindowRedisplay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "win", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutPostWindowRedisplay)
{
	int win = arg.GetInt(0);
	glutPostWindowRedisplay(win);
	return Value::Nil;
}

// glut.glutSwapBuffers
Gura_DeclareFunctionAlias(__glutSwapBuffers, "glutSwapBuffers")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutSwapBuffers` swaps the buffers of the *current window* if double buffered.\n");
}

Gura_ImplementFunction(__glutSwapBuffers)
{
	glutSwapBuffers();
	return Value::Nil;
}

// glut.glutGetWindow
Gura_DeclareFunctionAlias(__glutGetWindow, "glutGetWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"`glutGetWindow` returns the identifier of the *current window*.\n");
}

Gura_ImplementFunction(__glutGetWindow)
{
	int _rtn = glutGetWindow();
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutSetWindow
Gura_DeclareFunctionAlias(__glutSetWindow, "glutSetWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "win", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutSetWindow` sets the *current window*.\n");
}

Gura_ImplementFunction(__glutSetWindow)
{
	int win = arg.GetInt(0);
	glutSetWindow(win);
	return Value::Nil;
}

// glut.glutSetWindowTitle
Gura_DeclareFunctionAlias(__glutSetWindowTitle, "glutSetWindowTitle")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "title", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutSetWindowTitle` changes the window title of the current top-level window.\n");
}

Gura_ImplementFunction(__glutSetWindowTitle)
{
	const char *title = arg.GetString(0);
	glutSetWindowTitle(title);
	return Value::Nil;
}

// glut.glutSetIconTitle
Gura_DeclareFunctionAlias(__glutSetIconTitle, "glutSetIconTitle")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "title", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutSetIconTitle` changes the icon title of the current top-level window.\n");
}

Gura_ImplementFunction(__glutSetIconTitle)
{
	const char *title = arg.GetString(0);
	glutSetIconTitle(title);
	return Value::Nil;
}

// glut.glutPositionWindow
Gura_DeclareFunctionAlias(__glutPositionWindow, "glutPositionWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutPositionWindow` requests a change to the position of the *current window*.\n");
}

Gura_ImplementFunction(__glutPositionWindow)
{
	int x = arg.GetInt(0);
	int y = arg.GetInt(1);
	glutPositionWindow(x, y);
	return Value::Nil;
}

// glut.glutReshapeWindow
Gura_DeclareFunctionAlias(__glutReshapeWindow, "glutReshapeWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"`glutReshapeWindow` requests a change to the size of the *current window*.\n");
}

Gura_ImplementFunction(__glutReshapeWindow)
{
	int width = arg.GetInt(0);
	int height = arg.GetInt(1);
	glutReshapeWindow(width, height);
	return Value::Nil;
}

// glut.glutPopWindow
Gura_DeclareFunctionAlias(__glutPopWindow, "glutPopWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutPopWindow)
{
	glutPopWindow();
	return Value::Nil;
}

// glut.glutPushWindow
Gura_DeclareFunctionAlias(__glutPushWindow, "glutPushWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutPushWindow)
{
	glutPushWindow();
	return Value::Nil;
}

// glut.glutIconifyWindow
Gura_DeclareFunctionAlias(__glutIconifyWindow, "glutIconifyWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutIconifyWindow)
{
	glutIconifyWindow();
	return Value::Nil;
}

// glut.glutShowWindow
Gura_DeclareFunctionAlias(__glutShowWindow, "glutShowWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutShowWindow)
{
	glutShowWindow();
	return Value::Nil;
}

// glut.glutHideWindow
Gura_DeclareFunctionAlias(__glutHideWindow, "glutHideWindow")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutHideWindow)
{
	glutHideWindow();
	return Value::Nil;
}

// glut.glutFullScreen
Gura_DeclareFunctionAlias(__glutFullScreen, "glutFullScreen")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutFullScreen)
{
	glutFullScreen();
	return Value::Nil;
}

// glut.glutSetCursor
Gura_DeclareFunctionAlias(__glutSetCursor, "glutSetCursor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "cursor", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSetCursor)
{
	int cursor = arg.GetInt(0);
	glutSetCursor(cursor);
	return Value::Nil;
}

// glut.glutWarpPointer
Gura_DeclareFunctionAlias(__glutWarpPointer, "glutWarpPointer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWarpPointer)
{
	int x = arg.GetInt(0);
	int y = arg.GetInt(1);
	glutWarpPointer(x, y);
	return Value::Nil;
}

// glut.glutEstablishOverlay
Gura_DeclareFunctionAlias(__glutEstablishOverlay, "glutEstablishOverlay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutEstablishOverlay)
{
	glutEstablishOverlay();
	return Value::Nil;
}

// glut.glutRemoveOverlay
Gura_DeclareFunctionAlias(__glutRemoveOverlay, "glutRemoveOverlay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutRemoveOverlay)
{
	glutRemoveOverlay();
	return Value::Nil;
}

// glut.glutUseLayer
Gura_DeclareFunctionAlias(__glutUseLayer, "glutUseLayer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "layer", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutUseLayer)
{
	GLenum layer = static_cast<GLenum>(arg.GetInt(0));
	glutUseLayer(layer);
	return Value::Nil;
}

// glut.glutPostOverlayRedisplay
Gura_DeclareFunctionAlias(__glutPostOverlayRedisplay, "glutPostOverlayRedisplay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutPostOverlayRedisplay)
{
	glutPostOverlayRedisplay();
	return Value::Nil;
}

// glut.glutPostWindowOverlayRedisplay
Gura_DeclareFunctionAlias(__glutPostWindowOverlayRedisplay, "glutPostWindowOverlayRedisplay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "win", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutPostWindowOverlayRedisplay)
{
	int win = arg.GetInt(0);
	glutPostWindowOverlayRedisplay(win);
	return Value::Nil;
}

// glut.glutShowOverlay
Gura_DeclareFunctionAlias(__glutShowOverlay, "glutShowOverlay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutShowOverlay)
{
	glutShowOverlay();
	return Value::Nil;
}

// glut.glutHideOverlay
Gura_DeclareFunctionAlias(__glutHideOverlay, "glutHideOverlay")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutHideOverlay)
{
	glutHideOverlay();
	return Value::Nil;
}

// glut.glutCreateMenu
Gura_DeclareFunctionAlias(__glutCreateMenu, "glutCreateMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutCreateMenu)
{
	const Function *func = Object_function::GetObject(arg, 0)->GetFunction();
	int idxMenu = g_pContext->idxMenu++;
	if (idxMenu >= ArraySizeOf(g_OnMenus)) {
		env.SetError(ERR_OutOfRangeError, "too many menus");
		return Value::Nil;
	}
	g_pContext->funcPackOnMenuTbl[idxMenu].SetFunc(env, func->Reference());
	int _rtn = glutCreateMenu(g_OnMenus[idxMenu]);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutDestroyMenu
Gura_DeclareFunctionAlias(__glutDestroyMenu, "glutDestroyMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "menu", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutDestroyMenu)
{
	int menu = arg.GetInt(0);
	glutDestroyMenu(menu);
	return Value::Nil;
}

// glut.glutGetMenu
Gura_DeclareFunctionAlias(__glutGetMenu, "glutGetMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGetMenu)
{
	int _rtn = glutGetMenu();
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutSetMenu
Gura_DeclareFunctionAlias(__glutSetMenu, "glutSetMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "menu", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSetMenu)
{
	int menu = arg.GetInt(0);
	glutSetMenu(menu);
	return Value::Nil;
}

// glut.glutAddMenuEntry
Gura_DeclareFunctionAlias(__glutAddMenuEntry, "glutAddMenuEntry")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "label", VTYPE_string, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutAddMenuEntry)
{
	const char *label = arg.GetString(0);
	int value = arg.GetInt(1);
	glutAddMenuEntry(label, value);
	return Value::Nil;
}

// glut.glutAddSubMenu
Gura_DeclareFunctionAlias(__glutAddSubMenu, "glutAddSubMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "label", VTYPE_string, OCCUR_Once, FLAG_None);
	DeclareArg(env, "submenu", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutAddSubMenu)
{
	const char *label = arg.GetString(0);
	int submenu = arg.GetInt(1);
	glutAddSubMenu(label, submenu);
	return Value::Nil;
}

// glut.glutChangeToMenuEntry
Gura_DeclareFunctionAlias(__glutChangeToMenuEntry, "glutChangeToMenuEntry")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "item", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "label", VTYPE_string, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutChangeToMenuEntry)
{
	int item = arg.GetInt(0);
	const char *label = arg.GetString(1);
	int value = arg.GetInt(2);
	glutChangeToMenuEntry(item, label, value);
	return Value::Nil;
}

// glut.glutChangeToSubMenu
Gura_DeclareFunctionAlias(__glutChangeToSubMenu, "glutChangeToSubMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "item", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "label", VTYPE_string, OCCUR_Once, FLAG_None);
	DeclareArg(env, "submenu", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutChangeToSubMenu)
{
	int item = arg.GetInt(0);
	const char *label = arg.GetString(1);
	int submenu = arg.GetInt(2);
	glutChangeToSubMenu(item, label, submenu);
	return Value::Nil;
}

// glut.glutRemoveMenuItem
Gura_DeclareFunctionAlias(__glutRemoveMenuItem, "glutRemoveMenuItem")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "item", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutRemoveMenuItem)
{
	int item = arg.GetInt(0);
	glutRemoveMenuItem(item);
	return Value::Nil;
}

// glut.glutAttachMenu
Gura_DeclareFunctionAlias(__glutAttachMenu, "glutAttachMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "button", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutAttachMenu)
{
	int button = arg.GetInt(0);
	glutAttachMenu(button);
	return Value::Nil;
}

// glut.glutDetachMenu
Gura_DeclareFunctionAlias(__glutDetachMenu, "glutDetachMenu")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "button", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutDetachMenu)
{
	int button = arg.GetInt(0);
	glutDetachMenu(button);
	return Value::Nil;
}

// glut.glutDisplayFunc
Gura_DeclareFunctionAlias(__glutDisplayFunc, "glutDisplayFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutDisplayFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnDisplay.ClearFunc();
		glutDisplayFunc(nullptr);
	} else {
		g_pContext->funcPackOnDisplay.SetFunc(env, func->Reference());
		glutDisplayFunc(OnDisplay);
	}
	return Value::Nil;
}

// glut.glutReshapeFunc
Gura_DeclareFunctionAlias(__glutReshapeFunc, "glutReshapeFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutReshapeFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnReshape.ClearFunc();
		glutReshapeFunc(nullptr);
	} else {
		g_pContext->funcPackOnReshape.SetFunc(env, func->Reference());
		glutReshapeFunc(OnReshape);
	}
	return Value::Nil;
}

// glut.glutKeyboardFunc
Gura_DeclareFunctionAlias(__glutKeyboardFunc, "glutKeyboardFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutKeyboardFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnKeyboard.ClearFunc();
		glutKeyboardFunc(nullptr);
	} else {
		g_pContext->funcPackOnKeyboard.SetFunc(env, func->Reference());
		glutKeyboardFunc(OnKeyboard);
	}
	return Value::Nil;
}

// glut.glutMouseFunc
Gura_DeclareFunctionAlias(__glutMouseFunc, "glutMouseFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutMouseFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnMouse.ClearFunc();
		glutMouseFunc(nullptr);
	} else {
		g_pContext->funcPackOnMouse.SetFunc(env, func->Reference());
		glutMouseFunc(OnMouse);
	}
	return Value::Nil;
}

// glut.glutMotionFunc
Gura_DeclareFunctionAlias(__glutMotionFunc, "glutMotionFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutMotionFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnMotion.ClearFunc();
		glutMotionFunc(nullptr);
	} else {
		g_pContext->funcPackOnMotion.SetFunc(env, func->Reference());
		glutMotionFunc(OnMotion);
	}
	return Value::Nil;
}

// glut.glutPassiveMotionFunc
Gura_DeclareFunctionAlias(__glutPassiveMotionFunc, "glutPassiveMotionFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutPassiveMotionFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnPassiveMotion.ClearFunc();
		glutPassiveMotionFunc(nullptr);
	} else {
		g_pContext->funcPackOnPassiveMotion.SetFunc(env, func->Reference());
		glutPassiveMotionFunc(OnPassiveMotion);
	}
	return Value::Nil;
}

// glut.glutEntryFunc
Gura_DeclareFunctionAlias(__glutEntryFunc, "glutEntryFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutEntryFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnEntry.ClearFunc();
		glutEntryFunc(nullptr);
	} else {
		g_pContext->funcPackOnEntry.SetFunc(env, func->Reference());
		glutEntryFunc(OnEntry);
	}
	return Value::Nil;
}

// glut.glutVisibilityFunc
Gura_DeclareFunctionAlias(__glutVisibilityFunc, "glutVisibilityFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutVisibilityFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnVisibility.ClearFunc();
		glutVisibilityFunc(nullptr);
	} else {
		g_pContext->funcPackOnVisibility.SetFunc(env, func->Reference());
		glutVisibilityFunc(OnVisibility);
	}
	return Value::Nil;
}

// glut.glutIdleFunc
Gura_DeclareFunctionAlias(__glutIdleFunc, "glutIdleFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutIdleFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnIdle.ClearFunc();
		glutIdleFunc(nullptr);
	} else {
		g_pContext->funcPackOnIdle.SetFunc(env, func->Reference());
		glutIdleFunc(OnIdle);
	}
	return Value::Nil;
}

// glut.glutTimerFunc
Gura_DeclareFunctionAlias(__glutTimerFunc, "glutTimerFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "millis", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	DeclareArg(env, "value", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutTimerFunc)
{
	unsigned int millis = arg.GetUInt(0);
	const Function *func = arg.IsValid(1)? Object_function::GetObject(arg, 1)->GetFunction() : nullptr;
	int value = arg.GetInt(2);
	if (func == nullptr) {
		g_pContext->funcPackOnTimer.ClearFunc();
		glutTimerFunc(millis, nullptr, value);
	} else {
		g_pContext->funcPackOnTimer.SetFunc(env, func->Reference());
		glutTimerFunc(millis, OnTimer, value);
	}
	return Value::Nil;
}

// glut.glutMenuStateFunc
Gura_DeclareFunctionAlias(__glutMenuStateFunc, "glutMenuStateFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutMenuStateFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnMenuState.ClearFunc();
		glutMenuStateFunc(nullptr);
	} else {
		g_pContext->funcPackOnMenuState.SetFunc(env, func->Reference());
		glutMenuStateFunc(OnMenuState);
	}
	return Value::Nil;
}

// glut.glutSpecialFunc
Gura_DeclareFunctionAlias(__glutSpecialFunc, "glutSpecialFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSpecialFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnSpecial.ClearFunc();
		glutSpecialFunc(nullptr);
	} else {
		g_pContext->funcPackOnSpecial.SetFunc(env, func->Reference());
		glutSpecialFunc(OnSpecial);
	}
	return Value::Nil;
}

// glut.glutSpaceballMotionFunc
Gura_DeclareFunctionAlias(__glutSpaceballMotionFunc, "glutSpaceballMotionFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSpaceballMotionFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnSpaceballMotion.ClearFunc();
		glutSpaceballMotionFunc(nullptr);
	} else {
		g_pContext->funcPackOnSpaceballMotion.SetFunc(env, func->Reference());
		glutSpaceballMotionFunc(OnSpaceballMotion);
	}
	return Value::Nil;
}

// glut.glutSpaceballRotateFunc
Gura_DeclareFunctionAlias(__glutSpaceballRotateFunc, "glutSpaceballRotateFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSpaceballRotateFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnSpaceballRotate.ClearFunc();
		glutSpaceballRotateFunc(nullptr);
	} else {
		g_pContext->funcPackOnSpaceballRotate.SetFunc(env, func->Reference());
		glutSpaceballRotateFunc(OnSpaceballRotate);
	}
	return Value::Nil;
}

// glut.glutSpaceballButtonFunc
Gura_DeclareFunctionAlias(__glutSpaceballButtonFunc, "glutSpaceballButtonFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSpaceballButtonFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnSpaceballButton.ClearFunc();
		glutSpaceballButtonFunc(nullptr);
	} else {
		g_pContext->funcPackOnSpaceballButton.SetFunc(env, func->Reference());
		glutSpaceballButtonFunc(OnSpaceballButton);
	}
	return Value::Nil;
}

// glut.glutButtonBoxFunc
Gura_DeclareFunctionAlias(__glutButtonBoxFunc, "glutButtonBoxFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutButtonBoxFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnButtonBox.ClearFunc();
		glutButtonBoxFunc(nullptr);
	} else {
		g_pContext->funcPackOnButtonBox.SetFunc(env, func->Reference());
		glutButtonBoxFunc(OnButtonBox);
	}
	return Value::Nil;
}

// glut.glutDialsFunc
Gura_DeclareFunctionAlias(__glutDialsFunc, "glutDialsFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutDialsFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnDials.ClearFunc();
		glutDialsFunc(nullptr);
	} else {
		g_pContext->funcPackOnDials.SetFunc(env, func->Reference());
		glutDialsFunc(OnDials);
	}
	return Value::Nil;
}

// glut.glutTabletMotionFunc
Gura_DeclareFunctionAlias(__glutTabletMotionFunc, "glutTabletMotionFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutTabletMotionFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnTabletMotion.ClearFunc();
		glutTabletMotionFunc(nullptr);
	} else {
		g_pContext->funcPackOnTabletMotion.SetFunc(env, func->Reference());
		glutTabletMotionFunc(OnTabletMotion);
	}
	return Value::Nil;
}

// glut.glutTabletButtonFunc
Gura_DeclareFunctionAlias(__glutTabletButtonFunc, "glutTabletButtonFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutTabletButtonFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnTabletButton.ClearFunc();
		glutTabletButtonFunc(nullptr);
	} else {
		g_pContext->funcPackOnTabletButton.SetFunc(env, func->Reference());
		glutTabletButtonFunc(OnTabletButton);
	}
	return Value::Nil;
}

// glut.glutMenuStatusFunc
Gura_DeclareFunctionAlias(__glutMenuStatusFunc, "glutMenuStatusFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutMenuStatusFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnMenuStatus.ClearFunc();
		glutMenuStatusFunc(nullptr);
	} else {
		g_pContext->funcPackOnMenuStatus.SetFunc(env, func->Reference());
		glutMenuStatusFunc(OnMenuStatus);
	}
	return Value::Nil;
}

// glut.glutOverlayDisplayFunc
Gura_DeclareFunctionAlias(__glutOverlayDisplayFunc, "glutOverlayDisplayFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutOverlayDisplayFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnOverlayDisplay.ClearFunc();
		glutOverlayDisplayFunc(nullptr);
	} else {
		g_pContext->funcPackOnOverlayDisplay.SetFunc(env, func->Reference());
		glutOverlayDisplayFunc(OnOverlayDisplay);
	}
	return Value::Nil;
}

// glut.glutWindowStatusFunc
Gura_DeclareFunctionAlias(__glutWindowStatusFunc, "glutWindowStatusFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWindowStatusFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnWindowStatus.ClearFunc();
		glutWindowStatusFunc(nullptr);
	} else {
		g_pContext->funcPackOnWindowStatus.SetFunc(env, func->Reference());
		glutWindowStatusFunc(OnWindowStatus);
	}
	return Value::Nil;
}

// glut.glutKeyboardUpFunc
Gura_DeclareFunctionAlias(__glutKeyboardUpFunc, "glutKeyboardUpFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutKeyboardUpFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnKeyboardUp.ClearFunc();
		glutKeyboardUpFunc(nullptr);
	} else {
		g_pContext->funcPackOnKeyboardUp.SetFunc(env, func->Reference());
		glutKeyboardUpFunc(OnKeyboardUp);
	}
	return Value::Nil;
}

// glut.glutSpecialUpFunc
Gura_DeclareFunctionAlias(__glutSpecialUpFunc, "glutSpecialUpFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSpecialUpFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	if (func == nullptr) {
		g_pContext->funcPackOnSpecialUp.ClearFunc();
		glutSpecialUpFunc(nullptr);
	} else {
		g_pContext->funcPackOnSpecialUp.SetFunc(env, func->Reference());
		glutSpecialUpFunc(OnSpecialUp);
	}
	return Value::Nil;
}

// glut.glutJoystickFunc
Gura_DeclareFunctionAlias(__glutJoystickFunc, "glutJoystickFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "func", VTYPE_function, OCCUR_Once, FLAG_Nil);
	DeclareArg(env, "pollInterval", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutJoystickFunc)
{
	const Function *func = arg.IsValid(0)? Object_function::GetObject(arg, 0)->GetFunction() : nullptr;
	int pollInterval = arg.GetInt(1);
	if (func == nullptr) {
		g_pContext->funcPackOnJoystick.ClearFunc();
		glutJoystickFunc(nullptr, pollInterval);
	} else {
		g_pContext->funcPackOnJoystick.SetFunc(env, func->Reference());
		glutJoystickFunc(OnJoystick, pollInterval);
	}
	return Value::Nil;
}

// glut.glutSetColor
Gura_DeclareFunctionAlias(__glutSetColor, "glutSetColor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "ndx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSetColor)
{
	int ndx = arg.GetInt(0);
	GLfloat red = arg.GetFloat(1);
	GLfloat green = arg.GetFloat(2);
	GLfloat blue = arg.GetFloat(3);
	glutSetColor(ndx, red, green, blue);
	return Value::Nil;
}

// glut.glutGetColor
Gura_DeclareFunctionAlias(__glutGetColor, "glutGetColor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "ndx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "component", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGetColor)
{
	int ndx = arg.GetInt(0);
	int component = arg.GetInt(1);
	GLfloat _rtn = glutGetColor(ndx, component);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutCopyColormap
Gura_DeclareFunctionAlias(__glutCopyColormap, "glutCopyColormap")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "win", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutCopyColormap)
{
	int win = arg.GetInt(0);
	glutCopyColormap(win);
	return Value::Nil;
}

// glut.glutGet
Gura_DeclareFunctionAlias(__glutGet, "glutGet")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGet)
{
	GLenum type = static_cast<GLenum>(arg.GetInt(0));
	int _rtn = glutGet(type);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutDeviceGet
Gura_DeclareFunctionAlias(__glutDeviceGet, "glutDeviceGet")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutDeviceGet)
{
	GLenum type = static_cast<GLenum>(arg.GetInt(0));
	int _rtn = glutDeviceGet(type);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutExtensionSupported
Gura_DeclareFunctionAlias(__glutExtensionSupported, "glutExtensionSupported")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutExtensionSupported)
{
	const char *name = arg.GetString(0);
	int _rtn = glutExtensionSupported(name);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutGetModifiers
Gura_DeclareFunctionAlias(__glutGetModifiers, "glutGetModifiers")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGetModifiers)
{
	int _rtn = glutGetModifiers();
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutLayerGet
Gura_DeclareFunctionAlias(__glutLayerGet, "glutLayerGet")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutLayerGet)
{
	GLenum type = static_cast<GLenum>(arg.GetInt(0));
	int _rtn = glutLayerGet(type);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutGetProcAddress
Gura_DeclareFunctionAlias(__glutGetProcAddress, "glutGetProcAddress")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "procName", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGetProcAddress)
{
#if 0
	const char *procName = arg.GetString(0);
	glutGetProcAddress(procName);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glutGetProcAddress");
	return Value::Nil;
}

// glut.glutBitmapCharacter
Gura_DeclareFunctionAlias(__glutBitmapCharacter, "glutBitmapCharacter")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "font", VTYPE_Font, OCCUR_Once, FLAG_None);
	DeclareArg(env, "character", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutBitmapCharacter)
{
	void *font = Object_Font::GetObject(arg, 0)->GetEntity();
	int character = arg.GetInt(1);
	glutBitmapCharacter(font, character);
	return Value::Nil;
}

// glut.glutBitmapWidth
Gura_DeclareFunctionAlias(__glutBitmapWidth, "glutBitmapWidth")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "font", VTYPE_Font, OCCUR_Once, FLAG_None);
	DeclareArg(env, "character", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutBitmapWidth)
{
	void *font = Object_Font::GetObject(arg, 0)->GetEntity();
	int character = arg.GetInt(1);
	int _rtn = glutBitmapWidth(font, character);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutStrokeCharacter
Gura_DeclareFunctionAlias(__glutStrokeCharacter, "glutStrokeCharacter")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "font", VTYPE_Font, OCCUR_Once, FLAG_None);
	DeclareArg(env, "character", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutStrokeCharacter)
{
	void *font = Object_Font::GetObject(arg, 0)->GetEntity();
	int character = arg.GetInt(1);
	glutStrokeCharacter(font, character);
	return Value::Nil;
}

// glut.glutStrokeWidth
Gura_DeclareFunctionAlias(__glutStrokeWidth, "glutStrokeWidth")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "font", VTYPE_Font, OCCUR_Once, FLAG_None);
	DeclareArg(env, "character", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutStrokeWidth)
{
	void *font = Object_Font::GetObject(arg, 0)->GetEntity();
	int character = arg.GetInt(1);
	int _rtn = glutStrokeWidth(font, character);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutBitmapLength
Gura_DeclareFunctionAlias(__glutBitmapLength, "glutBitmapLength")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "font", VTYPE_Font, OCCUR_Once, FLAG_None);
	DeclareArg(env, "string", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutBitmapLength)
{
	void *font = Object_Font::GetObject(arg, 0)->GetEntity();
	const unsigned char *string = reinterpret_cast<const unsigned char *>(arg.GetString(1));
	int _rtn = glutBitmapLength(font, string);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutStrokeLength
Gura_DeclareFunctionAlias(__glutStrokeLength, "glutStrokeLength")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "font", VTYPE_Font, OCCUR_Once, FLAG_None);
	DeclareArg(env, "string", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutStrokeLength)
{
	void *font = Object_Font::GetObject(arg, 0)->GetEntity();
	const unsigned char *string = reinterpret_cast<const unsigned char *>(arg.GetString(1));
	int _rtn = glutStrokeLength(font, string);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutWireSphere
Gura_DeclareFunctionAlias(__glutWireSphere, "glutWireSphere")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "radius", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "slices", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stacks", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireSphere)
{
	GLdouble radius = arg.GetDouble(0);
	GLint slices = arg.GetInt(1);
	GLint stacks = arg.GetInt(2);
	glutWireSphere(radius, slices, stacks);
	return Value::Nil;
}

// glut.glutSolidSphere
Gura_DeclareFunctionAlias(__glutSolidSphere, "glutSolidSphere")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "radius", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "slices", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stacks", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidSphere)
{
	GLdouble radius = arg.GetDouble(0);
	GLint slices = arg.GetInt(1);
	GLint stacks = arg.GetInt(2);
	glutSolidSphere(radius, slices, stacks);
	return Value::Nil;
}

// glut.glutWireCone
Gura_DeclareFunctionAlias(__glutWireCone, "glutWireCone")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "base", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "slices", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stacks", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireCone)
{
	GLdouble base = arg.GetDouble(0);
	GLdouble height = arg.GetDouble(1);
	GLint slices = arg.GetInt(2);
	GLint stacks = arg.GetInt(3);
	glutWireCone(base, height, slices, stacks);
	return Value::Nil;
}

// glut.glutSolidCone
Gura_DeclareFunctionAlias(__glutSolidCone, "glutSolidCone")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "base", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "slices", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stacks", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidCone)
{
	GLdouble base = arg.GetDouble(0);
	GLdouble height = arg.GetDouble(1);
	GLint slices = arg.GetInt(2);
	GLint stacks = arg.GetInt(3);
	glutSolidCone(base, height, slices, stacks);
	return Value::Nil;
}

// glut.glutWireCube
Gura_DeclareFunctionAlias(__glutWireCube, "glutWireCube")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireCube)
{
	GLdouble size = arg.GetDouble(0);
	glutWireCube(size);
	return Value::Nil;
}

// glut.glutSolidCube
Gura_DeclareFunctionAlias(__glutSolidCube, "glutSolidCube")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidCube)
{
	GLdouble size = arg.GetDouble(0);
	glutSolidCube(size);
	return Value::Nil;
}

// glut.glutWireTorus
Gura_DeclareFunctionAlias(__glutWireTorus, "glutWireTorus")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "innerRadius", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "outerRadius", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "sides", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "rings", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireTorus)
{
	GLdouble innerRadius = arg.GetDouble(0);
	GLdouble outerRadius = arg.GetDouble(1);
	GLint sides = arg.GetInt(2);
	GLint rings = arg.GetInt(3);
	glutWireTorus(innerRadius, outerRadius, sides, rings);
	return Value::Nil;
}

// glut.glutSolidTorus
Gura_DeclareFunctionAlias(__glutSolidTorus, "glutSolidTorus")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "innerRadius", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "outerRadius", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "sides", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "rings", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidTorus)
{
	GLdouble innerRadius = arg.GetDouble(0);
	GLdouble outerRadius = arg.GetDouble(1);
	GLint sides = arg.GetInt(2);
	GLint rings = arg.GetInt(3);
	glutSolidTorus(innerRadius, outerRadius, sides, rings);
	return Value::Nil;
}

// glut.glutWireDodecahedron
Gura_DeclareFunctionAlias(__glutWireDodecahedron, "glutWireDodecahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireDodecahedron)
{
	glutWireDodecahedron();
	return Value::Nil;
}

// glut.glutSolidDodecahedron
Gura_DeclareFunctionAlias(__glutSolidDodecahedron, "glutSolidDodecahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidDodecahedron)
{
	glutSolidDodecahedron();
	return Value::Nil;
}

// glut.glutWireTeapot
Gura_DeclareFunctionAlias(__glutWireTeapot, "glutWireTeapot")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireTeapot)
{
	GLdouble size = arg.GetDouble(0);
	glutWireTeapot(size);
	return Value::Nil;
}

// glut.glutSolidTeapot
Gura_DeclareFunctionAlias(__glutSolidTeapot, "glutSolidTeapot")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidTeapot)
{
	GLdouble size = arg.GetDouble(0);
	glutSolidTeapot(size);
	return Value::Nil;
}

// glut.glutWireOctahedron
Gura_DeclareFunctionAlias(__glutWireOctahedron, "glutWireOctahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireOctahedron)
{
	glutWireOctahedron();
	return Value::Nil;
}

// glut.glutSolidOctahedron
Gura_DeclareFunctionAlias(__glutSolidOctahedron, "glutSolidOctahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidOctahedron)
{
	glutSolidOctahedron();
	return Value::Nil;
}

// glut.glutWireTetrahedron
Gura_DeclareFunctionAlias(__glutWireTetrahedron, "glutWireTetrahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireTetrahedron)
{
	glutWireTetrahedron();
	return Value::Nil;
}

// glut.glutSolidTetrahedron
Gura_DeclareFunctionAlias(__glutSolidTetrahedron, "glutSolidTetrahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidTetrahedron)
{
	glutSolidTetrahedron();
	return Value::Nil;
}

// glut.glutWireIcosahedron
Gura_DeclareFunctionAlias(__glutWireIcosahedron, "glutWireIcosahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutWireIcosahedron)
{
	glutWireIcosahedron();
	return Value::Nil;
}

// glut.glutSolidIcosahedron
Gura_DeclareFunctionAlias(__glutSolidIcosahedron, "glutSolidIcosahedron")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSolidIcosahedron)
{
	glutSolidIcosahedron();
	return Value::Nil;
}

// glut.glutVideoResizeGet
Gura_DeclareFunctionAlias(__glutVideoResizeGet, "glutVideoResizeGet")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutVideoResizeGet)
{
	GLenum param = static_cast<GLenum>(arg.GetInt(0));
	int _rtn = glutVideoResizeGet(param);
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutSetupVideoResizing
Gura_DeclareFunctionAlias(__glutSetupVideoResizing, "glutSetupVideoResizing")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSetupVideoResizing)
{
	glutSetupVideoResizing();
	return Value::Nil;
}

// glut.glutStopVideoResizing
Gura_DeclareFunctionAlias(__glutStopVideoResizing, "glutStopVideoResizing")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutStopVideoResizing)
{
	glutStopVideoResizing();
	return Value::Nil;
}

// glut.glutVideoResize
Gura_DeclareFunctionAlias(__glutVideoResize, "glutVideoResize")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutVideoResize)
{
	int x = arg.GetInt(0);
	int y = arg.GetInt(1);
	int width = arg.GetInt(2);
	int height = arg.GetInt(3);
	glutVideoResize(x, y, width, height);
	return Value::Nil;
}

// glut.glutVideoPan
Gura_DeclareFunctionAlias(__glutVideoPan, "glutVideoPan")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutVideoPan)
{
	int x = arg.GetInt(0);
	int y = arg.GetInt(1);
	int width = arg.GetInt(2);
	int height = arg.GetInt(3);
	glutVideoPan(x, y, width, height);
	return Value::Nil;
}

// glut.glutReportErrors
Gura_DeclareFunctionAlias(__glutReportErrors, "glutReportErrors")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutReportErrors)
{
	glutReportErrors();
	return Value::Nil;
}

// glut.glutIgnoreKeyRepeat
Gura_DeclareFunctionAlias(__glutIgnoreKeyRepeat, "glutIgnoreKeyRepeat")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "ignore", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutIgnoreKeyRepeat)
{
	int ignore = arg.GetInt(0);
	glutIgnoreKeyRepeat(ignore);
	return Value::Nil;
}

// glut.glutSetKeyRepeat
Gura_DeclareFunctionAlias(__glutSetKeyRepeat, "glutSetKeyRepeat")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "repeatMode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutSetKeyRepeat)
{
	int repeatMode = arg.GetInt(0);
	glutSetKeyRepeat(repeatMode);
	return Value::Nil;
}

// glut.glutForceJoystickFunc
Gura_DeclareFunctionAlias(__glutForceJoystickFunc, "glutForceJoystickFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutForceJoystickFunc)
{
	glutForceJoystickFunc();
	return Value::Nil;
}

// glut.glutGameModeString
Gura_DeclareFunctionAlias(__glutGameModeString, "glutGameModeString")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "string", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGameModeString)
{
	const char *string = arg.GetString(0);
	glutGameModeString(string);
	return Value::Nil;
}

// glut.glutEnterGameMode
Gura_DeclareFunctionAlias(__glutEnterGameMode, "glutEnterGameMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutEnterGameMode)
{
	int _rtn = glutEnterGameMode();
	return ReturnValue(env, arg, Value(_rtn));
}

// glut.glutLeaveGameMode
Gura_DeclareFunctionAlias(__glutLeaveGameMode, "glutLeaveGameMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutLeaveGameMode)
{
	glutLeaveGameMode();
	return Value::Nil;
}

// glut.glutGameModeGet
Gura_DeclareFunctionAlias(__glutGameModeGet, "glutGameModeGet")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glutGameModeGet)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	int _rtn = glutGameModeGet(mode);
	return ReturnValue(env, arg, Value(_rtn));
}


void AssignFunctions(Environment &env)
{
	g_pContext = new Context();
	Gura_AssignFunction(__glutInit);
	Gura_AssignFunction(__glutInitDisplayMode);
	Gura_AssignFunction(__glutInitDisplayString);
	Gura_AssignFunction(__glutInitWindowPosition);
	Gura_AssignFunction(__glutInitWindowSize);
	Gura_AssignFunction(__glutMainLoop);
	Gura_AssignFunction(__glutCreateWindow);
	Gura_AssignFunction(__glutCreateSubWindow);
	Gura_AssignFunction(__glutDestroyWindow);
	Gura_AssignFunction(__glutPostRedisplay);
	Gura_AssignFunction(__glutPostWindowRedisplay);
	Gura_AssignFunction(__glutSwapBuffers);
	Gura_AssignFunction(__glutGetWindow);
	Gura_AssignFunction(__glutSetWindow);
	Gura_AssignFunction(__glutSetWindowTitle);
	Gura_AssignFunction(__glutSetIconTitle);
	Gura_AssignFunction(__glutPositionWindow);
	Gura_AssignFunction(__glutReshapeWindow);
	Gura_AssignFunction(__glutPopWindow);
	Gura_AssignFunction(__glutPushWindow);
	Gura_AssignFunction(__glutIconifyWindow);
	Gura_AssignFunction(__glutShowWindow);
	Gura_AssignFunction(__glutHideWindow);
	Gura_AssignFunction(__glutFullScreen);
	Gura_AssignFunction(__glutSetCursor);
	Gura_AssignFunction(__glutWarpPointer);
	Gura_AssignFunction(__glutEstablishOverlay);
	Gura_AssignFunction(__glutRemoveOverlay);
	Gura_AssignFunction(__glutUseLayer);
	Gura_AssignFunction(__glutPostOverlayRedisplay);
	Gura_AssignFunction(__glutPostWindowOverlayRedisplay);
	Gura_AssignFunction(__glutShowOverlay);
	Gura_AssignFunction(__glutHideOverlay);
	Gura_AssignFunction(__glutCreateMenu);
	Gura_AssignFunction(__glutDestroyMenu);
	Gura_AssignFunction(__glutGetMenu);
	Gura_AssignFunction(__glutSetMenu);
	Gura_AssignFunction(__glutAddMenuEntry);
	Gura_AssignFunction(__glutAddSubMenu);
	Gura_AssignFunction(__glutChangeToMenuEntry);
	Gura_AssignFunction(__glutChangeToSubMenu);
	Gura_AssignFunction(__glutRemoveMenuItem);
	Gura_AssignFunction(__glutAttachMenu);
	Gura_AssignFunction(__glutDetachMenu);
	Gura_AssignFunction(__glutDisplayFunc);
	Gura_AssignFunction(__glutReshapeFunc);
	Gura_AssignFunction(__glutKeyboardFunc);
	Gura_AssignFunction(__glutMouseFunc);
	Gura_AssignFunction(__glutMotionFunc);
	Gura_AssignFunction(__glutPassiveMotionFunc);
	Gura_AssignFunction(__glutEntryFunc);
	Gura_AssignFunction(__glutVisibilityFunc);
	Gura_AssignFunction(__glutIdleFunc);
	Gura_AssignFunction(__glutTimerFunc);
	Gura_AssignFunction(__glutMenuStateFunc);
	Gura_AssignFunction(__glutSpecialFunc);
	Gura_AssignFunction(__glutSpaceballMotionFunc);
	Gura_AssignFunction(__glutSpaceballRotateFunc);
	Gura_AssignFunction(__glutSpaceballButtonFunc);
	Gura_AssignFunction(__glutButtonBoxFunc);
	Gura_AssignFunction(__glutDialsFunc);
	Gura_AssignFunction(__glutTabletMotionFunc);
	Gura_AssignFunction(__glutTabletButtonFunc);
	Gura_AssignFunction(__glutMenuStatusFunc);
	Gura_AssignFunction(__glutOverlayDisplayFunc);
	Gura_AssignFunction(__glutWindowStatusFunc);
	Gura_AssignFunction(__glutKeyboardUpFunc);
	Gura_AssignFunction(__glutSpecialUpFunc);
	Gura_AssignFunction(__glutJoystickFunc);
	Gura_AssignFunction(__glutSetColor);
	Gura_AssignFunction(__glutGetColor);
	Gura_AssignFunction(__glutCopyColormap);
	Gura_AssignFunction(__glutGet);
	Gura_AssignFunction(__glutDeviceGet);
	Gura_AssignFunction(__glutExtensionSupported);
	Gura_AssignFunction(__glutGetModifiers);
	Gura_AssignFunction(__glutLayerGet);
	Gura_AssignFunction(__glutGetProcAddress);
	Gura_AssignFunction(__glutBitmapCharacter);
	Gura_AssignFunction(__glutBitmapWidth);
	Gura_AssignFunction(__glutStrokeCharacter);
	Gura_AssignFunction(__glutStrokeWidth);
	Gura_AssignFunction(__glutBitmapLength);
	Gura_AssignFunction(__glutStrokeLength);
	Gura_AssignFunction(__glutWireSphere);
	Gura_AssignFunction(__glutSolidSphere);
	Gura_AssignFunction(__glutWireCone);
	Gura_AssignFunction(__glutSolidCone);
	Gura_AssignFunction(__glutWireCube);
	Gura_AssignFunction(__glutSolidCube);
	Gura_AssignFunction(__glutWireTorus);
	Gura_AssignFunction(__glutSolidTorus);
	Gura_AssignFunction(__glutWireDodecahedron);
	Gura_AssignFunction(__glutSolidDodecahedron);
	Gura_AssignFunction(__glutWireTeapot);
	Gura_AssignFunction(__glutSolidTeapot);
	Gura_AssignFunction(__glutWireOctahedron);
	Gura_AssignFunction(__glutSolidOctahedron);
	Gura_AssignFunction(__glutWireTetrahedron);
	Gura_AssignFunction(__glutSolidTetrahedron);
	Gura_AssignFunction(__glutWireIcosahedron);
	Gura_AssignFunction(__glutSolidIcosahedron);
	Gura_AssignFunction(__glutVideoResizeGet);
	Gura_AssignFunction(__glutSetupVideoResizing);
	Gura_AssignFunction(__glutStopVideoResizing);
	Gura_AssignFunction(__glutVideoResize);
	Gura_AssignFunction(__glutVideoPan);
	Gura_AssignFunction(__glutReportErrors);
	Gura_AssignFunction(__glutIgnoreKeyRepeat);
	Gura_AssignFunction(__glutSetKeyRepeat);
	Gura_AssignFunction(__glutForceJoystickFunc);
	Gura_AssignFunction(__glutGameModeString);
	Gura_AssignFunction(__glutEnterGameMode);
	Gura_AssignFunction(__glutLeaveGameMode);
	Gura_AssignFunction(__glutGameModeGet);
}

Gura_EndModuleScope(glut)
