//----------------------------------------------------------------------------
// wxTextOutputStream
//----------------------------------------------------------------------------
#ifndef __CLASS_WX_TEXTOUTPUTSTREAM_H__
#define __CLASS_WX_TEXTOUTPUTSTREAM_H__
#include <wx/txtstrm.h>

Gura_BeginModuleScope(wx)

//----------------------------------------------------------------------------
// Class declaration for wxTextOutputStream
//----------------------------------------------------------------------------
Gura_DeclareUserClass(wx_TextOutputStream);

//----------------------------------------------------------------------------
// Object declaration for wxTextOutputStream
//----------------------------------------------------------------------------
class Object_wx_TextOutputStream : public Object {
protected:
	wxTextOutputStream *_pEntity;
	GuraObjectObserver *_pObserver;
	bool _ownerFlag;
public:
	Gura_DeclareObjectAccessor(wx_TextOutputStream)
public:
	inline Object_wx_TextOutputStream(wxTextOutputStream *pEntity, GuraObjectObserver *pObserver, bool ownerFlag) :
				Object(Gura_UserClass(wx_AboutDialogInfo)),
				_pEntity(pEntity), _pObserver(pObserver), _ownerFlag(ownerFlag) {}
	inline Object_wx_TextOutputStream(Class *pClass, wxTextOutputStream *pEntity, GuraObjectObserver *pObserver, bool ownerFlag) :
				Object(pClass),
				_pEntity(pEntity), _pObserver(pObserver), _ownerFlag(ownerFlag) {}
	virtual ~Object_wx_TextOutputStream();
	virtual Object *Clone() const;
	virtual String ToString(bool exprFlag);
	inline void SetEntity(wxTextOutputStream *pEntity, GuraObjectObserver *pObserver, bool ownerFlag) {
		if (_ownerFlag) delete _pEntity;
		_pEntity = pEntity;
		_pObserver = pObserver;
		_ownerFlag = ownerFlag;
	}
	inline void InvalidateEntity() { _pEntity = nullptr, _pObserver = nullptr, _ownerFlag = false; }
	inline wxTextOutputStream *GetEntity() {
		return static_cast<wxTextOutputStream *>(_pEntity);
	}
	inline wxTextOutputStream *ReleaseEntity() {
		wxTextOutputStream *pEntity = GetEntity();
		InvalidateEntity();
		return pEntity;
	}
	inline void NotifyGuraObjectDeleted() {
		if (_pObserver != nullptr) _pObserver->GuraObjectDeleted();
	}
	inline bool IsInvalid(Environment &env) const {
		if (_pEntity != nullptr) return false;
		SetError_InvalidWxObject(env, "wxTextOutputStream");
		return true;
	}
};

Gura_EndModuleScope(wx)

#endif
