package HNS::Calendar::Table;
# $Id: Table.pm,v 1.12.2.1 2002/03/28 14:00:56 kenji Exp $
################################################################

=head1 NAME

HNS::Calendar::Table - class of calender with html table tag

=head1 SYNOPSIS

  my $cal = new HNS::Calendar::Table(year=>$y, month=>$m, col=>$col);
  print $cal->AsHTML;

=cut

################################################################

use strict;
use ObjectTemplate;
use vars qw(@ISA $TableBorder @WeekString $NextTemplate $PrevTemplate
	    $ThisTemplate $DayCurrentTemplate $DayNonCurrentTemplate);
@ISA = qw(ObjectTemplate);

attributes qw();

use Time::Local;
use DateTime::Date;
use HNS::Collection;
use HNS::Template;
use HNS::System;
use CGI::Tools;

################################################################
$TableBorder = 0;
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu',
        'Fri', '<font color="blue">Sat</font>');
$TableBorder = 0;
$NextTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">Next</a>);
$PrevTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">Prev</a>);
$ThisTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="$HNS::System::MyDiaryURI?%year%month%abc#%{ymd}0">%day</a>);

################################################################
sub AsHTML ($$$$)
{
    my ($self, $year, $month, $col) = @_;
    ($year, $month) = (sprintf("%04d", $year), sprintf("%02d", $month));
    my $html;
    my $templ = new HNS::Template;
    
    # table start
    $html .= qq(<table border="$TableBorder" summary="calendar">\n);
    # month
    my $date = new DateTime::Date(year=>$year, month=>$month, day=>1);
    $date -= '1M';
    $html .= "<tr>\n";
    # prev
    $html .= qq( <th colspan="2" align="left">);
    $html .= $templ->Expand($PrevTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $html .= "</th>\n";
    # this month
    $date += '1M';
    $html .= qq( <th colspan="3" align="center">);
    $html .= $templ->Expand($ThisTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $html .= "</th>\n";
    # next
    $date += '1M';
    $html .= qq( <th colspan="2" align="right">);
    $html .= $templ->Expand($NextTemplate,
			    {year=>$date->year,
			     month=>sprintf("%02d", $date->month)});
    $date -= '1M';
    $html .= "</th>\n";
    # week
    $html .= "</tr>\n<tr>\n";
    for (0..6){
	$html .= " <th align=\"center\">" .
#	    $DateTime::Date::WeekString{uc($WeekStringType)}->[$_] .
	    $WeekString[$_] .
		"</th>\n";
    }
    # day
    # null space
    my $start_week = $date->week;
    if ($start_week){
        $html .= "</tr>\n<tr>\n";
    }
    my $day = 1;
    for my $i (1..$start_week){
	$html .= " <td></td>";
    }
    $html .= "\n";
    # 1..31
    for $day (1..$date->DaysMonth){
	if (($day+$start_week)%7-1 == 0){
           $html .= qq(</tr>\n<tr>\n);
	}
	$html .= qq( <td align="right">);
	my $ymd = sprintf("%04d%02d%02d", $year, $month, $day);
	if ($col->diarys->{$ymd}){
	    my $high = int($day/10);
	    my $abc;
	    if ($day < 11) {
		$abc = "a";
	    }
	    elsif ($day < 21) {
		$abc = "b";
	    }
	    else {
		$abc = "c";
	    }
	    if ($col->diarys->{$ymd}->read_done){
#		$html .= sprintf($DayCurrentTemplate,
#				 $ENV{'REQUEST_URI'}, 
#				 $year, $month, $day, $day);
		# fix Cross Site Scripting bug
		my $ruri = CGI::Tools::Escape($ENV{'REQUEST_URI'});
		$html .= $templ->Expand($DayCurrentTemplate,
				{ruri=>$ruri, year=>$year,
				 month=>$month, day=>$day, ymd=>$ymd});
	    } else {
#		$html .= sprintf($DayNonCurrentTemplate,
#				 $year, $month, $high,
#				 $year, $month, $day, $day);
		$html .= $templ->Expand($DayNonCurrentTemplate,
				{year=>$year, month=>$month, high=>$high,
				 abc=>$abc, day=>$day, ymd=>$ymd});
	    }
	} else {
	    $html .= qq($day);
	}
	$html .= qq(</td>\n);
    }
    $html .= qq(</tr>\n</table>);
}
1;

