/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

/**
 * Config
 */
var Config =
{
	debug			: true,
	loopInterval	: 35,
	canvasName		: "canvas"
};

/**
 * Debug
 */
var Debug =
{
	str : "",
	/**
	 * 
	 */
	alert : function( message )
	{
		if ( Config.debug )
		{
			alert( message );
		}
	}
};

/**
 * SceneManager
 */
var SceneManager = function()
{
	this.current	= null;

	this.stack		= new Array();
	this.scenes		= new Array();
};

(function( pt )
{
	/**
	 * 
	 */
	pt.add = function( scene )
	{
		this.scenes[ scene.name ] = scene;
	};
	/**
	 * 
	 */
	pt.push = function( name )
	{
		var scene = this.scenes[ name ];
		if ( scene != null )
		{
			this.stack.push( scene );
			this.current = scene;
		}
	};
	/**
	 * 
	 */
	pt.pop = function()
	{
		if ( this.stack.length > 1 )
		{
			this.stack.pop();
			this.current = this.stack[ this.stack.length - 1 ];
		}
	};
	/**
	 * 
	 */
	pt.update = function()
	{
		this.current.update();
	};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		this.current.handleSysEvent( event );
	};
})( SceneManager.prototype );

/**
 * Application
 */
var Application = function()
{
	this.timerId		= 0;
	this.sceneManager	= new SceneManager();
};

(function( pt )
{
	/**
	 * 
	 */
	pt.loop = function()
	{
		try
		{
			this.sceneManager.update();
		}
		catch ( e )
		{
			clearInterval( this.timerId );
			Debug.alert( e );
		}
	};
	/**
	 * 
	 */
	pt.loadScript = function( url, func )
	{
		var node	= window.document.createElement("script");
		node.type	= "text/javascript";
		//node.language	= "javascript";
		node.charset= "UTF-8";
		node.src	= url;

		window.document.getElementsByTagName("body")[0].appendChild( node );

		if ( func != null )
		{
			node.onload				= func;
			node.onreadystatechange	= func;
		}
	};
	/**
	 * 
	 */
	pt.start = function()
	{
		var self = this;

		// set handler
		window.document.onkeydown	= function( e ) { self.sceneManager.handleSysEvent( e ); };
		window.document.onkeyup		= function( e ) { self.sceneManager.handleSysEvent( e ); };
		window.document.mousedown	= function( e ) { self.sceneManager.handleSysEvent( e ); };
		window.document.mouseup		= function( e ) { self.sceneManager.handleSysEvent( e ); };

		window.onload				= function()
		{
			try
			{
				self.sceneManager.current.show();
				self.timerId = setInterval( function() { self.loop(); }, Config.loopInterval );
			}
			catch ( e )
			{
				Debug.alert( e );
			}
		};
	};
})( Application.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }

window.h5glib.Config		= Config;
window.h5glib.Debug			= Debug;
window.h5glib.Application	= Application;


// Anonymous function end
//
})( window );
