/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


// Anonymous function start
//
(function( window, undefined )
{

var Config	= h5glib.Config;
var Debug	= h5glib.Debug;

var SCENE_NAME		= "menu";
var STAGE_SCENE_NAME= "stage";

/**
 * Process
 */
var Process = function()
{
	this.command	= null;
};

/**
 * MenuProcess
 */
var MenuProcess = function( scene )
{
	this.command	= scene.input;
};
MenuProcess.prototype = new Process();

(function( pt )
{
	/**
	 * 
	 */
	pt.update = function( scene )
	{
		var upd = false;

		return upd;
	};

	/**
	 * 
	 */
	pt.draw = function( scene, canvas, context )
	{
		context.save();

		context.fillStyle = "lightgray";
		context.fillRect( 0, 0, canvas.width, canvas.height );

		context.font		= "24px 'ＭＳ Ｐゴシック'";
		context.fillStyle	= "white";
		context.fillText( "Menu", 100, 100 );

		// debugString
		if ( this.debugString )
		{
			context.font		= "18px 'ＭＳ Ｐゴシック'";
			context.fillStyle	= "red";
			context.fillText( this.debugString, 4, 22 );
		}
		context.restore();
	};
})( MenuProcess.prototype );

/**
 * InputCommand
 */
var InputCommand = function()
{
	this.escape	= 0;
};

(function( pt )
{
	/**
	 * 
	 */
	pt.clear = function()
	{
		this.escape	= 0;
	}
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		var type = event.type.toLowerCase();
		if ( type.substring( 0, 3 ) == "key" )
		{
			var value = 0;
			if      ( type == "keydown" ) { value = 1; }
			else if ( type == "keyup"   ) { value = 0; }

			switch ( event.keyCode )
			{
				case 27:	this.escape	= value; break;	// ESC
			}
		}
	};
})( InputCommand.prototype );

/**
 * Scene
 */
var Scene = function( app )
{
	this.app		= app;
	this.name		= SCENE_NAME;

	this.canvas		= null;
	this.context	= null;

	this.input		= new InputCommand();
	this.menu		= new MenuProcess( this );
};

(function( pt )
{
	/**
	 * 
	 */
	pt.show = function()
	{
		this.input.clear();

		this.canvas		= window.document.getElementById( Config.canvasName );
		this.context	= this.canvas.getContext("2d");

		this.menu.draw( this, this.canvas, this.context );
	};
	/**
	 * 
	 */
	pt.update = function()
	{
		// change scene
		if ( this.input.escape )
		{
			this.app.sceneManager.push( STAGE_SCENE_NAME );
			this.app.sceneManager.current.show();
			return;
		}

		// update & draw
		if ( this.menu.update( this ) )
		{
			this.menu.draw( this, this.canvas, this.context );
		}
	};
	/**
	 * 
	 */
	pt.handleSysEvent = function( event )
	{
		this.input.handleSysEvent( event );
	};
})( Scene.prototype );


// Expose
if ( !window.h5glib ) { window.h5glib = {}; }
window.h5glib.MenuScene = Scene;


// Anonymous function end
//
})( window );
