/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

window.h5glib.loadDataCB(
{
	type : "stage",
	map :
	[
		[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1],
		[1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,2,0,2,2,2,2,2,2,2,2,0,2,2,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,1],
		[1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
	],

	actors :
	[
		{
			type : 0,
			name : "パンネロ",
			status : 1,
			x : 10.5, y : 8.5, z : 1, dir : Math.PI / 2,
			event : { type : "none" }
		},
		{
			type : 0,
			name : "猫A",
			status : 1,
			x : 7.5, y : 5.5, z : 1, dir : Math.PI * 3 / 2,
			event : { type : "text", text : "アーーーッ！！" }
		},
		{
			type : 0,
			name : "猫B",
			status : 1,
			x : 13.5, y : 5.5, z : 1, dir : Math.PI,
			event : { type : "text", text : "魚を船に乗せると船酔いする。" }
		},
		{
			type : 1,
			name : "マミタス",
			status : 0,
			x : 10.5, y : 5.5, z : 1, dir : Math.PI * 3 / 2,
			event : { type : "warp", baseUrl : "stage0/" }
		}
	],

	resource :
	{
		baseUrl			: "stage1/",
		wallImage		: new Image(),
		skyImage		: new Image(),
		floorImage		: new Image(),
		actorImages		: [],
		monsterImages	: [],
		gunImage		: new Image(),
		fireImage		: new Image(),
		shootSound		: new Audio(),
		noticeSound		: new Audio(),
		battleSound		: new Audio(),
		warpSound		: new Audio(),

		load : function()
		{
			this.wallImage.src		= this.baseUrl + "wall.png";
			this.skyImage.src		= this.baseUrl + "sky.jpg";
			this.floorImage.src		= this.baseUrl + "floor.png";

			for ( var i = 0; i < 2; i++ )
			{
				this.actorImages[i]			= new Image();
				this.actorImages[i].src		= this.baseUrl + "actor_t" + i + ".png";

				this.monsterImages[i]		= new Image();
				this.monsterImages[i].src	= this.baseUrl + "monster_t" + i + ".png";
			}

			this.gunImage.src		= this.baseUrl + "gun.png";
			this.fireImage.src		= this.baseUrl + "fire.png";

			this.shootSound.src		= this.baseUrl + "shoot.ogg";
			this.noticeSound.src	= this.baseUrl + "notice.ogg";
			this.battleSound.src	= this.baseUrl + "battle.ogg";
			this.warpSound.src		= this.baseUrl + "warp.ogg";
		}
	}
});
