package org.ydtmt.jsonitro;

/**
 * JSON階層情報格納クラス
 * エレメントとなるクラス、そのエレメント名
 * そしてエレメントの階層位置を格納する。
 *
 * @author yodatomato
 */
class JSONitroHierarchy {

    /**
     * 階層番号
     */
    private HierarchyLevel HierarchyNum;

    /**
     * 対象クラス
     */
    private Class<?> elementClass;

    /**
     * 対象クラスの要素名（JSONデータに記述されるもの）
     */
    private String elementName;

    /**
     * コンストラクタ
     * ３つのフィールドを一括で設定
     */
    protected JSONitroHierarchy(HierarchyLevel hierarchy, Class<?> elementClass, String elementName) {
        setHierarchyNum(hierarchy);
        setElementClass(elementClass);
        setElementName(elementName);
    }

    /**
     * hierarchyNumの取得メソッド
     * @return hierarchyNum
     */
    protected HierarchyLevel getHierarchyNum() {
        return HierarchyNum;
    }

    /**
     * hierarchyNumの設定メソッド
     * @param hierarchyNum セットする hierarchyNum
     */
    protected void setHierarchyNum(HierarchyLevel hierarchyNum) {
        HierarchyNum = hierarchyNum;
    }

    /**
     * targetClassの取得メソッド
     * @return targetClass
     */
    protected Class<?> getElementClass() {
        return this.elementClass;
    }

    /**
     * targetClassの設定メソッド
     * @param targetClass セットする targetClass
     */
    protected void setElementClass(Class<?> elementClass) {
        this.elementClass = elementClass;
    }

    /**
     * elementNameの取得メソッド
     * @return elementName
     */
    protected String getElementName() {
        return elementName;
    }

    /**
     * elementNameの設定メソッド
     * @param elementName セットする elementName
     */
    protected void setElementName(String elementName) {
        this.elementName = elementName;
    }
}
