package org.ydtmt.jsonitro;

import java.util.HashSet;

/**
 * 階層情報格納HashSet
 * @author yodatomato
 *
 */
public class JSONitroHierarchySet extends HashSet<JSONitroHierarchy> {

    /**
     * シリアルバージョンID
     */
    private static final long serialVersionUID = 399637364202999672L;

    /**
     * デフォルトのペアレントレベル
     */
    public static final String PARENT = "parent";

    /**
     * 階層情報の追加（新規作成⇒追加）
     * 同じオブジェクトが登録されている場合には追加できず
     * falseが返却される
     * @throws JSONitroException
     * @see java.util.HashSet.add
     */
    public boolean addHierarchy(HierarchyLevel hierarchy, Class<?> elementClass, String elementName) throws JSONitroException {
        if (hierarchy.equals(HierarchyLevel.LEVEL_0) && isHierarchyExist(HierarchyLevel.LEVEL_0)) {
            throw new JSONitroException(new IllegalArgumentException());
        }
        String tmp = elementName;
        if ("".equals(tmp) || tmp == null) {
            tmp = JSONitroHierarchySet.PARENT;
        }
        return this.add(new JSONitroHierarchy(hierarchy, elementClass, tmp));
    }

    /**
     * 階層情報の取得（階層番号とエレメント名から取得する）
     * @return JSONitroHierarchy
     */
    public JSONitroHierarchy getJSONitroHierarchy(HierarchyLevel hierarchy, String elementName) {
        for (JSONitroHierarchy tmp : this) {
            if (elementName.equals(tmp.getElementName()) && hierarchy == tmp.getHierarchyNum()) {
                return tmp;
            }
        }
        return null;
    }

    /**
     * 階層中に指定の階層レベルが存在するか検査する
     * @return true/false
     */
    public boolean isHierarchyExist(HierarchyLevel level) {
        for (JSONitroHierarchy tmp : this) {
            if (level == tmp.getHierarchyNum()) {
                return true;
            }
        }
        return false;
    }

    /**
     * LEVEL_0の階層のエレメント名を取得する
     * @return name of toplevel-element or null
     */
    public String getParentElementName() {
        for (JSONitroHierarchy tmp : this) {
            if (HierarchyLevel.LEVEL_0.equals(tmp.getHierarchyNum())) {
                return tmp.getElementName();
            }
        }
        return null;
    }
}
