/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: EngineEventHandler.hpp 22 2011-05-10 02:15:39Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_ENGINE_EVENT_HANDLER_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_ENGINE_EVENT_HANDLER_HPP_

namespace spcf {

	class Controller;

	class Context;

	class Recognition;

	class EngineEventHandler_i;

	class EngineEventHandler {
	private:
		EngineEventHandler_i* impl;

	public:
		EngineEventHandler();
		virtual ~EngineEventHandler();

	private:
		EngineEventHandler(const EngineEventHandler& handler);
		EngineEventHandler& operator=(const EngineEventHandler& handler);

	public:
		void setController(Controller& controller);
		Controller& getController();

	public:
		virtual void start(Context& context) = 0;
		virtual void soundStarted(Context& context) = 0;
		virtual void soundStoped(Context& context) = 0;
		virtual void recognized(Context& context, Recognition& recognition) = 0;
		virtual void stop(Context& context) = 0;
		virtual void finish(Context& context) = 0;
	};

}  // namespace spcf

#endif
