/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: GrammarCommonImpl.hpp 42 2011-05-16 07:07:20Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_GRAMMAR_GRAMMAR_COMMON_IMPL_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_GRAMMAR_GRAMMAR_COMMON_IMPL_HPP_

#include "spcf/core/Grammar.hpp"

namespace spcf {

	class GrammarCommonImpl_i;

	class GrammarCommonImpl : public Grammar {
	private:
		GrammarCommonImpl_i* impl;

	public:
		GrammarCommonImpl(const std::string& name);
		virtual ~GrammarCommonImpl();

	public:
		void addGrammarTransition(const GrammarTransitionPtr& transition);
		void addGrammarTransition(const std::string& phrase, const Grammar::State& startState, const Grammar::State& endState);
		void addGrammarTransition(const std::string& phrase, const std::string& propertyName, const Grammar::State& startState, const Grammar::State& endState);
		void addGrammarTransition(const std::string& phrase, const std::string& propertyName, int propertyInt, const Grammar::State& startState, const Grammar::State& endState);
		void addGrammarTransition(const std::string& phrase, const std::string& propertyName, const std::string& propertyString, const Grammar::State& startState, const Grammar::State& endState);
		void addGrammarTransition(const std::string& phrase, const std::string& propertyName, int propertyInt, const std::string& propertyString, const Grammar::State& startState, const Grammar::State& endState);

	public:
		std::string getName();
		GrammarTransitionList::const_iterator beginTransitions();
		GrammarTransitionList::const_iterator endTransitions();
	};

}  // namespace spcf

#endif
