#include <stdlib.h>
#include "xhardmeter.h"

static hardmeter_event_property_t escr_config_prop[] = {
  {"USR", PROP_BOOL, "When set, events are counted when the processor is operating at a current privilege level (CPL) of 1, 2, or 3. These privilege levels are generally used by application code and unprotected operating system code."},
  {"OS", PROP_BOOL, "When set, events are counted when the processor is operating at CPL of 0. This privilege level is generally reserved for protected operating system code."},
  {NULL, 0, NULL},
};

static hardmeter_event_property_t cccr_config_prop[] = {
  {"Enable", PROP_BOOL, "When set, enables counting; when clear, the counter is disabled. This flag is cleared on reset."},
  {"Compare", PROP_BOOL, "When set, enables filtering of the event count; when clear, disables filtering. The filtering method is selected with the threshold, complement, and edge flags."},
  {"Complement", PROP_BOOL, "Selects how the incoming event count is compared with the threshold value. When set, event counts that are less than or equal to the threshold value result in a single count being delivered to the performance counter; when clear, counts greater than the threshold value result in a count being delivered to the performance counter. The complement flag is not active unless the compare flag is set."},
  {"Threshold", PROP_THRESHOLD, "Selects the threshold value to be used for comparisons. The processor examines this field only when the compare flag is set, and uses the complement flag setting to determine the type of threshold comparison to be made. The useful range of values that can be entered in this field depend on the type of event being counted."},
  {"Edge", PROP_BOOL, "When set, enables rising edge (false-to-true) edge detection of the threshold comparison output for filtering event counts; when clear, rising edge detection is disabled. This flag is active only when the compare flag is set."},
  {"FORCE_OVF", PROP_BOOL, "When set, forces a counter overflow on every counter increment; when clear, overflow only occurs when the counter actually overflows."},
  {"OVF_PMI", PROP_BOOL, "When set, causes a performance monitor interrupt (PMI) to be generated when the counter overflows occurs; when clear, disables PMI generation. Note that the PMI is generated on the next event count after the counter has overflowed."},
  {"Cascade", PROP_BOOL, "When set, enables counting on one counter of a counter pair when its alternate counter in the other the counter pair in the same counter group overflows; when clear, disables cascading of counters."},
  {NULL,      0, NULL}
};

static hardmeter_event_property_t counter_config_prop[] = {
  {"Counter", PROP_COUNTER, NULL},
  {NULL,      0, NULL}
};

hardmeter_event_t hardmeter_registers[] = {
  {"ESCR", escr_config_prop, NULL, "Event Selection Control MSR"},
  {"CCCR", cccr_config_prop, NULL, "Counter Configuration Control MSR"},
  {"Counter", counter_config_prop, NULL, NULL},
  {NULL, NULL, NULL, NULL},
};

static hardmeter_event_property_t branch_retired_prop[] = {
  {"MMNP", PROP_BOOL, "Branch Not-taken Predicted"},
  {"MMNM", PROP_BOOL, "Branch Not-taken Mispredicted"},
  {"MMTP", PROP_BOOL, "Branch Taken Predicted"},
  {"MMTM", PROP_BOOL, "Branch Taken Mispredicted"},
  {NULL,   0, NULL}
};

static hardmeter_event_property_t mispred_branch_retired_prop[] = {
  {"NBOGUS", PROP_BOOL, "The retired instruction is not bogus"},
  {NULL,   0, NULL}
};

static hardmeter_event_property_t tc_deliver_mode_prop[] = {
  {"DD", PROP_BOOL, "Both logical processors are in deliver mode."},
  {"DB", PROP_BOOL, "Logical processor 0 is in deliver mode and logical processor 1 is in build mode."},
  {"DI", PROP_BOOL, "Logical processor 0 is in deliver mode and logical processor 1 is either halted, under a machine clear condition or transitioning to a long microcode flow."},
  {"BD", PROP_BOOL, "Logical processor 0 is in build mode and logical processor 1 is in deliver mode."},
  {"BB", PROP_BOOL, "Both logical processors are in build mode."},
  {"BI", PROP_BOOL,   "Logical processor 0 is in build mode and logical processor 1 is either halted, under a machine clear condition or transitioning to a long microcode flow."},
  {"ID", PROP_BOOL, "Logical processor 0 is either halted, under a machine clear condition or transitioning to a long microcode flow. Logical processor 1 is in deliver mode."},
  {"IB", PROP_BOOL, "Logical processor 0 is either halted, under a machine clear condition or transitioning to a long microcode flow. Logical processor 1 is in build mode. "},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t bpu_fetch_request_prop[] = {
  {"TCMISS",  PROP_BOOL, "Trace cache lookup miss."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t itlb_reference_prop[] = {
  {"HIT",     PROP_BOOL, "ITLB hit."},
  {"MISS",    PROP_BOOL, "ITLB miss."},
  {"HIT_UC",  PROP_BOOL, "Uncacheable ITLB hit."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t memory_cancel_prop[] = {
  {"ST_RB_FULL",     PROP_BOOL, "Replayed because no store request buffer is available."},
  {"64K_CONF",       PROP_BOOL, "Conflicts due to 64K aliasing."},
  {"all_cache_miss", PROP_BOOL, "?? brink has this entry, but Intel's manual doesn't describe it."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t memory_complete_prop[] = {
  {"LSC",           PROP_BOOL, "Load split completed, excluding UC/WC loads"},
  {"SSC",           PROP_BOOL, "Any split stores completed"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t load_port_replay_prop[] = {
  {"SPLIT_LD",      PROP_BOOL, "Split load."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t store_port_replay_prop[] = {
  {"SPLIT_ST",      PROP_BOOL, "Split store."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t mob_load_replay_prop[] = {
  {"NO_STA",        PROP_BOOL, "Replayed because of unknown store address,"},
  {"NO_STD",        PROP_BOOL, "Replayed because of unknown store data,"},
  {"PARTIAL_DATA",  PROP_BOOL, "Replayed because of partially overlapped data access between the load and store operations,"},
  {"UNALGN_ADDR",   PROP_BOOL, "Replayed because the lower 4 bits of the linear address do not match between the load and store operations."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t page_walk_type_prop[] = {
  {"DTMISS",        PROP_BOOL, "Page walk for a data TLB miss (either load or store)."},
  {"ITMISS",        PROP_BOOL, "Page walk for an instruction TLB miss."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t bsq_cache_reference_prop[] = {
  {"RD_2ndL_HITS",  PROP_BOOL, "Read 2nd level cache hit Shared (includes load and RFO)"},
  {"RD_2ndL_HITE",  PROP_BOOL, "Read 2nd level cache hit Exclusive (includes load and RFO)"},
  {"RD_2ndL_HITM",  PROP_BOOL, "Read 2nd level cache hit Modified (includes load and RFO)"},
  {"RD_3ndL_HITS",  PROP_BOOL, "Read 3rd level cache hit Shared (includes load and RFO)"},
  {"RD_3ndL_HITE",  PROP_BOOL, "Read 3rd level cache hit Exclusive (includes load and RFO)"},
  {"RD_3ndL_HITM",  PROP_BOOL, "Read 3rd level cache hit Modified (includes load and RFO)"},
  {"RD_2ndL_MISS",  PROP_BOOL, "Read 2nd level cache miss (includes load and RFO)"},
  {"RD_3ndL_MISS",  PROP_BOOL, "Read 3rd level cache miss (includes load and RFO)"},
  {"wr_2ndL_MISS",  PROP_BOOL, "A Writeback lookup from DAC misses the 2nd level cache (unlikely to happen) "},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t ioq_allocation_prop[] = {
  {"Bit 0-4 (single field)", PROP_IOQ, "Bus request type (use 00001 for invalid or default)"},
  {"ALL_READ",      PROP_BOOL, "Count read entries"},
  {"ALL_WRITE",     PROP_BOOL, "Count write entries"},
  {"MEM_UC",        PROP_BOOL, "Count UC memory access entries"},
  {"MEM_WC",        PROP_BOOL, "Count WC memory access entries"},
  {"MEM_WT",        PROP_BOOL, "Count write-through (WT) memory access entries"},
  {"MEM_WP",        PROP_BOOL, "Count write-protected (WP) memory access entries"},
  {"MEM_WB",        PROP_BOOL, "Count WB memory access entries"},
  {"OWN",           PROP_BOOL, "Count all store requests driven by processor, as opposed to other processor or DMA"},
  {"OTHER",         PROP_BOOL, "Count all requests driven by other processors or DMA"},
  {"PREFETCH",      PROP_BOOL, "Include HW and SW prefetch requests in the count"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t ioq_active_entries_prop[] = {
  {"Bit 0-4 (single field)", PROP_IOQ, "Bus request type (use 00001 for invalid or default)"},
  {"ALL_READ",      PROP_BOOL, "Count read entries"},
  {"ALL_WRITE",     PROP_BOOL, "Count write entries"},
  {"MEM_UC",        PROP_BOOL, "Count UC memory access entries"},
  {"MEM_WC",        PROP_BOOL, "Count WC memory access entries"},
  {"MEM_WT",        PROP_BOOL, "Count write-through (WT) memory access entries (abyss dones't have this entry.)"},
  {"MEM_WP",        PROP_BOOL, "Count write-protected (WP) memory access entries (abyss dones't have this entry.)"},
  {"MEM_WB",        PROP_BOOL, "Count WB memory access entries"},
  {"OWN",           PROP_BOOL, "Count all store requests driven by processor, as opposed to other processor or DMA"},
  {"OTHER",         PROP_BOOL, "Count all requests driven by other processors or DMA"},
  {"PREFETCH",      PROP_BOOL, "Include HW and SW prefetch requests in the count"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t fsb_data_activity_prop[] = {
  {"DRDY_DRV",      PROP_BOOL, "Count when this processor drives data onto the bus - includes writes and implicit writebacks. Asserted two processor clock cycles for partial writes and 4 processor clocks (usually in consecutive bus clocks) for full line writes. "},
  {"DRDY_OWN",      PROP_BOOL, "Count when this processor reads data from the bus - includes loads and some PIC transactions. Asserted two processor clock cycles for partial reads and 4 processor clocks (usually in consecutive bus clocks) for full line reads. Count DRDY event that we drive. Count DRDY event sampled that we own."},
  {"DRDY_OTHER",    PROP_BOOL, "Count when data is on the bus but not being sampled by the processor. It may or may not be being driven by this processor. Asserted two processor clock cycles for partial transactions and 4 processor clocks (usually in consecutive bus clocks) for full line transactions. "},
  {"DBSY_DRV",      PROP_BOOL, "Count when this processor reserves the bus for use in the next bus cycle in order to drive data. Asserted for two processor clock cycles for full line writes and not at all for partial line writes. May be asserted multiple times (in consecutive bus clocks) if we stall the bus waiting for a cache lock to complete."},
  {"DBSY_OWN",      PROP_BOOL, "Count when some agent reserves the bus for use in the next bus cycle to drive data that this processor will sample. Asserted for two processor clock cycles for full line writes and not at all for partial line writes. May be asserted multiple times (all one bus clock apart) if we stall the bus for some reason. "},
  {"DBSY_OTHER",    PROP_BOOL, "Count when some agent reserves the bus for use in the next bus cycle to drive data that this processor will NOT sample. It may or may not be being driven by this processor. Asserted two processor clock cycles for partial transactions and 4 processor clocks (usually in consecutive bus clocks) for full line transactions. "},
  {NULL, 0, NULL}
};


static hardmeter_event_property_t bsq_allocation_prop[] = {
  {"REQ_TYPE0",     PROP_BOOL, "Request type encoding (req_type0 and req_type1) are: 0 - Read (excludes read invalidate). 1- Read invalidate. 2 - Write (other than writebacks). 3- Writeback (evicted from cache). (public)"},
  {"REQ_TYPE1",     PROP_BOOL, "Request type encoding (req_type0 and req_type1) are: 0 - Read (excludes read invalidate). 1- Read invalidate. 2 - Write (other than writebacks). 3- Writeback (evicted from cache). (public)"},
  {"REQ_LEN0",      PROP_BOOL, "Request length encoding (req_len0, req_len1) are: 0 - 0 chunks, 1 - 1 chunk, 3 - 8 chunks."},
  {"REQ_LEN1",      PROP_BOOL, "Request length encoding (req_len0, req_len1) are: 0 - 0 chunks, 1 - 1 chunk, 3 - 8 chunks."},
  {"REQ_IO_TYPE",   PROP_BOOL, "Request type is input or output."},
  {"REQ_LOCK_TYPE", PROP_BOOL, "Request type is bus lock."},
  {"REQ_CACHE_TYPE",PROP_BOOL, "Request type is cacheable"},
  {"REQ_SPLIT_TYPE",PROP_BOOL, "Request type is a bus 8-byte chunk split across 8-byte boundary."},
  {"REQ_DEM_TYPE",  PROP_BOOL, "Request type is a demand if set Request type is HW.SW prefetch if 0."},
  {"REQ_ORD_TYPE",  PROP_BOOL, "Request is an ordered type."},
  {"MEM_TYPE0",     PROP_BOOL, "Memory type encoding (mem_type0 - mem_type2) are: 0 - UC, 1 - USWC, 4 - WT, 5 - WP, 6 - WB"},
  {"MEM_TYPE1",     PROP_BOOL, "Memory type encoding (mem_type0 - mem_type2) are: 0 - UC, 1 - USWC, 4 - WT, 5 - WP, 6 - WB"},
  {"MEM_TYPE2",     PROP_BOOL, "Memory type encoding (mem_type0 - mem_type2) are: 0 - UC, 1 - USWC, 4 - WT, 5 - WP, 6 - WB"},
  {NULL, 0, NULL}
};

#define bsq_active_entries_prop bsq_allocation_prop

static hardmeter_event_property_t x87_assist_prop[] = {
  {"FPSU",          PROP_BOOL, "Handle FP stack underflow"},
  {"FPSO",          PROP_BOOL, "Handle FP stack overflow"},
  {"POAO",          PROP_BOOL, "Handle x87 output overflow"},
  {"POAU",          PROP_BOOL, "Handle x87 output underflow"},
  {"PREA",          PROP_BOOL, "Handle x87 input assist"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t sse_input_assist_prop[] = {
  {"ALL",           PROP_BOOL, "Count assists for all SSE and SSE2 uops"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t packed_sp_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all uops operating on packed single-precision operands"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t packed_dp_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all uops operating on packed double-precision operands"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t scalar_sp_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all uops operating on scalar single-precision operands"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t scalar_dp_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all uops operating on scalar double-precision operands."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t mmx_64bit_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all uops operating on 64 bit SIMD integer operands in memory or MMX registers."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t mmx_128bit_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all uops operating on 128 bit SIMD integer operands in memory or XMM registers."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t x87_fp_uop_prop[] = {
  {"ALL",           PROP_BOOL, "Count all x87 FP uops."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t x87_simd_moves_uop_prop[] = {
  {"ALLP0",         PROP_BOOL, "Count all x87/SIMD store/moves uops."},
  {"ALLP2",         PROP_BOOL, "Count all x87/SIMD load uops."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t machine_clear_prop[] = {
  {"CLEAR",         PROP_BOOL, "Counts for a portion of the many cycles while the machine is cleared for any cause. Use Edge triggering for this bit only to get a count of occurrence versus a duration."},
  {"MOCLEAR",       PROP_BOOL, "Increments each time the machine is cleared due to memory ordering issues."},
  {"SMCLEAR",       PROP_BOOL, "Increments each time the machine is cleared due to self-modifying code issues. (quote from brink's comment: the 03/2002 manual lists this as bit 12, but I think it should be bit 15)"},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t global_power_events_prop[] = {
  {"Running",       PROP_BOOL, "The processor is active (includes the handling of HLT STPCLK and throttling)."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t tc_ms_xfer_prop[] = {
  {"CISC",          PROP_BOOL, "A TC to MS transfer occurred."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t uop_queue_writes_prop[] = {
  {"FROM_TC_BUILD", PROP_BOOL, "The uops being written are from TC build mode."},
  {"FROM_TC_DELIVER",PROP_BOOL, "The uops being written are from TC deliver mode."},
  {"FROM_ROM",      PROP_BOOL, "The uops being written are from microcode ROM."},
  {NULL, 0, NULL}
};

hardmeter_event_t hardmeter_event_non_retirement[] = {
  {"branch_retired", branch_retired_prop, NULL,
   "This event counts the retirement of a "
   "branch. Specify one or more mask "
   "bits to select any combination of "
   "taken, not-taken, predicted and "
   "mispredicted."},
  {"mispred_branch_retired", mispred_branch_retired_prop, NULL,
   "This event represents the retirement "
   "of mispredicted IA-32 branch "
   "instructions."},
  {"TC_deliver_mode", tc_deliver_mode_prop, NULL,
   "This event counts the duration (in "
   "clock cycles) of the operating modes "
   "of the trace cache and decode "
   "engine in the processor package. "
   "The mode is specified by one or "
   "more of the event mask bits."},
  {"BPU_fetch_request", bpu_fetch_request_prop, NULL,
   "This event counts instruction fetch "
   "requests of specified request type by "
   "the Branch Prediction unit. Specify "
   "one or more mask bits to qualify the "
   "request type(s)."},
  {"ITLB_reference", itlb_reference_prop, NULL,
   "This event counts translations using "
   "the Instruction Translation Lookaside "
   "Buffer (ITLB). "},
  {"memory_cancel", memory_cancel_prop, NULL,
   "This event counts the canceling of "
   "various type of request in the Data "
   "cache Address Control unit (DAC). "
   "Specify one or more mask bits to "
   "select the type of requests that are "
   "canceled."},
  {"memory_complete", memory_complete_prop, NULL,
   "This event counts the completion of "
   "a load split, store split, uncacheable "
   "(UC) split, or UC load. Specify one "
   "or more mask bits to select the "
   "operations to be counted."},
  {"load_port_replay", load_port_replay_prop, NULL,
   "This event counts replayed events at "
   "the load port. Specify one or more "
   "mask bits to select the cause of the "
   "replay."},
  {"store_port_replay", store_port_replay_prop, NULL,
   "This event counts replayed events at "
   "the store port. Specify one or more "
   "mask bits to select the cause of the "
   "replay."},
  {"MOB_load_replay", mob_load_replay_prop, NULL,
   "This event triggers if the memory "
   "order buffer (MOB) caused a load "
   "operation to be replayed. Specify "
   "one or more mask bits to select the "
   "cause of the replay."},
  {"page_walk_type", page_walk_type_prop, NULL,
   "This event counts various types of "
   "page walks that the page miss "
   "handler (PMH) performs."},
  {"BSQ_cache_reference", bsq_cache_reference_prop, NULL,
   "This event counts cache references "
   "(2nd level cache or 3rd level cache) "
   "as seen by the bus unit. Specify one "
   "or more mask bit to select an access "
   "according to the access type (read "
   "type includes both load and RFO, "
   "write type includes writebacks and "
   "evictions) and the access result (hit, "
   "misses)"},
  {"IOQ_allocation", ioq_allocation_prop, NULL,
   "This event counts the various types "
   "of transactions on the bus. A count is "
   "generated each time a transaction is "
   "allocated into the IOQ that matches "
   "the specified mask bits. An allocated "
   "entry can be a sector (64 bytes) or a "
   "chunks of 8 bytes. Note that "
   "requests are counted once per retry. "
   "The event mask bits constitute 4 bit "
   "fields. A transaction type is specified "
   "by interpreting the values of each bit "
   "field. Specify one or more event "
   "mask bits in a bit field to select the "
   "value of the bit field. Each field (bits "
   "0-4 are one field) are independent of "
   "and can be ORed with the others. "
   "The request type field is further "
   "combined with bit 5 and 6 to form a "
   "binary expression. Bits 7 and 8 form "
   "a bit field to specify the memory type "
   "of the target address. Bits 13 and 14 "
   "form a.bit field to specify the source "
   "agent of the request. Bit 15 affects "
   "read operation only. The event is "
   "triggered by evaluating the logical "
   "expression: (((Request type) OR Bit "
   "5 OR Bit 6) OR (Memory type)) AND "
   "(Source agent)."},
  {"IOQ_active_entries", ioq_active_entries_prop, NULL,
   "This event counts the number of "
   "entries (clipped at 15) in the IOQ that "
   "are active. An allocated entry can be "
   "a sector (64 bytes) or a chunks of 8 "
   "bytes. This event must be "
   "programmed in conjunction with "
   "IOQ_allocation. Specify one or more "
   "event mask bits to select the "
   "transactions that is counted."},
  {"FSB_data_activity", fsb_data_activity_prop, NULL,
   "This event increments once for each "
   "DRDY or DBSY event that occurs on "
   "the front side bus. The event allows "
   "selection of a specific DRDY or "
   "DBSY event."},
  {"BSQ_allocation", bsq_allocation_prop, NULL,
   "This event counts allocations in the "
   "Bus Sequence Unit (BSQ) according "
   "to the specified mask bit encoding. "
   "The event mask bits consist of four "
   "sub-groups: Request type, Request "
   "length, Memory type, and a sub-"
   "group consisting mostly of "
   "independent bits (bits 5, 6, 7, 8, 9, "
   "and 10). Specify an encoding for "
   "each sub-group."},
  {"BSQ_active_entries", bsq_active_entries_prop, NULL,
   "This event represents the number of "
   "BSQ entries (clipped at 15) currently "
   "active (valid) which meet the "
   "subevent mask criteria during "
   "allocation in the BSQ. Active request "
   "entries are allocated on the BSQ "
   "until de-allocated. De-allocation of "
   "an entry does not necessarily imply "
   "the request is filled. This event must "
   "be programmed in conjunction with "
   "BSQ_allocation. Specify one or "
   "more event mask bits to select the "
   "transactions that is counted."},
  {"x87_assist", x87_assist_prop, NULL,
   "This event counts the retirement of "
   "x87 instructions that required special "
   "handling. Specifies one or more "
   "event mask bits to select the type of "
   "assistance."},
  {"SSE_input_assist", sse_input_assist_prop, NULL,
   "This event counts the number of "
   "times an assist is requested to "
   "handle problems with input operands "
   "for SSE and SSE2 operations, most "
   "notably denormal source operands "
   "when the DAZ bit is not set. Set bit "
   "15 of the event mask to use this "
   "event."},
  {"packed_SP_uop", packed_sp_uop_prop, NULL,
   "This event increments for each "
   "packed single-precision uop, "
   "specified through the event mask for "
   "detection."},
  {"packed_DP_uop", packed_dp_uop_prop, NULL,
   "This event increments for each "
   "packed double-precision uop, "
   "specified through the event mask for "
   "detection."},
  {"scalar_SP_uop", scalar_sp_uop_prop, NULL,
   "This event increments for each "
   "scalar single-precision uop, "
   "specified through the event mask for "
   "detection."},
  {"scalar_DP_uop", scalar_dp_uop_prop, NULL,
   "This event increments for each "
   "scalar double-precision uop, "
   "specified through the event mask for "
   "detection."},
  {"64bit_MMX_uop", mmx_64bit_uop_prop, NULL,
   "This event increments for each MMX "
   "instruction, which operate on 64 bit "
   "SIMD operands."},
  {"128bit_MMX_uop", mmx_128bit_uop_prop, NULL,
   "This event increments for each "
   "integer SIMD SSE2 instructions, "
   "which operate on 128 bit SIMD "
   "operands."},
  {"x87_FP_uop", x87_fp_uop_prop, NULL,
   "This event increments for each x87 "
   "floating-point uop, specified through "
   "the event mask for detection."},
  {"x87_SIMD_moves_uop", x87_simd_moves_uop_prop, NULL,
   "This event increments for each x87 "
   "FPU, MMX, SSE or SSE2 uop "
   "related to load data, store data, or "
   "register-to-register moves, and is "
   "specified through the event mask for "
   "detection. These uops are "
   "dispatched to port 0 or port 2 at "
   "runtime."},
  {"machine_clear", machine_clear_prop, NULL,
   "This event increments according to "
   "the mask bit specified while the "
   "entire pipeline of the machine is "
   "cleared. Specify one of the mask bit "
   "to select the cause."},
  {"global_power_events", global_power_events_prop, NULL,
   "This event accumulates the time "
   "during which a processor is not "
   "stopped."},
  {"tc_ms_xfer", tc_ms_xfer_prop, NULL,
   "This event counts the number of "
   "times that uop delivery changed "
   "from TC to MS ROM."},
  {"uop_queue_writes", uop_queue_writes_prop, NULL,
   "This event counts the number of "
   "valid uops written to the uop queue. "
   "Specify one or more mask bits to "
   "select the source type of writes."},
  {NULL, NULL, NULL, NULL}
};

static hardmeter_event_property_t front_end_event_prop[] = {
  {"NBOGUS",    PROP_BOOL, "The marked uops are not bogus."},
  {"BOGUS",     PROP_BOOL, "The marked ops are bogus."},
  {NULL, 0, NULL}
};

static hardmeter_event_property_t execution_event_prop[] = {
  {"NONBOGUS0", PROP_BOOL, "The marked uops are not bogus."},
  {"NONBOGUS1", PROP_BOOL, "The marked uops are not bogus."},
  {"NONBOGUS2", PROP_BOOL, "The marked uops are not bogus."},
  {"NONBOGUS3", PROP_BOOL, "The marked uops are not bogus."},
  {"BOGUS0",    PROP_BOOL, "The marked uops are bogus."},
  {"BOGUS1",    PROP_BOOL, "The marked uops are bogus."},
  {"BOGUS2",    PROP_BOOL, "The marked uops are bogus."},
  {"BOGUS3",    PROP_BOOL, "The marked uops are bogus."},
  {NULL,        0, NULL}
};

static hardmeter_event_property_t replay_event_prop[] = {
  {"NBOGUS",    PROP_BOOL, "The marked uops are not bogus."},
  {"BOGUS",     PROP_BOOL, "The marked uops are bogus."},
  {NULL,        0, NULL}
};

static hardmeter_event_property_t instr_retired_prop[] = {
  {"NBOGUSNTAG", PROP_BOOL, "Non-bogus instructions that are not tagged."},
  {"NBOGUSTAG",  PROP_BOOL, "Non-bogus instructions that are tagged."},
  {"BOGUSNTAG",  PROP_BOOL, "Bogus instructions that are not tagged."},
  {"BOGUSTAG",   PROP_BOOL, "Bogus instructions that are tagged."},
  {NULL,         0, NULL}
};

static hardmeter_event_property_t uops_retired_prop[] = {
  {"NBOGUS",    PROP_BOOL, "The uop is a load operation."},
  {"BOGUS",     PROP_BOOL, "The uop is a store operation."},
  {NULL,        0, NULL}
};

static hardmeter_event_property_t uop_type_prop[] = {
  {"TAGLOADS",  PROP_BOOL, "The uop is a load operation."},
  {"TAGSTORES", PROP_BOOL, "The uop is a store operation."},
  {NULL,        0, NULL}
};

static hardmeter_event_property_t retired_mispred_branch_type_prop[] = {
  {"CONDITIONAL", PROP_BOOL, "Conditional jumps."},
  {"CALL",        PROP_BOOL, "Indirect call branches."},
  {"RETURN",      PROP_BOOL, "Return branches."},
  {"INDIRECT",    PROP_BOOL, "Returns, indirect calls, or indirect jumps."},
  {NULL,          0, NULL}
};

static hardmeter_event_property_t retired_branch_type_prop[] = {
  {"CONDITIONAL", PROP_BOOL, "Conditional jumps."},
  {"CALL",        PROP_BOOL, "Direct or indirect calls."},
  {"RETURN",      PROP_BOOL, "Return branches."},
  {"INDIRECT",    PROP_BOOL, "Returns, indirect calls, or indirect jumps."},
  {NULL,          0, NULL}
};

hardmeter_event_t hardmeter_event_at_retirement[] = {
  {"instr_retired", instr_retired_prop, NULL,
   "1: This event counts instructions "
   "that are retired during a clock "
   "cycle. Mask bits specify bogus or "
   "non-bogus (and whether they are "
   "tagged via the front-end tagging "
   "mechanism. "
   "2: The event count may vary "
   "depending on the "
   "microarchitecture state of the "
   "processor when the event is "
   "enabled. "
   "3: The event may count more than "
   "once for some IA-32 instructions "
   "with complex uop flows and were "
   "interrupted before retirement. "},
  {"uops_retired", uops_retired_prop, NULL,
   "This event counts uops that are "
   "retired during a clock cycle."},
  {"uop_type", uop_type_prop, NULL,
  "This event is used in conjunction "
   "with the front-end at-retirement "
   "mechanism to tag load and store "
   "uops."},
  {"retired_mispred_branch_type", retired_mispred_branch_type_prop, NULL,
   "This event counts retiring "
   "mispredicted branches by type."},
  {"retired_branch_type", retired_branch_type_prop, NULL,
   "This event counts retiring branches "
   "by type. Specify one or more mask "
   "bits to qualify the branch by its type."},
  {NULL, NULL, NULL, NULL}
};

static hardmeter_event_t front_end_event = 
  {"front_end_event", front_end_event_prop, NULL,
   "This event counts the retirement of "
   "tagged uops, which are specified "
   "through the front-end tagging "
   "mechanism. The event mask "
   "specifies bogus or non-bogus uops."};
static hardmeter_event_t execution_event = 
  {"execution_event", execution_event_prop, NULL,
   "This event counts the retirement of "
   "tagged uops, which are specified "
   "through the front-end tagging "
   "mechanism. The event mask "
   "specifies bogus or non-bogus uops."};
static hardmeter_event_t replay_event = 
  {"replay_event", replay_event_prop, NULL,
   "This event counts the retirement of "
   "tagged uops, which are specified "
   "through the replay tagging "
   "mechanism. The event mask "
   "specifies bogus or non-bogus uops."};

hardmeter_event_t hardmeter_event_tagging[] = {
  {"memory_loads", NULL, &front_end_event, NULL},
  {"memory_stores", NULL, &front_end_event, NULL},
  {"memory_loads & memory_stores", NULL, &front_end_event, NULL},
  {"packed_SP_retired", NULL, &execution_event, NULL},
  {"packed_DP_retired", NULL, &execution_event, NULL},
  {"scalar_SP_retired", NULL, &execution_event, NULL},
  {"scalar_DP_retired", NULL, &execution_event, NULL},
  {"128_bit_MMX_retired", NULL, &execution_event, NULL},
  {"64_bit_MMX_retired", NULL, &execution_event, NULL},
  {"x87_FP_retired", NULL, &execution_event, NULL},
  {"x87_SIMD_moves_retired", NULL, &execution_event, NULL},
  {"1stL_cache_load_miss_retired", NULL, &replay_event, NULL},
  {"2ndL_cache_load_miss_retired", NULL, &replay_event, "quote from brink's comment: I have not been able to get counts that make sense from ld_miss_2L_retired yet."},
  {"DTLB_load_miss_retired", NULL, &replay_event, NULL},
  {"DTLB_store_miss_retired", NULL, &replay_event, NULL},
  {"DTLB_all_miss_retired", NULL, &replay_event, NULL},
  {"MOB_load_replay_retired", NULL, &replay_event, NULL},
  {"split_ld_retired", NULL, &replay_event, "quote from brink's comment: I have not been able to get counts that make sense from split_ld_retired yet."},
  {"split_st_retired", NULL, &replay_event, "quote from brink's comment: I have not been able to get counts that make sense from split_st_retired yet."},
  {NULL, NULL, NULL, NULL}
};
