/* $Id: mediator.c,v 1.5 2002/12/17 08:09:51 tkubo Exp $ */

/* mediator.c - mediate one module and another.
 *
 * Copyright (C) 2002 Hardmeter Project <http://hardmeter.sourceforge.jp>
 *
 * This project is supported by IPA(Information-technology Promotion
 * Agency, Japan).
 *
 * "xhardmeter" is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <stdarg.h>
#include "xhardmeter.h"

static int null_function(void)
{
     return 0;
}

static hardmeter_source_t empty_source = {
  (void *)null_function, /* start */
  (void *)null_function, /* end */
  (void *)null_function, /* program */
  (void *)null_function, /* default_flag */
  (void *)null_function, /* experiment_start */
  (void *)null_function, /* experiment_end */
  (void *)null_function, /* event_start */
  (void *)null_function, /* event_end */
  (void *)null_function, /* flag */
  (void *)null_function, /* error_cleanup */
};

hardmeter_source_t *hardmeter_empty_source = &empty_source;

int hardmeter_build(hardmeter_source_t *source,
		    void *source_data,
		    hardmeter_builder_t *builder,
		    void *build_data)
{
  void *source_top_data;
  void *source_experiment_data;
  void *source_event_data;
  void *builder_top_data;
  void *builder_experiment_data;
  void *builder_event_data;
  int source_initialized = 0;
  int builder_initialized = 0;
  char *s1, *s2;
  guint64 u64;
  hardmeter_event_t *base;
  hardmeter_ebs_t ebs;
  int rc;

  rc = source->start(&source_top_data, source_data);
  if (rc != 0)
    goto cleanup;
  source_initialized = 1;
  rc = builder->start(&builder_top_data, build_data);
  if (rc != 0)
    goto cleanup;
  builder_initialized = 1;
  while (source->program(source_top_data, &s1, &s2)) {
    builder->program(builder_top_data, s1, s2);
  }
  while (source->default_flag(source_top_data, &s1, &u64)) {
    builder->default_flag(builder_top_data, s1, u64);
  }
  while (source->experiment_start(&source_experiment_data, source_top_data, &s1)) {
    builder->experiment_start(&builder_experiment_data, builder_top_data, s1);
    while (source->event_start(&source_event_data, source_experiment_data, &s1, &base, &ebs)) {
      builder->event_start(&builder_event_data, builder_experiment_data, s1, base, &ebs);
      while (source->flag(source_event_data, &s1, &u64)) {
	builder->flag(builder_event_data, s1, u64);
      }
      source->event_end(source_event_data);
      builder->event_end(builder_event_data);
    }
    source->experiment_end(source_experiment_data);
    builder->experiment_end(builder_experiment_data);
  }
  source->end(source_top_data);
  builder->end(builder_top_data);
  return 0;
 cleanup:
  if (source_initialized)
    source->error_cleanup(source_top_data);
  if (builder_initialized)
    builder->error_cleanup(builder_top_data);
  return rc;
}

int hardmeter_error(const char *format, ...)
{
  va_list ap;

  va_start(ap, format);
  vfprintf(stderr, format, ap); /* FIXME later */
  va_end(ap);
  fputc('\n', stderr);
  return 0;
}
