/* $Id: xutil.c,v 1.6 2002/12/17 08:09:51 tkubo Exp $ */

/* xutil.c - Gtk utilities for xhardmeter.
 *
 * Copyright (C) 2002 Hardmeter Project <http://hardmeter.sourceforge.jp>
 *
 * This project is supported by IPA(Information-technology Promotion
 * Agency, Japan).
 *
 * "xhardmeter" is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "xhardmeter.h"

/* prototypes */
static void ok_cb(GtkWidget *widget, int *rc);

/* implements */
static void ok_cb(GtkWidget *widget, int *rc)
{
  *rc = 0;
  gtk_main_quit();
}

/* exported functions */
/* don't free returned value. */
/* return value is valid until next call. */
const char *xhardmeter_xfileselection(GtkWindow *window)
{
  static GtkWidget *filesel = NULL;
  static int rc = -1;
  const char *rv = NULL;

  if (filesel == NULL) {
    /* prepare file dialog */
    filesel = gtk_file_selection_new("Program to run");
    gtk_window_set_modal(GTK_WINDOW(filesel), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(filesel), window);
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(filesel));

    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button), "clicked",
		       ok_cb, &rc);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button), "clicked",
		       gtk_main_quit, NULL);
    gtk_signal_connect(GTK_OBJECT(filesel), "delete_event", gtk_main_quit, NULL);
  }
  gtk_widget_show_all(filesel);
  gtk_main();
  if (rc == 0) {
    rv = gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel));
  }
  gtk_widget_hide_all(filesel);
  return rv;
}

char *xhardmeter_text_dialog(GtkWindow *window, const char *title, const char *text)
{
  GtkWidget *dialog = NULL;
  GtkWidget *entry = NULL;
  GtkWidget *button;
  int rc = -1;
  char *rv;

  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), window);
  gtk_window_set_default_size(GTK_WINDOW(dialog), 300, 100);

  if (title != NULL) {
    GtkWidget *label = gtk_label_new(title);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
  }

  entry = gtk_entry_new();
  gtk_signal_connect(GTK_OBJECT(entry), "activate", ok_cb, &rc);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), entry, TRUE, TRUE, 0);

  button = gtk_button_new_with_label("OK");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", ok_cb, &rc);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
  
  button = gtk_button_new_with_label("Cancel");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", gtk_main_quit, NULL);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);

  gtk_entry_set_text(GTK_ENTRY(entry), text ? text : "");
  gtk_widget_grab_focus(GTK_WIDGET(entry));
  gtk_widget_show_all(dialog);
  gtk_main();
  rv = (rc == 0) ? g_strdup(gtk_entry_get_text(GTK_ENTRY(entry))) : NULL;
  gtk_widget_destroy(dialog);
  return rv;
}

GtkWidget *xhardmeter_label_with_tooltips(const char *labeltext, const char *tip)
{
  static GtkTooltips *tooltips = NULL;
  GtkWidget *eventbox;
  GtkWidget *label;

  if (tooltips == NULL)
    tooltips = gtk_tooltips_new();

  label = gtk_label_new(labeltext);

  eventbox = gtk_event_box_new();
  gtk_container_add(GTK_CONTAINER(eventbox), label);
  if (tip != NULL) {
    gtk_tooltips_set_tip(tooltips, eventbox, tip, NULL);
  }
  return eventbox;
}

int xhardmeter_ask(GtkWindow *window, const char *msg)
{
  GtkWidget *dialog = NULL;
  GtkWidget *button;
  int rc = -1;

  dialog = gtk_dialog_new();
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), window);
  gtk_window_set_default_size(GTK_WINDOW(dialog), 300, 100);

  if (msg != NULL) {
    GtkWidget *label = gtk_label_new(msg);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
  }

  button = gtk_button_new_with_label("Yes");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", ok_cb, &rc);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);
  
  button = gtk_button_new_with_label("No");
  gtk_signal_connect(GTK_OBJECT(button), "clicked", gtk_main_quit, NULL);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, TRUE, TRUE, 0);

  gtk_widget_show_all(dialog);
  gtk_main();
  gtk_widget_destroy(dialog);
  if (rc == 0)
    return TRUE;
  else
    return FALSE;
}

