/* $Id: misc.c,v 1.6 2003/02/19 21:20:58 mikpe Exp $
 * Miscellaneous perfctr operations.
 *
 * Copyright (C) 1999-2003  Mikael Pettersson
 */

#include <stdio.h>
#include "libperfctr.h"

unsigned perfctr_info_nrctrs(const struct perfctr_info *info)
{
    switch( info->cpu_type ) {
      case PERFCTR_X86_GENERIC:
	return 0;
      case PERFCTR_X86_VIA_C3:
	return 1;
      case PERFCTR_X86_AMD_K7:
      case PERFCTR_X86_AMD_K8:
	return 4;
      case PERFCTR_X86_INTEL_P4:
      case PERFCTR_X86_INTEL_P4M2:
	return 18;
      default:
	return 2;
    }
}

const char *perfctr_info_cpu_name(const struct perfctr_info *info)
{
    switch( info->cpu_type ) {
      case PERFCTR_X86_GENERIC:
	return "Generic x86 with TSC";
      case PERFCTR_X86_INTEL_P5:
        return "Intel Pentium";
      case PERFCTR_X86_INTEL_P5MMX:
        return "Intel Pentium MMX";
      case PERFCTR_X86_INTEL_P6:
        return "Intel Pentium Pro";
      case PERFCTR_X86_INTEL_PII:
        return "Intel Pentium II";
      case PERFCTR_X86_INTEL_PIII:
        return "Intel Pentium III";
      case PERFCTR_X86_CYRIX_MII:
        return "Cyrix 6x86MX/MII/III";
      case PERFCTR_X86_WINCHIP_C6:
	return "WinChip C6";
      case PERFCTR_X86_WINCHIP_2:
	return "WinChip 2/3";
      case PERFCTR_X86_AMD_K7:
	return "AMD K7";
      case PERFCTR_X86_VIA_C3:
	return "VIA C3";
      case PERFCTR_X86_INTEL_P4:
	return "Intel Pentium 4";
      case PERFCTR_X86_INTEL_P4M2:
	return "Intel Pentium 4 Model 2";
      case PERFCTR_X86_AMD_K8:
	return "AMD K8";
      default:
        return "?";
    }
}

static void print_cpus(unsigned long cpus)
{
    unsigned int nrcpus, nr;
    unsigned long mask;

    printf("0x%lX ([", cpus);
    nrcpus = 0;
    for(nr = 0, mask = 1; cpus != 0; nr += 1, mask <<= 1) {
	if( cpus & mask ) {
	    cpus &= ~mask;
	    if( nrcpus )
		printf(",");
	    ++nrcpus;
	    printf("%u", nr);
	}
    }
    printf("], total: %u)\n", nrcpus);
}

void perfctr_info_print(const struct perfctr_info *info)
{
    static const char * const features[] = { "rdpmc", "rdtsc", "pcint" };
    int fi, comma;

    printf("driver_version\t\t%s\n", info->version);
    printf("cpus\t\t\t"); print_cpus(info->cpus);
    printf("cpus_forbidden\t\t"); print_cpus(info->cpus_forbidden);
    printf("cpu_type\t\t%u (%s)\n", info->cpu_type, perfctr_info_cpu_name(info));
    printf("cpu_features\t\t%#x (", info->cpu_features);
    for(comma = 0, fi = 0; fi < sizeof features / sizeof features[0]; ++fi) {
	unsigned fmask = 1 << fi;
	if( info->cpu_features & fmask ) {
	    if( comma )
		printf(",");
	    printf("%s", features[fi]);
	    comma = 1;
	}
    }
    printf(")\n");
    printf("cpu_khz\t\t\t%lu\n", info->cpu_khz);
    printf("cpu_nrctrs\t\t%u\n", perfctr_info_nrctrs(info));
}
