/* $Id: compat.h,v 1.35 2003/02/24 02:39:01 mikpe Exp $
 * Performance-monitoring counters driver.
 * Compatibility definitions for 2.5 kernels.
 *
 * Copyright (C) 1999-2003  Mikael Pettersson
 */
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#include "compat22.h"
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
#include "compat24.h"
#else

#include <linux/proc_fs.h>

#define EXPORT_SYMBOL___put_task_struct	EXPORT_SYMBOL(__put_task_struct)
#define EXPORT_SYMBOL_pidhash	/*empty*/
#define EXPORT_SYMBOL_tasklist_lock	/*empty*/
#define TASK_IS_PTRACED(tsk)	((tsk)->ptrace & PT_PTRACED)
#define get_cpus_allowed(tsk)	((tsk)->cpus_allowed)
#define proc_pid_inode_denotes_task(inode,tsk) ((tsk) == PROC_I((inode))->task)
#define task_thread(tsk)	(&(tsk)->thread)
#define vma_pgoff(vma)		((vma)->vm_pgoff)

#endif
