/* $Id: compat24.h,v 1.9 2003/05/17 23:31:53 mikpe Exp $
 * Performance-monitoring counters driver.
 * Compatibility definitions for 2.4 kernels.
 *
 * Copyright (C) 1999-2003  Mikael Pettersson
 */
#include <linux/kernel.h>
#include <linux/mm.h>

/* 2.4.9-ac had MODULE_LICENSE() before 2.4.10 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,10) && !defined(MODULE_LICENSE)
#define MODULE_LICENSE(license)	/*empty*/
#endif

/* 2.4.9-ac had cpu_relax() before 2.4.11 */
#if defined(CONFIG_X86) && LINUX_VERSION_CODE < KERNEL_VERSION(2,4,11) && !defined(cpu_relax)
#define cpu_relax()		rep_nop()
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,15)
extern int ptrace_check_attach(struct task_struct *child, int kill);
#define task_has_cpu(tsk)	((tsk)->has_cpu)
#endif

/* 2.4.18-redhat had BUG_ON() before 2.4.19 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,19) && !defined(BUG_ON)
#define BUG_ON(condition)	do { if ((condition) != 0) BUG(); } while(0)
#endif

/* 2.4.18-redhat had set_cpus_allowed() before 2.4.21-pre5 */
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,21) && !defined(HAVE_SET_CPUS_ALLOWED)
#if defined(CONFIG_SMP) && LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,15)
extern void set_cpus_allowed(struct task_struct*, unsigned long);
#else
#define set_cpus_allowed(tsk, mask)	do{}while(0)
#endif
#endif

/* 2.4.20-8-redhat added cpu_online() */
#if !defined(cpu_online)
#define cpu_online(cpu)		(cpu_online_map & (1UL << (cpu)))
#endif

/* 2.4.20-8-redhat added put_task_struct() */
#if defined(put_task_struct)	/* RH 2.4.20-8 */
#define EXPORT_SYMBOL___put_task_struct	EXPORT_SYMBOL(__put_task_struct)
#else				/* standard 2.4 */
#define put_task_struct(tsk)	free_task_struct((tsk))
#define EXPORT_SYMBOL___put_task_struct	/*empty*/
#endif

/* remap_page_range() changed in 2.5.3-pre1 and 2.4.20-8-redhat */
#if !defined(HAVE_5ARG_REMAP_PAGE_RANGE)
static inline int perfctr_remap_page_range(struct vm_area_struct *vma, unsigned long from, unsigned long to, unsigned long size, pgprot_t prot)
{
	return remap_page_range(from, to, size, prot);
}
#undef remap_page_range
#define remap_page_range(vma,from,to,size,prot) perfctr_remap_page_range((vma),(from),(to),(size),(prot))
#endif

/* not in 2.4 proper, but some people use 2.4 with preemption patches */
#ifdef CONFIG_PREEMPT
#error "not yet ported to 2.4+PREEMPT"
#endif
#define preempt_disable()	do{}while(0)
#define preempt_enable()	do{}while(0)

#define EXPORT_SYMBOL_pidhash	/*empty*/
#define EXPORT_SYMBOL_tasklist_lock	/*empty*/
#define PROC_I(inode)		(&(inode)->u.proc_i)
#define TASK_IS_PTRACED(tsk)	((tsk)->ptrace & PT_PTRACED)
#define get_cpus_allowed(tsk)	((tsk)->cpus_allowed)
#define module_put(MOD)		MOD_DEC_USE_COUNT
#define proc_pid_inode_denotes_task(inode,tsk) ((tsk) == (inode)->u.proc_i.task)
#define task_thread(tsk)	(&(tsk)->thread)
static inline void try_module_get(void *m) { MOD_INC_USE_COUNT; }
#define vma_pgoff(vma)		((vma)->vm_pgoff)

/* introduced in 2.5.64 */
static inline int on_each_cpu(void (*func) (void *info), void *info,
                              int retry, int wait)
{
        int ret = 0;

        preempt_disable();
        ret = smp_call_function(func, info, retry, wait);
        func(info);
        preempt_enable();
        return ret;
}
