/* ^C}֌W */

#include "bootpack.h"

#define PIT_CTRL	0x0043
#define PIT_CNT0	0x0040

struct TIMERCTL timerctl;

#define TIMER_FLAGS_ALLOC		1	/* mۂ */
#define TIMER_FLAGS_USING		2	/* ^C}쓮 */

void init_pit(void)
{
	int i;
	struct TIMER *t;
	io_out8(PIT_CTRL, 0x34);
	io_out8(PIT_CNT0, 0x9c);
	io_out8(PIT_CNT0, 0x2e);
	timerctl.count = 0;
	for (i = 0; i < MAX_TIMER; i++) {
		timerctl.timers0[i].flags = 0; /* gp */
	}
	t = timer_alloc(); /* Ă */
	t->timeout = 0xffffffff;
	t->flags = TIMER_FLAGS_USING;
	t->next = 0; /* Ԃ */
	timerctl.t0 = t; /* ͔ԕȂ̂Ő擪ł */
	timerctl.next = 0xffffffff; /* ԕȂ̂Ŕԕ̎ */
	return;
}

struct TIMER *timer_alloc(void)
{
	int i;
	for (i = 0; i < MAX_TIMER; i++) {
		if (timerctl.timers0[i].flags == 0) {
			timerctl.timers0[i].flags = TIMER_FLAGS_ALLOC;
			timerctl.timers0[i].flags2 = 0;
			return &timerctl.timers0[i];
		}
	}
	return 0; /* Ȃ */
}

void timer_free(struct TIMER *timer)
{
	timer_cancel(timer);	/* Ôߎ */
	timer->flags = 0;		/* gp */
	return;
}

void timer_init(struct TIMER *timer, struct FIFO32 *fifo, int data)
{
	timer->fifo = fifo;
	timer->data = data;
	return;
}

void timer_settime(struct TIMER *timer, unsigned int timeout)
{
	int e;
	struct TIMER *t, *s;
	timer->timeout = timeout + timerctl.count;
	timer->flags = TIMER_FLAGS_USING;
	e = io_load_eflags();
	io_cli();
	t = timerctl.t0;
	if (timer->timeout <= t->timeout) {
		/* 擪ɓꍇ */
		timerctl.t0 = timer;
		timer->next = t; /* t */
		timerctl.next = timer->timeout;
		io_store_eflags(e);
		return;
	}
	/* ǂɓ΂T */
	for (;;) {
		s = t;
		t = t->next;
		if (timer->timeout <= t->timeout) {
			/* st̊Ԃɓꍇ */
			s->next = timer; /* s̎timer */
			timer->next = t; /* timer̎t */
			io_store_eflags(e);
			return;
		}
	}
}

void inthandler20(int *esp)
{
	struct TIMER *timer;
	char ts = 0;
	io_out8(PIC0_OCW2, 0x60);	/* IRQ-00tPICɒʒm */
	timerctl.count++;
	if (timerctl.next > timerctl.count) {
		return;
	}
	timer = timerctl.t0; /* Ƃ肠擪̔Ԓntimerɑ */
	for (;;) {
		/* timers̃^C}͑Sē쒆̂̂Ȃ̂ŁAflagsmFȂ */
		if (timer->timeout > timerctl.count) {
			break;
		}
		/* ^CAEg */
		timer->flags = TIMER_FLAGS_ALLOC;
		if (timer != task_timer) {
			fifo32_put(timer->fifo, timer->data);
		} else {
			ts = 1; /* task_timer^CAEg */
		}
		timer = timer->next; /* ̃^C}̔Ԓntimerɑ */
	}
	timerctl.t0 = timer;
	timerctl.next = timer->timeout;
	if (ts != 0) {
		task_switch();
	}
	return;
}

int timer_cancel(struct TIMER *timer)
{
	int e;
	struct TIMER *t;
	e = io_load_eflags();
	io_cli();	/* ݒ蒆Ƀ^C}̏ԂωȂ悤ɂ邽 */
	if (timer->flags == TIMER_FLAGS_USING) {	/* ͕KvH */
		if (timer == timerctl.t0) {
			/* 擪ꍇ̎ */
			t = timer->next;
			timerctl.t0 = t;
			timerctl.next = t->timeout;
		} else {
			/* 擪ȊȌꍇ̎ */
			/* timer̈OT */
			t = timerctl.t0;
			for (;;) {
				if (t->next == timer) {
					break;
				}
				t = t->next;
			}
			t->next = timer->next; /* utimer̒Ov̎Autimer̎vw悤ɂ */
		}
		timer->flags = TIMER_FLAGS_ALLOC;
		io_store_eflags(e);
		return 1;	/* LZ */
	}
	io_store_eflags(e);
	return 0; /* LZ͕sv */
}

void timer_cancelall(struct FIFO32 *fifo)
{
	int e, i;
	struct TIMER *t;
	e = io_load_eflags();
	io_cli();	/* ݒ蒆Ƀ^C}̏ԂωȂ悤ɂ邽 */
	for (i = 0; i < MAX_TIMER; i++) {
		t = &timerctl.timers0[i];
		if (t->flags != 0 && t->flags2 != 0 && t->fifo == fifo) {
			timer_cancel(t);
			timer_free(t);
		}
	}
	io_store_eflags(e);
	return;
}
