/* tbs[fBXNRg[ */

#include "bootpack.h"

struct FDC {	/* fdcւ̗v */
	char mode, mot;		/* [hƃ[^̏ */
	char cyl, head, sect;	/* x[XԒn */
	char sects;		/* JEg */
	char st0;		/* gp郊UgXe[^X */
};

struct FIFO32 *ffifo;	/* FDC̃^XNpFIFO */
struct FIFO32 fififo;	/* FDCƂ̒pFIFO */
int ffbuf[32], fibuf[32];
struct FDC fdc;		/* ݏ̃f[^̈ */

void fdc_initfdc(void)
{
	/* FDC\̂̏ */
	fdc.mode = 0;
	fdc.cyl = 0;
	fdc.head = 0;
	fdc.sect = 0;
	fdc.sects = 0;
	fdc.st0 = 0;
	return;
}

void fdc_init(void)
{
	fdc_initfdc();

	/* DMȀ */
	io_out8(0x00d6, 0xc0);	/* }X^ch0JXP[h[h */
	io_out8(0x00c0, 0x00);	/* X[uDMA */
	io_out8(0x000a, 0x06);	/* }X^ch2DMA}XN */
	return;
}

void fdc_initwait(int wait)
{
	for(;;) {
		if((io_in8(0x03f4) & wait) == 0) {
			break;
		}
	}
	return;
}

void fdc_sendcmd(int data)
{
	for(;;) {
		if((io_in8(0x03f4) & 0xc0) == 0x80) {
			io_out8(0x03f5, data);
			return;
		}
	}
}

void fdc_setdma(void)
{
	int addr = ADR_DISKIMG + (fdc.cyl * 36 + fdc.head * 18 + fdc.sect - 1) * 512;

	if(fdc.mode == 1) {
		io_out8(0x000b, 0x06);	/* f}hEAhXEւ̏݁Ech2 */
	} else if(fdc.mode == 2) {
		io_out8(0x000b, 0x0a);	/* f}hEAhXE̓ǂݍ݁Ech2 */
	}

	io_out8(0x0005, 0xff);	/* oCg̐ݒ */
	io_out8(0x0005, fdc.sects * 2 - 1);

	io_out8(0x0004, addr & 0xff);	/* Ԓn̐ݒ */
	io_out8(0x0004, (addr >> 8) & 0xff);
	io_out8(0x0081, (addr >> 16) & 0xff);

	io_out8(0x000a, 0x02);	/* }X^ch2̃}XN */
	return;
}

void fdc_sethead(void)
{
	fdc_initwait(0x11);
	fdc_sendcmd(0x0f);		/* V[N */
	fdc_sendcmd(fdc.head << 2);	/* wbh */
	fdc_sendcmd(fdc.cyl);		/* V_ */
	return;
}

void fdc_setcmd(void)
{
	fdc_initwait(0x11);

	if(fdc.mode == 1) {	/* [hw */
		fdc_sendcmd(0xe6);	/* ǂݍ */
	} else if(fdc.mode == 2) {
		fdc_sendcmd(0xc5);	/*  */
	}

	fdc_sendcmd(fdc.head << 2);	/* FDԒn̎w */
	fdc_sendcmd(fdc.cyl);
	fdc_sendcmd(fdc.head);
	fdc_sendcmd(fdc.sect);

	fdc_sendcmd(0x02);	/* ZN^F512B */
	if(fdc.mode == 1) {
		fdc_sendcmd(0x12);	/* gbNF18 */
		fdc_sendcmd(0x01);	/* GAP3 */
	} else if(fdc.mode == 2) {
		fdc_sendcmd(0x7f);	/* ? */
		fdc_sendcmd(0x12);	/* ? */
	}
	fdc_sendcmd(0xff);	/* wZN^TCYŜΏ */
	return;
}

char fdc_getrstatsub(void)
{
	char i;

	for(;;) {
		if((io_in8(0x03f4) & 0xc0) == 0xc0) {
			break;
		}
	}
	i = (char) io_in8(0x03f5);
	return i;
}

void fdc_getint(void)
{
	fdc_initwait(0x10);
	fdc_sendcmd(0x08);	/* 荞ݏԎ擾 */
	fdc.st0 = fdc_getrstatsub();
	fdc_getrstatsub();	/* ĨV_Fǂݎ̂ */
	return;
}

void fdc_getrstat(void)
{
	fdc.st0 = fdc_getrstatsub();
	fdc_getrstatsub();	/* st1 */
	fdc_getrstatsub();	/* st2 */
	fdc_getrstatsub();	/* ĨV_Fǂݎ̂ */
	fdc_getrstatsub();	/* Ĩwb_Fǂݎ̂ */
	fdc_getrstatsub();	/* ĨZN^Fǂݎ̂ */
	fdc_getrstatsub();	/* ZN^TCYFǂݎ̂ */
	return;
}

int fdc_rdwri(void)
{
	struct TASK *task = task_now();
	struct TIMER *timer;
	int err = 0, ret = 0, ph = 0, i;

	fdc_setdma();
	if(fdc.mot == 1) {
		fdc_sethead();
	} else {	/* [^JnƉ]̂߂ɑ҂ */
		io_out8(0x03f2, 0x1c);	/* [^X^[g */

		timer = timer_alloc();
		timer_init(timer, &fififo, 1);
		timer_settime(timer, 300);
	}

	for(;;) {
		io_cli();
		if(fifo32_status(&fififo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&fififo);
			io_sti();
			if(i == 1) {
				fdc_sethead();
			} else if(i == 6) {
				if(ph == 0) {	/* V[N */
					fdc_getint();
					if((fdc.st0 & 0xc0) == 0x00) {	/* I */
						fdc_setcmd();
						ph = 1;
					} else {	/* ُȃXe[^X */
						ret = 2;
						goto end;
					}
				} else {	/* R}hI */
					fdc_getrstat();
					if((fdc.st0 & 0xc0) == 0x00) {		/* I */
						ret = 0;
						goto end;
					} else if((fdc.st0 & 0xc0) == 0x40) {	/* ُI */
						if(err > 5) {
							ret = 1;
							goto end;
						} else {
							err++;
							fdc_setcmd();
						}
					} else {	/* ُȃXe[^X */
						ret = 2;
						goto end;
					}
				}
			}
		}
	}

	/* I̐ݒ */
end:
	io_out8(0x000a, 0x06);	/* }X^ch2}XN */

	if(fdc.mot != 1) {
		timer_free(timer);
		fdc.mot = 1;
	}
	return ret;
}

/* FDCւ̑𒇉B
 * ffifoɎ̂悤ȃf[^cli-stiőƎw肳ꂽfifo *ɁA
 * ̃f[^B삳ꏊ́ADISKIMG_ADDR
 * fBXNC[WzĂ̈ʒułB
 * ǂݍ: [1 << 12 | ZN^ԍ] [ZN^] [fifo *]
 * : [2 << 12 | ZN^ԍ] [ZN^] [fifo *]
 * ߂l  : 0: I
 *           1: ُI
 *           2: sȖ߂ł̏I
 * ZN^ԍ́AV_ * 36 + wbh * 18 + (ZN^ - 1j
 * vZłB
 */
void fdc_task(void)
{
	struct TASK *task = task_now();
	struct FIFO32 *f;
	struct TIMER *timer;	/* [^p^C} */
	int ret, i, j;

	fifo32_init(&fififo, 32, fibuf, task);

	fdc_init();
	io_out8(0x03f2, 0x0c);	/* [^Xgbv */
	fdc.mot = 0;

	timer = timer_alloc();
	timer_init(timer, &task->fifo, 1);

	for(;;) {
		io_cli();
		if(fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if(i == 1) {	/* [^~߂Ă悢 */
				fdc.mot = 0;
				io_out8(0x03f2, 0x0c);
			} else {	/* v */
				timer_cancel(timer);

				/* fdc\̂֊i[ */
				fdc.mode = (char) ((i >> 12) & 0x03);

				j = (short) (i & 0x0fff);
				fdc.cyl = (char) (j / 36);
				fdc.head = (char) (j % 36 / 18);
				fdc.sect = (char) (j % 36 % 18 + 1);
				fdc.sects = fifo32_get(&task->fifo);

				f = (struct FIFO *) fifo32_get(&task->fifo);

				if(fdc.mode == 1 || fdc.mode == 2) {
					ret = fdc_rdwri();
					fifo32_put(f, ret);
				} else {	/* sȖ߂ł̏I */
					fifo32_put(f, 2);
				}

				/* ̂߂ɏ */
				fdc_initfdc();
				timer_settime(timer, 300);
			}
		}
	}
}

void fdc_ihandle(int *esp)
{
	io_in8(0x03f4);
	io_out8(PIC0_OCW2, 0x66);	/* IRQ-06Ɋʒm */
	fifo32_put(&fififo, 6);
	return;
}
