//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		DefaultRenderer.java
//	DATE:		2003.5.24	initial version
//	MODIFIED:	2003.7.15	\zAbackground colorwł悤ɂ
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Color;

import java.awt.geom.Area;

import jp.gr.java_conf.ktz.puzzle.framework.State;

/**
 *	Listenerx[XRenderer̎B
 *	̎ł́ARenderListener̎addRenderListener(...)
 *	œo^ĂȂꍇAŃx^h肷邾B
 *
 *	puzzle.framework.Renderer炳ɂ̃\bhǉĂ邽
 *	p҂́ARendererC^[tF[Xł͂ȂADefaultRendererŃANZX邱ƂƂȂB
 */
public final class DefaultRenderer implements Renderer {
	private static final int DEFAULT_PIECE_SIZE = 24;
	
	private static java.util.Map sTable = new java.util.HashMap();
	
	private BufferedImage mDoubleBuffer;
	private Graphics mGraphics;
	private int mPieceUnit = DEFAULT_PIECE_SIZE;
	private java.awt.Dimension mPieceSize = new java.awt.Dimension(mPieceUnit, mPieceUnit);
	private RenderEvent mEvent = new RenderEvent();
	private Color mBackground = Color.BLACK;
	
	/** ftHgRenderListenerBListenerĂ΂OɌĂ΂B */
	private RenderListener mDefaultListener = new RenderListener() {
		public void render(RenderEvent inEvent) {
			Rectangle aBounds = inEvent.getBounds();
			
			mGraphics.setColor(java.awt.Color.white);
			mGraphics.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	};
	
	/**
	 *	RXgN^
	 *
	 */
	public DefaultRenderer() {
	}
	
	/**
	 *	RXgN^
	 *
	 *	@param	inWidth Ֆʂ̕iBoardWnj
	 *	@param	inHeight Ֆʂ̍iBoardWnj
	 */
	public DefaultRenderer(final int inWidth, final int inHeight) {
		setSize(inWidth, inHeight);
	}
	
	/**
	 *	RXgN^
	 *
	 *	@param	inWidth 		Ֆʂ̕iBoardWnj
	 *	@param	inHeight 		Ֆʂ̍iBoardWnj
	 *	@param	inBackground	obNOEhJ[
	 */
	public DefaultRenderer(final int inWidth, final int inHeight, Color inBackground) {
		mBackground = inBackground;
		setSize(inWidth, inHeight);
	}
	
	/**
	 *	Ֆʂ`悷B
	 *	̎ł́AeX̃Z̏Ԃɏ]āA
	 *	RenderListener̎Aۂ̕`RenderListenerɓ]B
	 *	Stateɑ΂RenderListener̎ȂꍇAŃx^h肳邾B
	 *
	 *	@param	inX ZxWiboardWnj
	 *	@param	inX ZyWiboardWnj
	 *	@param	inState Z̏
	 */
	public void render(final int inX, final int inY, State inState) {

		if (null == mGraphics) {
			throw new IllegalStateException(
				"The Graphics object is not initialized. \n"
				+"Calling DefaultRenderer.setSize(...) method, lead to initialize the graphics object. "
			);
		}
		
		Rectangle aBounds = new Rectangle(inX*mPieceUnit, inY*mPieceUnit, mPieceUnit, mPieceUnit);
		
		mEvent.reset(this, mGraphics, aBounds, inState);
		
		mDefaultListener.render(mEvent);
		lookup(inState).render(mEvent);
		
	}
	
	/**
	 *	w肳ꂽStateɑΉRenderListener̎Ԃ
	 *
	 *	@param	inState ̃L[B̎łClassIuWFNgۂ̃L[
	 *	@return	RenderListener̎
	 */
	public RenderListener lookup(State inState) {
		if (sTable.containsKey(inState.getClass())) {
			 return (RenderListener)sTable.get(inState.getClass());
		}
		
		return mDefaultListener;
	}
	
	/**
	 *	RenderListenero^B
	 *
	 *	@param	inClass ̃L[ƂȂlB
	 *	@param	inListenr o^郊Xi̎B
	 */
	public void addRenderListener(Class inClass, RenderListener inListenr) {
		sTable.put(inClass, inListenr);
	}
	
	/**
	 *	ftHgRenderListenero^B
	 *	ListenerunicastłB
	 *
	 *	@param	inListenr o^郊Xi̎B
	 */
	public void setDefaultRenderListener(RenderListener inListenr) {
		mDefaultListener = inListenr;
	}
	
	/**
	 *	Ֆʂ̃TCYύXB
	 *
	 *	@param	inWidth Ֆʂ̕iScreenWnj
	 *	@param	inHeight Ֆʂ̍iScreenWnj
	 */
	public void setSize(final int inWidth, final int inHeight) {
		// buffer܂ĂȂ΁AB
		if (null == mDoubleBuffer
			|| inWidth * mPieceUnit +1 != mDoubleBuffer.getWidth()
				 || inHeight * mPieceUnit +1 != mDoubleBuffer.getHeight())
		{
			mDoubleBuffer = new java.awt.image.BufferedImage(
					inWidth * mPieceUnit +1, 
					inHeight * mPieceUnit +1, 
					BufferedImage.TYPE_INT_RGB
			);
			
			mGraphics = mDoubleBuffer.getGraphics();
			mGraphics.setColor(mBackground);
			mGraphics.fillRect(0, 0, inWidth * mPieceUnit +1, inHeight * mPieceUnit +1);
		}
	}
	
	/**
	 *	@return	Board̃TCYԂ(ScreenzWnj
	 */
	public java.awt.Dimension getBoardSize() {
	 	return new java.awt.Dimension(
	 					mDoubleBuffer.getWidth(), 
	 					mDoubleBuffer.getHeight()
	 	);
	}
	 
	/**
	 *	Z̃TCYύX
	 *	̎ł́AZ͐`ł
	 *
	 *	@param	inSize Z̃TCYiScreenWnj
	 */
	 public void setPieceSize(java.awt.Dimension inSize) {
	 	if (inSize.width != inSize.height) {
	 		throw new IllegalArgumentException("inSize.width != inSize.height");
	 	}
	 	
	 	mPieceUnit = inSize.width;
	 	mPieceSize.setSize(mPieceUnit, mPieceUnit);
	 }
	 
	/**
	 *	@return	Board̃TCYԂ(ScreenzWnj
	 */
	public java.awt.Dimension getPieceSize() {
	 	return mPieceSize;
	}

	/**
	 *	w肳ꂽBoardWn̈ʒuScreenWnɕϊ
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@return	ϊ̍W
	 */
	 public java.awt.Point calcPortToBoardPos(final int inX, final int inY) {
	 	return new java.awt.Point(
	 				(int)Math.floor((double)inX/mPieceUnit), 
	 				(int)Math.floor((double)inY/mPieceUnit)
	 	);
//	 	return new java.awt.Point(inX/mPieceUnit, inY/mPieceUnit);
	 }
	 
	/**
	 *	@return	OffscreenC[WԂ
	 */
	public Image getImage() {
		return mDoubleBuffer;
	}
	
	/**
	 *	Clipping̈vZB
	 *
	 *	@param	inPos ύXꂽՖʂ̈ʒuB
	 *	@return	Clipping̈
	 */
	public Rectangle getClipBounds(java.awt.Point[] inPos) {
		Area aArea = new Area();
		Rectangle aBounds = new Rectangle();
		
		for (int i = 0; i < inPos.length; ++i) {
			aBounds.setBounds(inPos[i].x*mPieceUnit, inPos[i].y*mPieceUnit, mPieceUnit, mPieceUnit);
			aArea.add(new Area(aBounds));
		}
		
		return aArea.getBounds();
	}
}




