// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		BoardSizeCommand.java
//	DATE:		2003.6.30
//	CREATOR:	Kazuhiko TAMURA
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.command;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;

/**
 *	ViewTCY̕ύXwCommand
 */
public class BoardSizeCommand extends AbstractBottomUpCommand {
	/** ύX̕ */
	private int mComponentWidth;
	
	/** ύX̍ */
	private int mComponentHeight;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inSrcView	Command`d̃Gg[|Cg
	 *	@param	inComonentWidth	 	ύX̃R|[lg̕
	 *	@param	inComonentHeight	ύX̃R|[lg̍
	 */
	public BoardSizeCommand(
			CommandContainer inSrcView, 
			final int inComponentWidth, final int inComponentHeight)
	{
		super(inSrcView);
		
		mComponentWidth = inComponentWidth;
		mComponentHeight = inComponentHeight;
	}
	
	/**
	 *	ύX̃R|[lg̕o
	 *
	 *	@return	ύX̃R|[lg̕
	 */
	public int getComponentWidth() {
		return mComponentWidth;
	}
	
	/**
	 *	ύX̃R|[lg̍o
	 *
	 *	@return	ύX̃R|[lg̍ 
	 */
	public int getComponentHeight() {
		return mComponentHeight;
	}
	
	/**
	 *	ύX̃TCYw肷
	 */
	public void setComponentSize(final int inWidth, final int inHeight) {
		mComponentWidth = inWidth;
		mComponentHeight = inHeight;
	}
	
	public String toString() {
		return PieceSizeCommand.class.getName();
	}
}