// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		Board.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Dimension;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;

import java.io.File;

import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.framework.RenderListener;
import jp.gr.java_conf.ktz.puzzle.framework.RenderEvent;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.CreatorMenuID;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemMarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveDiscompletedException;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemInfoBean;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemCollection;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ComponentUsher;

import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.CellActivationModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.model.CreatorBoardModel;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.NullSolverHandler;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.SolverRendererFactory;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.SaveCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.KeyScrollCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ChangeModeCommand;



/**
 *	ՖʂǗViewKw
 */
public class Board extends java.awt.Canvas implements BoardView {
	/** Ֆʂ̃ftHg̕ */
	private static final int DEFAULT_BOARD_WIDTH = 9;

	/** Ֆʂ̃ftHg̍ */
	private static final int DEFAULT_BOARD_HEIGHT = 9;

	/** Ֆʂ̕`s_ */
	private DefaultRenderer mRenderer;
	
	/** gbvxModelւ̎Q */
	private Model mModel = NullModel.getInstance();
	
	/** 쐬x[hA𓚂shandler */
	private SolverHandler mSolverHandler = NullSolverHandler.getInstance();
	
	/** View̐e */
	private BoardView mParent;
	
	/**
	 *	Boardɑ΂ύXtO
	 *	͂n߂ĂAModelύXĂꍇtrueƂȂ 
	 */
	private boolean mIsModified = false;
	
	/** creator modȅꍇtruew肷 */
	private boolean mIsCreatorMode;
	/**
	 *	ViewKw
	 */
	public void initialize() {
		// Rendereȑ
		mRenderer = SolverRendererFactory.create(DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_HEIGHT);
		mRenderer.setDefaultRenderListener(new RenderListener() {
			public void render(RenderEvent inEvent) {
				Graphics aGra = inEvent.getGraphics();
				Rectangle aBounds = inEvent.getBounds();
				
				aGra.setColor(AppColors.SPACE);
				aGra.fillRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
				
				aGra.setColor(AppColors.WALL_COLOR);
				aGra.drawRect(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		});
		
		// Model̏
//		addModel(new BoardModel());
		addModel(new CreatorBoardModel());
		addModel(new SolverStateModel(false));
		addModel(new CellActivationModel());
		
		mModel.nextStateAt(0, 0);
		
		// Canvas̏
		setBackground(AppColors.BACK_COLOR);
		
		// {[hɃtH[JXڂ
		java.awt.event.FocusEvent aEvent = 
				new java.awt.event.FocusEvent(this, java.awt.event.FocusEvent.FOCUS_GAINED);
		
		java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);

		// Listener̓o^
		MouseHandler aHandler = new MouseHandler(new Point(0, 0));
		addKeyListener(aHandler);
		addMouseListener(aHandler);
		
		// Piece size]
		PieceSizeCommand aCommand = new PieceSizeCommand(this, getPieceSize());
		AWTDispatchCommandQueue.postCommand(aCommand);
	}
	
	/**
	 *	ݏLĂ郂fw肵fɕύXB
	 *	̎ł́Aw肵fAbstractDecoratedModel̏ꍇ
	 *	ݏLĂ郂f̃fŃbv
	 *
	 *	@param	inModel	bv郂f
	 */
	private void addModel(Model inModel) {
		if (inModel instanceof AbstractDecoratedModel) {
			((AbstractDecoratedModel)inModel).addModel(mModel);
		}
		
		mModel = inModel;
	}
	
	/**
	 *	Commands
	 *	̎ł́ÃvZXŏłȂƂA
	 *	ʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	public void processCommand(Command inCommand) {
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		// ̃vZXŏłȂƂA
		// ܂́AʂCommandContainerŎw肵CommandƂ
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractBottomUpCommand) {
				mParent.processCommand(inCommand);
			}
		}
	}

	/**
	 *	Command̎
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == ResetCommand.class) {
			clearAll();
			inCommand.consume();
		}
		else if (aClass == BoardSizeCommand.class) {
			BoardSizeCommand aCommand = (BoardSizeCommand)inCommand;
			
			final int aWidth = (aCommand).getComponentWidth();
			final int aHeight = (aCommand).getComponentHeight();
			
			setComponentSize(aWidth, aHeight);
		}
		else if (aClass == ResizeCommand.class) {
			CommandContainer aCommander
					 = ((ResizeCommand)inCommand).getDestination();
			
			final int aWidth = getBoardWidth();
			final int aHeight = getBoardHeight();
			
			ResizeResultCommand aCommand
				 = new ResizeResultCommand(aCommander, aWidth, aHeight);
			AWTDispatchCommandQueue.postCommand(aCommand);
		}
		else if (aClass == ResizeResultCommand.class) {
			final int aWidth = ((ResizeResultCommand)inCommand).getWidth();
			final int aHeight = ((ResizeResultCommand)inCommand).getHeight();
			
			createBoard(aWidth, aHeight);
			
		}
		else if (aClass == SaveCommand.class) {
			File aFile = ((SaveCommand)inCommand).getFile();
			
			save(aFile);
		}
		else if (aClass == LoadCommand.class) {
			ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
			load(aInfo);
			inCommand.consume();
		}
		else if (aClass == ChangeModeCommand.class) {
			changeMode();
			inCommand.consume();
		}
	}
	
	/**
	 *	Board̃TCYύX
	 *
	 *	@param	inWidth ύX̕
	 *	@param	inHeight ύX̍
	 */
	private void createBoard(final int inWidth, final int inHeight) {
		if (inWidth == getBoardWidth() && inHeight == getBoardHeight()) {
			return;
		}
		
		mModel.createBoard(inWidth, inHeight);
		mRenderer.setSize(inWidth, inHeight);
		
		java.awt.Dimension aSize = getComponentSize();
		BoardSizeCommand aCommand = new BoardSizeCommand(
								this, aSize.width, aSize.height
		);
		AWTDispatchCommandQueue.postCommand(aCommand);
		
		// (0, 0)̈ʒuANeBuƂĂ
		Point aInitialPos = new Point(0, 0);
		mModel.nextStateAt(aInitialPos.x, aInitialPos.y); 
	}
	
	/**
	 *	@return Board̕Ԃ
	 */
	private int getBoardWidth() {
		return mModel.getWidth();
	}
	
	/**
	 *	@return Board̍Ԃ
	 */
	private int getBoardHeight() {
		return mModel.getHeight();
	}

	/**
	 *	Clipping̈vZB
	 *	̎ł́ADefaultRendererɃbZ[W]̂
	 *
	 *	@param	inPos ύXꂽՖʂ̈ʒuB
	 *	@return	Clipping̈
	 */
	private Rectangle getClipBounds() {
		java.awt.Insets aInsets = getInsets();
		Rectangle aBounds = mRenderer.getClipBounds(mModel.lastModified());
		aBounds.translate(aInsets.left, aInsets.top);
		
		return aBounds;
	}
	
	/**
	 *	w肳ꂽBoardWn̈ʒuScreenWnɕϊ
	 *	̎ł́ADefaultRendererɃbZ[W]̂
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@return	ϊ̍W
	 */
	private Point calcPortToBoardPos(final int inX, final int inY) {
		java.awt.Insets aInsets = getInsets();
		
		return mRenderer.calcPortToBoardPos(inX-aInsets.left, inY-aInsets.top);
	}
	
	/**
	 *	ՖʂύXĂ邩ǂmF
	 *	̎ł͏falseԂ
	 */
	public boolean isModified() {
		return mIsModified;
	}
	
	/**
	 *	̃R|[lgȉĕ`悷
	 */
	public void update(Graphics inGra) {
		paint(inGra);
	}
	
	/**
	 *	̃R|[lg`悷
	 */
	public void paint(Graphics inGra) {
		Rectangle aBounds = new Rectangle();
		inGra.getClipBounds(aBounds);
		
		java.awt.Insets aInsets = getInsets();
		aBounds.translate(-aInsets.left,-aInsets.top);
		
		inGra.translate(aInsets.left, aInsets.top);

		// eɕύXꍇAύXAύXӏ݂̂ĕ`悷
		if (mModel.isModified()) {
			Point[] aPos = mModel.lastModified();
			
			for (int i = 0; i < aPos.length; ++i) {
				mRenderer.render(aPos[i].x, aPos[i].y, mModel.getCurStateAt(aPos[i].x, aPos[i].y));
			}
		}
		
		// off screen image肾A]
		inGra.drawImage(
				mRenderer.getImage(), 
				0, 0, 
				this
		);
		
		inGra.translate(-aInsets.left,-aInsets.top);
		
		mModel.flush();
	}
	
	/**
	 *	͎x[hƍ쐬x[h؂ւ
	 *
	 *	@param	inIsInputMode	truew肳ꂽꍇA͎x[hɐ؂ւ
	 */
	private void changeMode() {
		// mode𔽓]
		mIsCreatorMode = !mIsCreatorMode;
		mModel.setModelState(ModelStateUtility.createSolverModelState(mIsCreatorMode));
		
		if (mIsCreatorMode) {
			// handler܂\zĂȂꍇAō\z
			if (mSolverHandler == NullSolverHandler.getInstance()) {
				mSolverHandler = new HashikakeSolverHandler(mModel);
			}
			
			try {
				mSolverHandler.reset();
//				mSolverHandler.nextSoluteAll();
				while (! mSolverHandler.nextSoluteAll()) ;
			}
			catch (SolveDiscompleteException e) {
			}
		}
		else {
			mModel.reset();
			mSolverHandler.reset();
		}
		
		changeMenuCheckMark(CreatorMenuID.ITEM_INPUT_MODE, !mIsCreatorMode);
		changeMenuCheckMark(CreatorMenuID.ITEM_CREATE_MODE, mIsCreatorMode);
		enableMenu(CreatorMenuID.ITEM_OPEN, !mIsCreatorMode);
		
		if (mModel.isModified()) {
			repaint();
		}
	}
	
	/**
	 *	w肵t@Cɓ͂ۑ
	 *
	 *	@param	inOutFile	o͐
	 */
	private void save(File inOutFile) {
		File aOutFile = inOutFile;
			
		// Model̓ԂA蕶쐬
		ProblemCollection aCollection = createProblemCollection();
		
		try {
			saveProblem(aOutFile, aCollection);
			
			
			System.out.println("save complete");
		}
		catch (SaveDiscompletedException e) {
			System.out.println(e);
			return;
			
		}
		
		// ۑꍇ́ASave menudisableɂĂ
//		mIsModified = false;
//		MenuManager.currentMenuManager().setEnabledFor(CreatorMenuID.ITEM_SAVE, false);
		enableMenu(CreatorMenuID.ITEM_SAVE, false);
		mIsModified = false;
	}
	
	private ProblemCollection createProblemCollection() {
		final int aWidth = mModel.getWidth();
		final int aHeight = mModel.getHeight();
		StateManager aManager = StateManager.getInstance();
		
		final int aBufSize = aWidth*aHeight*3;
		StringBuffer aBuf = new StringBuffer(aBufSize);
		
		for (int y = 0; y < aHeight; ++y) {
			for (int x = 0; x < aWidth; ++x) {
				String aStr = aManager.findIdentityOf(mModel.getCurStateAt(x, y));
				aBuf.append(aStr).append(',');
			}
		}
		
		String aProblem = aBuf.substring(0, aBuf.length()-1);
		
		ProblemCollection aCollection = new ProblemCollection();
		aCollection.addProblem(new ProblemInfoBean(aWidth, aHeight, aProblem));
		
		return aCollection;
	}
	
	/**
	 *	w肵t@CɎw肵ۑ
	 *
	 *	@param	inOutFile	o͐
	 */
	private void saveProblem(File inFile, ProblemCollection inCollection) 
											throws SaveDiscompletedException
	{
		try {
			org.jibx.runtime.IBindingFactory aFactory = 
				org.jibx.runtime.BindingDirectory.getFactory(ProblemCollection.class);
	
			org.jibx.runtime.IMarshallingContext aContext = aFactory.createMarshallingContext();
			aContext.setIndent(4);
			
			aContext.marshalDocument(inCollection, "utf-8", null, new java.io.FileOutputStream(inFile));
		}
		catch (Exception e) {
			throw new SaveDiscompletedException("save discomplete");
		}
	}
	
	/**
	 *	w肵蕶load
	 *
	 *	@param inInfo 
	 */
	private void load(ProblemInfo inInfo) {
		createBoard(inInfo.getWidth(), inInfo.getHeight());
		mModel.nextStateAt(0, 0); // (0, 0)̈ʒuANeBuƂĂ
		
		mModel.setProblem(inInfo);
		

		
		if (mModel.isModified()) {
//			MenuManager.currentMenuManager().setEnabledFor(CreatorMenuID.ITEM_SAVE, false);
//			mIsModified = false;
			enableMenu(CreatorMenuID.ITEM_SAVE, false);
			
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}		
	}

	/**
	 *	Ֆʂ
	 */
	private void clearAll() {
		mModel.setModelState(ModelStateUtility.createClearAllState());
		mModel.reset();
		mModel.setModelState(ModelStateUtility.createSolverModelState(mIsCreatorMode));
		
		if (mModel.isModified()) {
			MenuManager.currentMenuManager().setEnabledFor(CreatorMenuID.ITEM_CLEAR, false);
			
			if (! isModified()) {
				mIsModified = true;
				MenuManager.currentMenuManager().setEnabledFor(CreatorMenuID.ITEM_SAVE, true);
			}
			
			Rectangle aBounds = getClipBounds();
			repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
		}
	}
	
	/**
	 *	BoardKwƂÅKw̐eݒ肷
	 *
	 *	@param	inBoard	̊Kw̐eƂȂBoard
	 */
	public void setParent(BoardView inParentBoard) {
		mParent = inParentBoard;
	}
	
	
	/**
	 *	@return PiecẽTCYԂ
	 */
	private int getPieceSize() {
		return mRenderer.getPieceSize().height;
	}
	
	/**
	 *	@return	gƊ֘AtꂽCOmponentԂ
	 */
	public java.awt.Component getComponent() {
		return this;
	}
		
	/**
	 *	̃R|[lgInsetsԂ
	 *
	 *	@return	̃R|[lgInsets
	 */
	public java.awt.Insets getInsets() {
		final int aPiece = getPieceSize();
		
		return new java.awt.Insets(aPiece, aPiece, aPiece, aPiece);
	}
	
	/**
	 *	Board̃TCYZbg
	 *
	 *	@param	inWidth 
	 *	@param	inHeight 
	 */
	private void setComponentSize(final int inWidth, final int inHeight) {
		setSize(inWidth, inHeight);
	}
	
	public Dimension getPreferredSize() {
		return getComponentSize();
	}
	
	private Dimension getComponentSize() {
		Dimension aSize = new Dimension(mRenderer.getBoardSize());
		java.awt.Insets aInsets = getInsets();

		aSize.width += aInsets.left + aInsets.right;
		aSize.height += aInsets.top + aInsets.bottom;
		
		return aSize;
	}
	/**
	 *	BoardɃtH[JXڂǂ߂
	 */
	public void setFocus(boolean inFocused) {
		mParent.setFocus(inFocused);
	}
	
	/**
	 *	BoardɃtH[JX݂邩ǂ`FbN
	 *
	 *	@return	tH[JXꍇtrueԂB
	 */
	public boolean isFocused() {
		return mParent.isFocused();
	}
	
	private void enableMenu(String inMenuID, boolean inEnabled) {
		MenuManager.currentMenuManager().setEnabledFor(inMenuID, inEnabled);		
	}
	
	private void changeMenuCheckMark(String inMenuID, boolean inChecked) {
			MenuManager.currentMenuManager().setCheckMark(inMenuID, inChecked);
	}
	
	private class MouseHandler implements 
									KeyListener, MouseListener
	{
		private final Point ILLEGAL = ModelConstants.ILLEGAL_POS;
		
		private Point mActivePiece;
		
		MouseHandler(Point inInitPos) {
			mActivePiece = inInitPos;
		}
		
		public void keyPressed(KeyEvent inEvent) {
			// modifierL[ƂɉĂꍇ́ȀŔB
			if (0 < inEvent.getModifiers()) return;
			
			final int aPressedCode = inEvent.getKeyCode();
			
			// DeleteL[ABack spaceL[ꂽꍇ̓Z̏Ԃ󔒏Ԃɖ߂
			if (aPressedCode == KeyEvent.VK_DELETE || aPressedCode == KeyEvent.VK_BACK_SPACE) 
			{
				StateEventCode aCode = HashikakeStateEventCode.createSpaceCode();
				mModel.nextStateAt(mActivePiece.x, mActivePiece.y, aCode);
				
				if (mModel.isModified()) {
					if (mIsCreatorMode) {
						try {
							mModel.reset();
							mSolverHandler.reset();
							// mSolverHandler.nextSoluteAll();
							while (! mSolverHandler.nextSoluteAll()) ;
						}
						catch (SolveDiscompleteException e) {
						}
					}
					
					enableMenu(CreatorMenuID.ITEM_SAVE, true);
					enableMenu(CreatorMenuID.ITEM_CLEAR, true);
					mIsModified = true;; 

				}
			}
			else if (aPressedCode == KeyEvent.VK_LEFT || aPressedCode == KeyEvent.VK_RIGHT
				|| aPressedCode == KeyEvent.VK_UP || aPressedCode == KeyEvent.VK_DOWN)
			{
				// ꂽL[J[\L[̏ꍇ
				// ɑאڂʒuactiveɂ
				// ̈ʒudeactiveɂ
				
				// אڈʒu̎擾
				Direction aDirection = UtilityFuncs.resolveDirectionOf(aPressedCode);
				Point aDif = aDirection.getDifference();
				
				StateEventCode aCode = UtilityFuncs.getSelectionEventCode();
				mModel.nextStateAt(aDif.x, aDif.y, aCode);
				
				if (mModel.isModified()) {
					mActivePiece.translate(aDif.x, aDif.y);
					final int aPieceSize = getPieceSize();
					java.awt.Insets aInsets = getInsets();

					Rectangle aBounds = new Rectangle(
						 		aInsets.left + mActivePiece.x*aPieceSize + getX(), 
						 		aInsets.top + mActivePiece.y*aPieceSize + getY(), 
						 		aPieceSize, aPieceSize
					);
					
					KeyScrollCommand aEvent = new KeyScrollCommand(Board.this, aBounds);
					AWTDispatchCommandQueue.postCommand(aEvent);
				}
			}
			else {
				try {
					// ꂽL[ł΁A
					// Z̏Ԃw肵̏ԂɑJڂ
					final int aVal = Integer.parseInt(KeyEvent.getKeyText(aPressedCode));
					
					// ́A1 ` 8̂ݔF߂B
					if (aVal > 0 && aVal < 9) {
						StateEventCode aCode = HashikakeStateEventCode.createNumberCodeOf(aVal);
						mModel.nextStateAt(mActivePiece.x, mActivePiece.y, aCode);
						
						if (mModel.isModified()) {
							if (mIsCreatorMode) {
								if (! mModel.isSpaceAt(mActivePiece.x, mActivePiece.y)
									|| mSolverHandler.isSolute())
								{
									mModel.reset();
									mSolverHandler.reset();
									// mSolverHandler.nextSoluteAll();
									while (! mSolverHandler.nextSoluteAll()) ;
								}
							}
							
//							mSolverHandler.addSolvePosAt(mActivePiece.x, mActivePiece.y);
							enableMenu(CreatorMenuID.ITEM_SAVE, true);
							enableMenu(CreatorMenuID.ITEM_CLEAR, true);
							mIsModified = true; 

						}
						
					}
				}
				catch (NumberFormatException e) {
					// ȊÕL[ł΁AȂ
					return;
				}
				catch (SolveDiscompleteException e) {
				}
			}

			// Model̏ԂύXĂꍇ̂ݍĕ`悷B
			if (mModel.isModified()) {
				Rectangle aBounds = getClipBounds();
				repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
			}
		}
		
		public void mousePressed(MouseEvent inEvent) {

			
			// BoardfocusꍇAmouse movehandling
			if (! isFocused()) return;

			final int aX = inEvent.getX();
			final int aY = inEvent.getY();
			
			Point aPos = calcPortToBoardPos(aX, aY);

			// aPos̈ʒuactiveɂ
			mModel.nextStateAt(aPos.x, aPos.y);

			// Model̏ԂύXĂꍇ̂ݍĕ`悷B
			if (mModel.isModified()) {
				// activepieceL^Ă
				mActivePiece = aPos;
				
				Rectangle aBounds = getClipBounds();
				
				repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
//				repaint(0, 0, 0, 0);
			}
		}
		
		public void keyReleased(KeyEvent inEvent) {}
		public void keyTyped(KeyEvent inEvent) {}
		
		public void mouseClicked(MouseEvent inEvent) {}
		public void mouseReleased(MouseEvent inEvent) {}
		public void mouseEntered(MouseEvent inEvent) {}
		public void mouseExited(MouseEvent inEvent) {}
	}
}

