// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		HashikakeNumberState.java
//	DATE:		2003.8.13
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.fsm;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

/**
 *	HASHIKAKE gamê߂̐\
 */
public class HashikakeNumberState implements State {
	public static class AdjacentState extends AbstractState {
		private State mState;
		private Direction mDirection;
		
		public AdjacentState(State inState, Direction inDirection) {
			mState = inState;
			mDirection = inDirection;
		}
		
		public State getState() {
			return mState;
		}
		
		public void setState(State inState) {
			mState = inState;
		}
		
		public Direction getDirection() {
			return mDirection;
		}
	}
	
	private State mNumberState;
	private AdjacentState mAdjacent[];
	private State mColorState = new DefaultColorState();
	
	public HashikakeNumberState(State inState, State inAdjacent) {
		// inStateNumberStatẽCX^X̂݋
		if (inState instanceof NumberState) {
			mNumberState = inState;
		}
		else {
			throw new IllegalArgumentException(
				"A specifiying state should be NumberState"
				+ "(passed state : " + inState.getClass() + ")"
			);
		}
		
		mAdjacent = new AdjacentState[] {
			new AdjacentState(inAdjacent, Direction.NORTH), 
			new AdjacentState(inAdjacent, Direction.SOUTH), 
			new AdjacentState(inAdjacent, Direction.WEST), 
			new AdjacentState(inAdjacent, Direction.EAST), 
		};
	}
	
	public State getNumberState() {
		return mNumberState;
	}
	
	public AdjacentState getAdjacentAt(final int inIndex) {
		return mAdjacent[inIndex];
	}
	
	public AdjacentState findAdjacentOf(Direction inDirection) {
		for (int i = 0; i < mAdjacent.length; ++i) {
			if (mAdjacent[i].getDirection() == inDirection) {
				return mAdjacent[i];
			}
		}
		
		return null;
	}
	
	public int getAdjacentCount() {
		return mAdjacent.length;
	}
	
	public void setColorState(ColorState inState) {
		mColorState = inState;
	}
	
	public State getColorState() {
		return mColorState;
	}
	
	public State onEnter(StateEventCode inEvent) {
		return this;
	}
}