// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		MenuManager.java
//	DATE:		2003.6.11
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.MenuBar;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;

import java.awt.event.WindowEvent;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ComponentUsher;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;

/**
 *	Menu쐬AMenuɑ΂CxgdispatchNX
 */
public class MenuManager {
	private static java.util.Map sLookupManager = new java.util.HashMap(); 
	private static MenuDispatcher sDispatcher = new MenuDispatcher();
	
	private static MenuBarBean sBean;
	
	public static void initMenuBarInfo(java.net.URL inResource) {
		try {
			if (null == inResource) {
				throw new java.io.FileNotFoundException();
			}
			
			IBindingFactory aFactory = 
				BindingDirectory.getFactory(MenuBarBean.class);
			
			IUnmarshallingContext aContext = 
				aFactory.createUnmarshallingContext();
			
			sBean = (MenuBarBean)aContext.unmarshalDocument(inResource.openStream(), null);
		}
		catch (java.io.IOException e) {
			System.out.println(
				"The property file : " + inResource.getFile() + " is no existance"
			);
			
			e.printStackTrace(System.out);
			System.exit(-1);
		}
		catch (JiBXException e) {
			System.out.println(
				"Cannot make MenuInfoBean from the property file : "
				 + inResource.getFile()
			);
			
			e.printStackTrace(System.out);
			System.exit(-1);
		}
	}
	
	public static MenuManager currentMenuManager() {
		BoardView aComp = (BoardView)ComponentUsher.getInstance().getActiveComponent();
		
		return currentMenuManager(aComp);
	}
	
	public static MenuManager currentMenuManager(BoardView inView) {
		// w肵Frameɑ΂MenuManagerȂꍇA
		// IllegalStateException𑗏oAIB
		if (! sLookupManager.containsKey(inView.getComponent())) {
			throw new IllegalStateException(
				"The MenuManager for the specified frame isnot registered.\n"
				+"Calling MenuManager.createMenuManager() leads to register the manager for specified the frame ."
			);
		}
		
		return (MenuManager)sLookupManager.get(inView.getComponent());
	}
	
	public static MenuBar createMenuManager(BoardView inView) {
		if (null == sBean) {
			throw new IllegalStateException(
				"The menu infomation is not initialized. \n"
				+ "Calling initMenuBarInfo(File) is to initialize it."
			);
		}
		
		MenuManager aManager = null;
	
		// ɓo^Ăꍇ́Aēo^Ȃ
		if (sLookupManager.containsKey(inView)) {
			aManager = (MenuManager)sLookupManager.get(inView);
		}
		else {
			aManager = new MenuManager();
			aManager.initialize();		
			sLookupManager.put(inView.getComponent(), aManager);
		}
		
		return aManager.getMenuBar();
	}
	
	private java.util.Map mLookupMenu = new java.util.HashMap(); 
	private MenuBar mMenuBar;

	private void initialize() {
		mMenuBar = new MenuBar();
	
		for (int i = 0; i < sBean.getMenuCount(); ++i) {
		
			MenuItem aItem = ((MenuElementBean)sBean.getMenuElementAt(i)).createMenuItem(this);
			
			if (aItem instanceof Menu) {
				mMenuBar.add((Menu)aItem);
			}
		}
	}
	
	ActionListener getActionDispatcher() {
		return sDispatcher;
	}
	
	void installDelegateAction(String inActionCommand, String inActionClass) {
		sDispatcher.installDelegateAction(inActionCommand, inActionClass);
	}
	
	void installMenuItem(String inLabel, MenuItem inMenu) {
		mLookupMenu.put(inLabel, inMenu);
	}
	
	public MenuBar getMenuBar() {
		return mMenuBar;
	}
	
	public void setEnabledFor(String inMenuID, final boolean inEnabled) {
		if (! mLookupMenu.containsKey(inMenuID)) {
			throw new IllegalArgumentException(
						"The Menu with the specified ID is no existance.");
		}
		
		MenuItem aItem = (java.awt.MenuItem)mLookupMenu.get(inMenuID);
		aItem.setEnabled(inEnabled);
	}
	
	public void setCheckMark(String inMenuID, final boolean inChecked) {
		if (! mLookupMenu.containsKey(inMenuID)) {
			throw new IllegalArgumentException(
						"The Menu with the specified ID is no existance.");
		}
		
		MenuItem aItem = (MenuItem)mLookupMenu.get(inMenuID);
		
		if (aItem instanceof java.awt.CheckboxMenuItem) {
			((java.awt.CheckboxMenuItem)aItem).setState(inChecked);
		}
	}

	private static class MenuDispatcher implements java.awt.event.ActionListener {
		private static class ActionEntry {
			String mCommand;
			String mClassName;
			ActionListener mListener;
			
			ActionEntry(String inCommand, String inClassName) {
				mCommand = inCommand;
				mClassName = inClassName;
			}
			
			ActionListener getListener() throws ActionNotFoundException {
				if (null != mListener) return mListener;
				
				try {
					Class aClass = Class.forName(mClassName);
					
					mListener = (ActionListener)aClass.newInstance();
				}
				catch (ClassNotFoundException e) {
					System.out.println("The specified action class is no existance");
					throw new ActionNotFoundException(mClassName);
				}
				catch (InstantiationException e) {
					System.out.println("The specified action class could not be instantiated");					
					throw new ActionNotFoundException(mClassName);
				}
				catch (IllegalAccessException e) {
					System.out.println("Could not be accessed in the default constructor");
					throw new ActionNotFoundException(mClassName);
				}
				
				return mListener;
			}
		}
		
		java.util.Map mRealListenerMap = new java.util.HashMap();
		
		public void actionPerformed(java.awt.event.ActionEvent inEvent) {
			new Thread(new MenuDispatchThread(inEvent), "MenuDispatchThread").start();
		}
		
		void installDelegateAction(String inActionCommand, String inActionClass) {
			ActionEntry aEntry = (ActionEntry)mRealListenerMap.get(inActionCommand);

			if (null == aEntry) {
				aEntry = new ActionEntry(inActionCommand, inActionClass);
				mRealListenerMap.put(inActionCommand, aEntry);
			}
		}
		
		private class MenuDispatchThread implements Runnable {
			private java.awt.event.ActionEvent mEvent;
			
			MenuDispatchThread(java.awt.event.ActionEvent inEvent) {
				mEvent = inEvent;
			}
			
			public void run() {
				String aCommand = ((java.awt.MenuItem)mEvent.getSource()).getActionCommand();
				
				try {
					ActionEntry aEntry = (ActionEntry)mRealListenerMap.get(aCommand);
					aEntry.getListener().actionPerformed(mEvent);
				}
				catch (ActionNotFoundException e) {
					System.out.println(e);
					e.printStackTrace(System.out);
				}
				
			}
		}
	}
}


