// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		RootBoardContainer.java
//	DATE:		2003.6.11	initial version
//	MODIFIED:	2003.8.10	[hLZAt[\ł΃t[j悤ɂ
//	CREATOR:		Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.view;

import java.io.File;

import java.awt.Component;
import java.awt.Frame;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.Usherable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ComponentUsher;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.ProblemMarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveCanceledException;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.SaveCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;

/**
 *	MVCViewɑΉ鍜iۃNX
 *	
 *	View͊Kw\琬ÃNX͊Kw̃[gɓ
 *	[g͏ȂƂ1̔Ֆʂ̕`ΏۂƂȂTuR|[lgȂΐȂB
 */
public abstract class RootBoardContainer 
			implements BoardView, Usherable, 
						ProblemUnmarshalable, ProblemMarshalable
{
	// Frameꖇ̃Vtg
	private static final int OFFSET_POS_PER_FRAME = 24;
	private static int sOffsetCount = 0;

	/** ^Cg */
	private static String sInitialTitle = "<untitled>";
	
	/** qView */
	protected BoardView mDecorated;
	
	/** R|[lg */
	private Frame mComponent;
	
	/** ̃R|[lgfocus邩ǂtO */
	private boolean mFocused;
	
	private boolean mMarshalAware = false;
	
	private boolean mIsCanceled = false;
	
	/**
	 *	RXgN^
	 *
	 *	@param	inComponent	BoardContainerŃbvR|[lg
	 */
	protected RootBoardContainer(Frame inComponent) {
		mComponent = inComponent;
	}
	
	/**
	 *	Ֆʂ̏s
	 *	̃\bhĂ΂AinitializeSelf()
	 *	addBoard()ĂсA
	 *	Ֆʂ̕\sR|[lgZbgĂ
	 *	TuR|[lgZbgĂȂꍇA
	 *	IllegalStateExceptionoB
	 *
	 *	@exception	IllegalStateException
	 */
	public final void initialize() {
		initializeSelf();
		
		// Frame̐ATCYɉĈʒu𒲐B
		alignPos();
		
		throwIfUninitialized();
		
		mDecorated.initialize();
		
		// default window listenero^
		mComponent.addWindowListener(new WindowHandler());
		
		mComponent.pack();
		
	}
	
	/**
	 *	Frame̐ATCYɉĈʒu𒲐B
	 */
	protected void alignPos() {
		int aPos = OFFSET_POS_PER_FRAME*sOffsetCount;
		
		++sOffsetCount;
		
		java.awt.Dimension aScreenSize
			 = GUIUtility.getEffectiveScreenSize();
			 
		if (aScreenSize.width < aPos + getComponent().getWidth()
				 || aScreenSize.height < aPos + getComponent().getHeight()) 
		{
			sOffsetCount = 0;
			aPos = 0;
		}
		
		getComponent().setLocation(aPos, aPos);
	}
	
	/**
	 *	̃R|[lg
	 */
	protected abstract void initializeSelf();
	
	/**
	 *	TuR|[lgB
	 *
	 *	@param	inSubBoard TuR|[lg
	 */
	protected final void addBoard(BoardView inSubBoard) {
		mComponent.add(inSubBoard.getComponent());
		
		mDecorated = inSubBoard;
		
		inSubBoard.setParent(this);
	}
	
	/**
	 *	̃R|[lg̐eZbg
	 *	Rootɑ΂e݂͑Ȃ߁A
	 *	̎ł́AUnsupportedOperationException𑗏oB
	 *
	 *	@param	inParent ̃R|[lg̐e
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public void setParent(BoardView inParent) {
		throw new UnsupportedOperationException(
			"The Parent of root board is no existance."
		);
	}

	/**
	 *	ՖʂύXĂ邩ǂ`FbNB
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final boolean isModified() {
		throwIfUninitialized();
		
		return mDecorated.isModified();
	}
	
	/**
	 *	w肵t@CɁA쐬蕶ۑ
	 *
	 *	@param	inFile ۑƂȂt@C
	 *	@return	ۑɊւ
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final void saveProblem(File inFile) throws SaveCanceledException {
		mIsCanceled = false;
		
		// OptionPane̕\ɂAcomponentdeactiveɂȂĂ
		// \邽߁AăZbg
		if (! ComponentUsher.getInstance().isActiveComponent(this)) {
			ComponentUsher.getInstance().setActiveComponent(this);
		}
		
		if (0 <= inFile.getName().indexOf(sInitialTitle)) {
			saveProblemAs();
			repaint();
		}
		else {
			// ۑs
			processCommand(new SaveCommand(this, inFile));
		}
	}
	
	/**
	 *	w肵t@Cɖ蕶ۑ
	 *	蕶Save_CAOŎw肵t@CɕۑB
	 *
	 *	@throws	SaveCanceledException ۑLZꂽꍇɂ΂B
	 */
	public final void saveProblemAs() throws SaveCanceledException {
		javax.swing.JFileChooser aChooser = GUIUtility.createFileChooser();

		// Save Dialog\B
		final int aSignal = aChooser.showSaveDialog(mComponent);
		
		if (aSignal == javax.swing.JFileChooser.CANCEL_OPTION) {
			throw new SaveCanceledException("The save operation is canceled.");
		}
		else if (aSignal == javax.swing.JFileChooser.APPROVE_OPTION) {
			// Save Dialog̕\ɂAcomponentdeactiveɂȂĂ
			// \邽߁AăZbg
			if (! ComponentUsher.getInstance().isActiveComponent(this)) {
				ComponentUsher.getInstance().setActiveComponent(this);
			}
			
			// ۑs
			File aFile = aChooser.getSelectedFile();
			String aFileName = aFile.getAbsolutePath();
			
			int aPos = aFileName.lastIndexOf(".xml");
			if (0 > aPos) {
				// gq .xmlt
				aFileName += ".xml";
				aFile = new File(aFileName);
			}
			
			AWTDispatchCommandQueue.postCommand(new SaveCommand(this, aFile));
			setTitle(aFileName);
		}	
	}

	/**
	 *	w肵蕶load
	 *	̎ł́Asubcomponentɏ]
	 *
	 *	@param inInfo 
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	 */
	public final void load(ProblemInfo inInfo) {
		processCommand(new LoadCommand(this, inInfo));
		
		if (! mComponent.isVisible()) {
			show();
		}
	}
	
	/**
	 *	w肵蕶load
	 *
	 *	@param inInfo 
	 */
	public final void loadProblem(File inFile, ProblemInfo inInfo) {
		if (this != ComponentUsher.getInstance().getActiveComponent()) {
			ComponentUsher.getInstance().setActiveComponent(this);
		}
		
		setTitle(inFile.getAbsolutePath());
		load(inInfo);
	}
	
	/**
	 *	̃[hLZꂽꍇɌĂ΂
	 */
	public final void loadCanceled() {
		// LoadOwner܂\ĂȂꍇABoad͔j
		if (! mComponent.isVisible()) {
			java.awt.event.WindowEvent aEvent = new java.awt.event.WindowEvent(
				mComponent, 
				java.awt.event.WindowEvent.WINDOW_CLOSING
			);
			java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
		}
	}
	
	/**
	 *	̃vOŁAۑo悤ɂ
	 */
	public void setMarshalAware() {
		mMarshalAware =	true;
	}
	
	/**
	 *	̃vOŁAۑo邩ǂ`FbN
	 */
	public boolean isMarshalAware() {
		return mMarshalAware;
	}
	
	/**
	 *	@return	gƊ֘AtꂽComponentԂ
	 */
	public final Component getComponent() {
		return mComponent;
	}
	
	/**
	 *	Framẽ^Cgw肵ɕύX
	 *	̎ł́Aw肵ɃvOtĂB
	 *
	 *	@param	inTitle ^CgƂĐݒ肷镶
	 */
	public final void setTitle(String inTitle) {
		mComponent.setTitle(modifiyTitleString(inTitle));
	}
	
	/**
	 *	^CgƂăZbg镶ɏC
	 *
	 *	@param inOldTitle CO̕
	 *	@return	C̕
	 */
	protected abstract String modifiyTitleString(String inOldTitle);
	
	/**
	 *	@return	݂̃^Cg擾
	 */
	public final String getTitle() {
		return mComponent.getTitle();
	}

	/**
	 *	̃{[hɍĕ`w
	 *	̎ł́ATuR|[lgɏ]
	 *
	 *	@exception	UnsupportedOperationException
	 *				TuR|[lgĂȂꍇ
	*/	 
	public final void repaint() {
		throwIfUninitialized();
		
		mDecorated.repaint();
	}
	
	/**
	 *	Ֆʂ̊es[X̃TCYw肵TCYɕύX
	 *
	 *	@param	inSize ύX̃TCY
	 */
	public final void setPieceSize(final int inSize) {
	}
	
	/**
	 *	̃R|[lg̃TCYύX
	 *
	 *	@param	inWidth		
	 *	@param	inHeight	
	 */
	public final void setComponentSize(final int inWidth, final int inHeight) {
		java.awt.Dimension aScreenSize = GUIUtility.getEffectiveScreenSize();
		
		// frameTCYscreen傫Ƃscreen sizeɂ킹
		java.awt.Dimension aPrefSize = mComponent.getPreferredSize();
		int aWidth = aPrefSize.width;
		int aHeight = aPrefSize.height;
		
		final int aX = mComponent.getX();
		final int aY = mComponent.getY();
		
		if (aX + aWidth > aScreenSize.width) aWidth = aScreenSize.width-aX;
		if (aY + aHeight > aScreenSize.height) aHeight = aScreenSize.height-aY;

		mComponent.setSize(aWidth, aHeight);
		mComponent.validate();
	}
	
	/**
	 *	̃R|[lg폜
	 */
	protected final void dispose() {
		mComponent.dispose();
	}
	
	/**
	 *	̃R|[lgɃtH[JX邩ǂ`FbN
	 *
	 *	@return	tH[JXtrueԂB
	 */
	public final boolean isFocused() {
		return mFocused;
	}
	
	/**
	 *	̃R|[lg̃tH[JXLw肵boollɕύX
	 *
	 *	@param	̃R|[lgɃtH[JXꍇAtruew肷B
	 */
	public final void setFocus(boolean inFocused) {
		mFocused = inFocused;
	}
	
	/**
	 *	ۑLZꂽꍇɌĂԃ\bh
	 *	ʏAOASaveCanceledExceptioncatchߓŌĂ
	 */
	protected final void saveCanceled() {
		TerminateManager aManager = TerminateManager.getInstance();
		if (aManager.isTerminateThread()) {
			aManager.cancel();
		}
		
		mIsCanceled = true;
	}
	
	/**
	 *	TuR|[lgĂ邩ǂ`FbNA
	 *	ĂȂꍇAO𑗏o
	 *
	 *	@exception	IllegalStateException
	 */
	private void throwIfUninitialized() {
		if (null == mDecorated) {
			throw new IllegalStateException(
					"The subcompoment is initialized."
					+ "To Call with addBoard() method lead to register it."
			);
		}
	}
	
	/**
	 *	Frame\
	 *	̎ł́Aevent dispatch threadŕ\悤d
	 */
	public void show() {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				mComponent.show();
			}
		});
	}

	/**
	 *	Commands
	 *	̎ł́ÃvZXŏłȂƂA
	 *	艺ʂCommandContainerŎw肵CommandƂA
	 *	Command]
	 *
	 *	@param	inCommand	Command
	 */	
	 public void processCommand(Command inCommand) {
	 	// I̕ۑ̏ꍇAۑ܂ŁAȌ̏ubN
	 	if (! availableDispose(inCommand)) return;
	 
		// w肵Command̏܂ĂȂ
		// ACommandContainerŏłꍇ
		if (! inCommand.isConsumed()) {
			processCommandImpl(inCommand);
		}
		
		if (! inCommand.isConsumed()) {
			if (inCommand instanceof AbstractTopDownCommand) {
				mDecorated.processCommand(inCommand);
			}
		}
	}
	
	/**
	 *	Command̎
	 *
	 *	@param	inCommand	Command
	 */
	protected abstract void processCommandImpl(Command inCommand);
	
	private boolean availableDispose(Command inCommand) {
		if (inCommand.getClass() != DisposeLatterCommand.class) return true;

		return disposeLatter();
	}
	
	/**
	 *	^CgAۑƂȂt@C𒊏o
	 *	ۑKvƂAvŁAKvɉăI[o[Ch
	 *	ftHgł́Aw肳ꂽ^Cĝ܂ܕԂB
	 *
	 *	@param	inTitle	^Cg
	 *
	 *	@return	ot@C
	 */
	protected String parseTitleToFileName(String inTitle) {
		return inTitle;
	}
	
	private boolean disposeLatter() {
		if (isMarshalAware()) {
			if (isModified() && ! mIsCanceled) {
				AWTDispatchCommandQueue.postCommand(new DisposeLatterCommand(this));
				
				return false;
			}
		}
		
		// Frame
		ComponentUsher.getInstance().uninstall(this);
		dispose();
		
		// ׂẴt[ꂽꍇ́AAvI
		if (0 == ComponentUsher.getInstance().getComponentCount()) {
			System.out.println("all frame is closed");
			System.exit(0);
		}
		
		return true;
	}
	
	private static class DisposeLatterCommand extends AbstractCommand {
		public DisposeLatterCommand(CommandContainer inCommander) {
			super (inCommander);
		}
	}

	private class WindowHandler implements WindowListener {
		public void windowClosing(WindowEvent inEvent) {	
			if (isMarshalAware() && isModified()) {
				try {
					String aFileName = parseTitleToFileName(getTitle());
					
					final int aSignal = 
						GUIUtility.showBoardModifiedNotice(getComponent(), aFileName, true);
					
					if (javax.swing.JOptionPane.YES_OPTION == aSignal) {
						// ɗ_ŁASaveCanceledExceptionɍsƂ͂Ȃ
						saveProblem(new java.io.File(aFileName));
					}
					else if (javax.swing.JOptionPane.CANCEL_OPTION == aSignal) {
						throw new SaveCanceledException("frame closing process is canceled");
					}
					else if (javax.swing.JOptionPane.NO_OPTION == aSignal) {
						mIsCanceled = true;
					}
				}
				catch (SaveCanceledException e) {
					saveCanceled();
					return;
				}
			}
			
			disposeLatter();
		}
		
		public void windowActivated(WindowEvent inEvent) {
			ComponentUsher.getInstance().setActiveComponent(getComponent());
		}
		
		public void windowDeactivated(WindowEvent inEvent) {
			ComponentUsher.getInstance().setActiveComponent();
		}
		
		public void windowOpened(WindowEvent inEvent) {}
		public void windowClosed(WindowEvent inEvent) {}
		public void windowIconified(WindowEvent inEvent) {}
		public void windowDeiconified(WindowEvent inEvent) {}
	}
}